/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.match.engine.IMatchEngine;
import org.eclipse.emf.compare.match.filter.IResourceFilter;
import org.eclipse.emf.compare.match.filter.ResourceFilterRegistry;
import org.eclipse.emf.compare.match.internal.service.DefaultMatchEngineSelector;
import org.eclipse.emf.compare.match.internal.statistic.ResourceSimilarity;
import org.eclipse.emf.compare.match.metamodel.MatchFactory;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.compare.match.metamodel.UnmatchModel;
import org.eclipse.emf.compare.match.service.IMatchEngineSelector;
import org.eclipse.emf.compare.match.service.MatchEngineDescriptor;
import org.eclipse.emf.compare.match.service.MatchEngineRegistry;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchService {
    private static final String DEFAULT_EXTENSION = "ecore";
    private static final Set<Resource> FRAGMENT_RESOURCES = new HashSet<Resource>();
    private static IMatchEngineSelector matchEngineSelector = new DefaultMatchEngineSelector();

    private MatchService() {
    }

    public static MatchModel doContentMatch(EObject leftObject, EObject rightObject, EObject ancestor, Map<String, Object> options) throws InterruptedException {
        String extension = MatchService.getBestExtension(leftObject.eResource(), rightObject.eResource(), ancestor.eResource());
        IMatchEngine engine = MatchService.getBestMatchEngine(extension);
        MatchModel result = engine.contentMatch(leftObject, rightObject, ancestor, options);
        engine.reset();
        return result;
    }

    public static MatchModel doContentMatch(EObject leftObject, EObject rightObject, Map<String, Object> options) throws InterruptedException {
        String extension = MatchService.getBestExtension(leftObject.eResource(), rightObject.eResource());
        IMatchEngine engine = MatchService.getBestMatchEngine(extension);
        MatchModel result = engine.contentMatch(leftObject, rightObject, options);
        engine.reset();
        return result;
    }

    public static MatchModel doMatch(EObject leftRoot, EObject rightRoot, EObject ancestor, Map<String, Object> options) throws InterruptedException {
        String extension = MatchService.getBestExtension(leftRoot.eResource(), rightRoot.eResource(), ancestor.eResource());
        IMatchEngine engine = MatchService.getBestMatchEngine(extension);
        MatchModel result = engine.modelMatch(leftRoot, rightRoot, ancestor, options);
        engine.reset();
        return result;
    }

    public static MatchModel doMatch(EObject leftRoot, EObject rightRoot, Map<String, Object> options) throws InterruptedException {
        String extension = MatchService.getBestExtension(leftRoot.eResource(), rightRoot.eResource());
        IMatchEngine engine = MatchService.getBestMatchEngine(extension);
        MatchModel result = engine.modelMatch(leftRoot, rightRoot, options);
        engine.reset();
        return result;
    }

    public static MatchModel doResourceMatch(Resource leftResource, Resource rightResource, Map<String, Object> options) throws InterruptedException {
        String extension = MatchService.getBestExtension(leftResource, rightResource);
        IMatchEngine engine = MatchService.getBestMatchEngine(extension);
        MatchModel result = engine.resourceMatch(leftResource, rightResource, options);
        engine.reset();
        return result;
    }

    public static MatchModel doResourceMatch(Resource leftResource, Resource rightResource, Resource ancestorResource, Map<String, Object> options) throws InterruptedException {
        String extension = MatchService.getBestExtension(leftResource, rightResource, ancestorResource);
        IMatchEngine engine = MatchService.getBestMatchEngine(extension);
        MatchModel result = engine.resourceMatch(leftResource, rightResource, ancestorResource, options);
        engine.reset();
        return result;
    }

    public static MatchResourceSet doResourceSetMatch(ResourceSet leftResourceSet, ResourceSet rightResourceSet, Map<String, Object> options) throws InterruptedException {
        UnmatchModel unmatched;
        Resource matchedResource;
        MatchService.resolveAll(leftResourceSet);
        MatchService.resolveAll(rightResourceSet);
        ArrayList<Resource> remainingLeftResources = new ArrayList<Resource>((Collection<Resource>)leftResourceSet.getResources());
        ArrayList<Resource> remainingRightResources = new ArrayList<Resource>((Collection<Resource>)rightResourceSet.getResources());
        MatchService.removeFragments(remainingLeftResources, remainingRightResources);
        MatchService.filterResources(remainingLeftResources, remainingRightResources);
        MatchResourceSet match = MatchFactory.eINSTANCE.createMatchResourceSet();
        for (Resource res : new ArrayList(remainingLeftResources)) {
            matchedResource = MatchService.findMatchingResource(res, remainingRightResources);
            if (matchedResource == null || MatchService.findMatchingResource(matchedResource, remainingLeftResources) != res) continue;
            remainingLeftResources.remove(res);
            remainingRightResources.remove(matchedResource);
            match.getMatchModels().add((Object)MatchService.doResourceMatch(res, matchedResource, options));
        }
        for (Resource res : new ArrayList(remainingLeftResources)) {
            matchedResource = MatchService.findMatchingResource(res, remainingRightResources);
            if (matchedResource != null && MatchService.findMatchingResource(matchedResource, remainingLeftResources) == res) {
                remainingLeftResources.remove(res);
                remainingRightResources.remove(matchedResource);
                match.getMatchModels().add((Object)MatchService.doResourceMatch(res, matchedResource, options));
                continue;
            }
            unmatched = MatchFactory.eINSTANCE.createUnmatchModel();
            unmatched.setSide(Side.LEFT);
            unmatched.getRoots().addAll(MatchService.getResourceRoots(res));
            remainingLeftResources.remove(res);
            match.getUnmatchedModels().add((Object)unmatched);
        }
        for (Resource res : new ArrayList<Resource>(remainingRightResources)) {
            matchedResource = MatchService.findMatchingResource(res, remainingLeftResources);
            if (matchedResource != null && MatchService.findMatchingResource(matchedResource, remainingRightResources) == res) {
                remainingLeftResources.remove(matchedResource);
                remainingRightResources.remove(res);
                match.getMatchModels().add((Object)MatchService.doResourceMatch(matchedResource, res, options));
                continue;
            }
            unmatched = MatchFactory.eINSTANCE.createUnmatchModel();
            unmatched.setSide(Side.RIGHT);
            unmatched.getRoots().addAll(MatchService.getResourceRoots(res));
            remainingLeftResources.remove(res);
            match.getUnmatchedModels().add((Object)unmatched);
        }
        return match;
    }

    public static MatchResourceSet doResourceSetMatch(ResourceSet leftResourceSet, ResourceSet rightResourceSet, ResourceSet ancestorResourceSet, Map<String, Object> options) throws InterruptedException {
        UnmatchModel unmatched;
        Resource matchedAncestor;
        Resource matchedRight;
        MatchService.resolveAll(leftResourceSet);
        MatchService.resolveAll(rightResourceSet);
        MatchService.resolveAll(ancestorResourceSet);
        ArrayList<Resource> remainingLeftResources = new ArrayList<Resource>((Collection<Resource>)leftResourceSet.getResources());
        ArrayList<Resource> remainingRightResources = new ArrayList<Resource>((Collection<Resource>)rightResourceSet.getResources());
        ArrayList<Resource> remainingAncestorResources = new ArrayList<Resource>((Collection<Resource>)ancestorResourceSet.getResources());
        MatchService.removeFragments(remainingLeftResources, remainingRightResources, remainingAncestorResources);
        MatchService.filterResources(remainingLeftResources, remainingRightResources, remainingAncestorResources);
        MatchResourceSet match = MatchFactory.eINSTANCE.createMatchResourceSet();
        for (Resource res : new ArrayList(remainingLeftResources)) {
            matchedRight = MatchService.findMatchingResource(res, remainingRightResources);
            matchedAncestor = MatchService.findMatchingResource(res, remainingAncestorResources);
            if (matchedRight == null || MatchService.findMatchingResource(matchedRight, remainingLeftResources) != res || matchedAncestor == null || MatchService.findMatchingResource(matchedAncestor, remainingLeftResources) != res) continue;
            remainingLeftResources.remove(res);
            remainingRightResources.remove(matchedRight);
            remainingAncestorResources.remove(matchedAncestor);
            match.getMatchModels().add((Object)MatchService.doResourceMatch(res, matchedRight, matchedAncestor, options));
        }
        for (Resource res : new ArrayList(remainingLeftResources)) {
            matchedRight = MatchService.findMatchingResource(res, remainingRightResources);
            matchedAncestor = MatchService.findMatchingResource(res, remainingAncestorResources);
            if (matchedRight != null && MatchService.findMatchingResource(matchedRight, remainingLeftResources) == res) {
                remainingLeftResources.remove(res);
                remainingRightResources.remove(matchedRight);
                if (matchedAncestor != null && MatchService.findMatchingResource(matchedAncestor, remainingLeftResources) == res) {
                    remainingAncestorResources.remove(matchedAncestor);
                    match.getMatchModels().add((Object)MatchService.doResourceMatch(res, matchedRight, matchedAncestor, options));
                    continue;
                }
                match.getMatchModels().add((Object)MatchService.doResourceMatch(res, matchedRight, options));
                continue;
            }
            remainingLeftResources.remove(res);
            if (matchedAncestor != null && MatchService.findMatchingResource(matchedAncestor, remainingLeftResources) == res) {
                unmatched = MatchFactory.eINSTANCE.createUnmatchModel();
                unmatched.setSide(Side.LEFT);
                unmatched.getRoots().addAll(MatchService.getResourceRoots(res));
                unmatched.setRemote(true);
                remainingAncestorResources.remove(matchedAncestor);
                match.getUnmatchedModels().add((Object)unmatched);
                continue;
            }
            unmatched = MatchFactory.eINSTANCE.createUnmatchModel();
            unmatched.setSide(Side.LEFT);
            unmatched.getRoots().addAll(MatchService.getResourceRoots(res));
            match.getUnmatchedModels().add((Object)unmatched);
        }
        for (Resource res : new ArrayList<Resource>(remainingRightResources)) {
            Resource matchedLeft = MatchService.findMatchingResource(res, remainingLeftResources);
            matchedAncestor = MatchService.findMatchingResource(res, remainingAncestorResources);
            if (matchedLeft != null && MatchService.findMatchingResource(matchedLeft, remainingRightResources) == res) {
                remainingLeftResources.remove(matchedLeft);
                remainingRightResources.remove(res);
                if (matchedAncestor != null && MatchService.findMatchingResource(matchedAncestor, remainingLeftResources) == res) {
                    remainingAncestorResources.remove(matchedAncestor);
                    match.getMatchModels().add((Object)MatchService.doResourceMatch(matchedLeft, res, matchedAncestor, options));
                    continue;
                }
                match.getMatchModels().add((Object)MatchService.doResourceMatch(matchedLeft, res, options));
                continue;
            }
            remainingRightResources.remove(res);
            if (matchedAncestor != null && MatchService.findMatchingResource(matchedAncestor, remainingLeftResources) == res) {
                unmatched = MatchFactory.eINSTANCE.createUnmatchModel();
                unmatched.setSide(Side.RIGHT);
                unmatched.getRoots().addAll(MatchService.getResourceRoots(res));
                unmatched.setRemote(true);
                remainingAncestorResources.remove(matchedAncestor);
                match.getUnmatchedModels().add((Object)unmatched);
                continue;
            }
            unmatched = MatchFactory.eINSTANCE.createUnmatchModel();
            unmatched.setSide(Side.RIGHT);
            unmatched.getRoots().addAll(MatchService.getResourceRoots(res));
            match.getUnmatchedModels().add((Object)unmatched);
        }
        return match;
    }

    public static IMatchEngine getBestMatchEngine(String extension) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFComparePlugin.getDefault().getBoolean("emfcompare.engine.selection")) {
            MatchEngineDescriptor desc = MatchService.getBestDescriptor(extension);
            return desc.getEngineInstance();
        }
        return MatchEngineRegistry.INSTANCE.getHighestEngine(extension);
    }

    public static void setMatchEngineSelector(IMatchEngineSelector selector) {
        matchEngineSelector = selector;
    }

    private static List<EObject> getResourceRoots(Resource res) {
        ArrayList<EObject> roots = new ArrayList<EObject>((Collection<EObject>)res.getContents());
        if (res.getContents().isEmpty()) {
            EObject proxy = EcoreFactory.eINSTANCE.createEObject();
            ((InternalEObject)proxy).eSetProxyURI(res.getURI().appendFragment("/"));
            roots.add(proxy);
        }
        return roots;
    }

    private static void filterResources(List<Resource> ... resources) {
        for (IResourceFilter filter : ResourceFilterRegistry.INSTANCE.getRegisteredResourceFilters()) {
            if (resources.length == 2) {
                filter.filter(resources[0], resources[1]);
                continue;
            }
            filter.filter(resources[0], resources[1], resources[2]);
        }
    }

    private static MatchEngineDescriptor getBestDescriptor(String extension) {
        List<MatchEngineDescriptor> engines = MatchEngineRegistry.INSTANCE.getDescriptors(extension);
        MatchEngineDescriptor engine = null;
        if (engines.size() == 1) {
            engine = engines.iterator().next();
        } else if (engines.size() > 1) {
            engine = matchEngineSelector.selectMatchEngine(engines);
        }
        return engine;
    }

    private static String getBestExtension(Resource ... resources) {
        String extension = null;
        int i = 0;
        while (i < resources.length) {
            if (resources[i] == null) {
                extension = DEFAULT_EXTENSION;
                break;
            }
            if (resources[i].getURI() != null) {
                if (extension == null) {
                    extension = resources[i].getURI().fileExtension();
                } else if (!extension.equals(resources[i].getURI().fileExtension())) {
                    extension = DEFAULT_EXTENSION;
                    break;
                }
            }
            ++i;
        }
        return extension;
    }

    private static void removeFragments(List<Resource> ... resources) {
        for (Resource resource : FRAGMENT_RESOURCES) {
            List<Resource>[] listArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                List<Resource> res = listArray[n2];
                res.remove(resource);
                ++n2;
            }
        }
        FRAGMENT_RESOURCES.clear();
    }

    private static void resolveAll(ResourceSet resourceSet) {
        EList resources = resourceSet.getResources();
        int i = 0;
        while (i < resources.size()) {
            TreeIterator resourceContent = ((Resource)resources.get(i)).getAllContents();
            while (resourceContent.hasNext()) {
                EObject eObject = (EObject)resourceContent.next();
                Resource childResource = eObject.eResource();
                if (childResource != null && childResource != resources.get(i)) {
                    FRAGMENT_RESOURCES.add(childResource);
                }
                Iterator objectChildren = eObject.eCrossReferences().iterator();
                while (objectChildren.hasNext()) {
                    objectChildren.next();
                }
            }
            ++i;
        }
    }

    public static Resource findMatchingResource(Resource resource, List<Resource> candidates) {
        return ResourceSimilarity.findMatchingResource(resource, candidates);
    }
}

