/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Element;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.ui.TypedElementWrapper;
import org.eclipse.emf.compare.ui.internal.ModelComparator;
import org.eclipse.emf.compare.ui.util.EMFCompareEObjectUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCompareInput
implements ICompareInput {
    private Resource ancestorResource;
    private final DiffModel diff;
    private List<DiffElement> diffList;
    private final List<ICompareInputChangeListener> inputChangeListeners = new ArrayList<ICompareInputChangeListener>();
    private Resource leftResource;
    private final MatchModel match;
    private Resource rightResource;

    public ModelCompareInput(MatchModel matchModel, DiffModel diffModel) {
        this.match = matchModel;
        this.diff = diffModel;
    }

    public ModelCompareInput(MatchModel matchModel, DiffModel diffModel, ModelComparator comparator) {
        this(matchModel, diffModel);
        this.leftResource = comparator.getLeftResource();
        this.rightResource = comparator.getRightResource();
        this.ancestorResource = comparator.getAncestorResource();
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.inputChangeListeners.add(listener);
    }

    public void copy(boolean leftToRight) {
        ArrayList<DiffElement> differences = new ArrayList<DiffElement>((Collection<DiffElement>)this.diff.getOwnedElements());
        this.doCopy(differences, leftToRight);
        this.fireCompareInputChanged();
    }

    public void copy(DiffElement element, boolean leftToRight) {
        this.doCopy(element, leftToRight);
        this.fireCompareInputChanged();
    }

    public void copy(List<DiffElement> elements, boolean leftToRight) {
        this.doCopy(elements, leftToRight);
        this.fireCompareInputChanged();
    }

    public ITypedElement getAncestor() {
        TypedElementWrapper ancestor = null;
        if (this.ancestorResource != null) {
            if (this.ancestorResource.getContents().size() > 0) {
                ancestor = new TypedElementWrapper((EObject)this.ancestorResource.getContents().get(0));
            }
        } else {
            TreeIterator matchIterator = this.match.eAllContents();
            EObject root = null;
            while (matchIterator.hasNext()) {
                EObject matchElement = (EObject)matchIterator.next();
                if (!(matchElement instanceof Match3Element)) continue;
                root = (EObject)((Match3Element)matchElement).getOriginElement().eResource().getContents().get(0);
                break;
            }
            ancestor = new TypedElementWrapper(root);
        }
        return ancestor;
    }

    public DiffModel getDiff() {
        return this.diff;
    }

    public List<DiffElement> getDiffAsList() {
        if (this.diffList == null) {
            this.diffList = new ArrayList<DiffElement>();
            ArrayList<ModelElementChange> modelElementDiffs = new ArrayList<ModelElementChange>();
            ArrayList<AttributeChange> attributeChangeDiffs = new ArrayList<AttributeChange>();
            ArrayList<ReferenceChange> referenceChangeDiffs = new ArrayList<ReferenceChange>();
            TreeIterator iterator = this.getDiff().eAllContents();
            while (iterator.hasNext()) {
                DiffElement aDiff = (DiffElement)iterator.next();
                if (aDiff instanceof ModelElementChange) {
                    modelElementDiffs.add((ModelElementChange)aDiff);
                    continue;
                }
                if (aDiff instanceof AttributeChange) {
                    attributeChangeDiffs.add((AttributeChange)aDiff);
                    continue;
                }
                if (aDiff instanceof ReferenceChange) {
                    referenceChangeDiffs.add((ReferenceChange)aDiff);
                    continue;
                }
                if (aDiff instanceof DiffGroup) continue;
                this.diffList.add(aDiff);
            }
            this.diffList.addAll(modelElementDiffs);
            this.diffList.addAll(attributeChangeDiffs);
            this.diffList.addAll(referenceChangeDiffs);
            modelElementDiffs.clear();
            attributeChangeDiffs.clear();
            referenceChangeDiffs.clear();
        }
        return this.diffList;
    }

    public Image getImage() {
        Image image = null;
        if (this.getMatch() != null) {
            image = EMFCompareEObjectUtils.computeObjectImage((EObject)this.getMatch());
        } else if (this.getDiff() != null) {
            image = EMFCompareEObjectUtils.computeObjectImage((EObject)this.getDiff());
        }
        return image;
    }

    public int getKind() {
        if (this.getAncestor() != null) {
            return 12;
        }
        return 0;
    }

    public ITypedElement getLeft() {
        TypedElementWrapper left = null;
        if (this.leftResource != null) {
            if (this.leftResource.getContents().size() > 0) {
                left = new TypedElementWrapper((EObject)this.leftResource.getContents().get(0));
            }
        } else {
            TreeIterator matchIterator = this.match.eAllContents();
            EObject root = null;
            while (matchIterator.hasNext()) {
                EObject matchElement = (EObject)matchIterator.next();
                if (!(matchElement instanceof Match2Elements)) continue;
                root = (EObject)((Match2Elements)matchElement).getLeftElement().eResource().getContents().get(0);
                break;
            }
            left = new TypedElementWrapper(root);
        }
        return left;
    }

    public MatchModel getMatch() {
        return this.match;
    }

    public String getName() {
        String name = null;
        if (this.getMatch() != null) {
            name = EMFCompareEObjectUtils.computeObjectName((EObject)this.getMatch());
        } else if (this.getDiff() != null) {
            name = EMFCompareEObjectUtils.computeObjectName((EObject)this.getDiff());
        }
        return name;
    }

    public ITypedElement getRight() {
        TypedElementWrapper right = null;
        if (this.rightResource != null) {
            if (this.rightResource.getContents().size() > 0) {
                right = new TypedElementWrapper((EObject)this.rightResource.getContents().get(0));
            }
        } else {
            TreeIterator matchIterator = this.match.eAllContents();
            EObject root = null;
            while (matchIterator.hasNext()) {
                EObject matchElement = (EObject)matchIterator.next();
                if (!(matchElement instanceof Match2Elements)) continue;
                root = (EObject)((Match2Elements)matchElement).getRightElement().eResource().getContents().get(0);
                break;
            }
            right = new TypedElementWrapper(root);
        }
        return right;
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.inputChangeListeners.remove(listener);
    }

    protected void doCopy(DiffElement element, boolean leftToRight) {
        MergeService.merge((DiffElement)element, (boolean)leftToRight);
    }

    protected void doCopy(List<DiffElement> elements, boolean leftToRight) {
        MergeService.merge(elements, (boolean)leftToRight);
    }

    protected void fireCompareInputChanged() {
        this.diffList.clear();
        this.diffList = null;
        for (ICompareInputChangeListener listener : this.inputChangeListeners) {
            listener.compareInputChanged((ICompareInput)this);
        }
    }
}

