/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.services;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.ui.areas.AbstractModelSearchCompositeArea;
import org.eclipse.emf.search.ui.areas.IModelSearchArea;
import org.eclipse.emf.search.ui.areas.IModelSearchAreaFactory;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.emf.search.ui.pages.AbstractModelSearchPage;
import org.eclipse.emf.search.utils.ModelSearchImagesUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;

public class QueryTabDescriptor {
    public static final String QUERY_AREA_ID = "id";
    public static final String QUERY_AREA_LABEL_ID = "label";
    public static final String QUERY_AREA_TOOLTIP_ID = "tooltip";
    public static final String QUERY_IDX_ID = "index";
    public static final String QUERY_TARGET_SEARCH_PAGE_ID = "targetSearchPageID";
    public static final String QUERY_COMPOSITE_AREA_CLASS = "queryCompositeArea";
    public static final String QUERY_COMPOSITE_AREA_FACTORY_CLASS = "queryCompositeAreaFactory";
    public static final String QUERY_IMAGE_ID = "image";
    public String ID;
    public String label;
    public String tooltip;
    public int idx;
    public String targetSearchPageID;
    public IModelSearchArea queryModelSearchArea;
    public IModelSearchAreaFactory queryCompositeAreaFactory;
    public Image image;
    private IConfigurationElement configElement;

    public QueryTabDescriptor(IConfigurationElement element) throws CoreException {
        this.configElement = element;
        this.load();
    }

    private void load() throws CoreException {
        Bundle bundle = Platform.getBundle((String)this.configElement.getNamespaceIdentifier());
        this.ID = this.configElement.getAttribute(QUERY_AREA_ID);
        this.label = this.configElement.getAttribute(QUERY_AREA_LABEL_ID);
        this.tooltip = this.configElement.getAttribute(QUERY_AREA_TOOLTIP_ID);
        this.targetSearchPageID = this.configElement.getAttribute(QUERY_TARGET_SEARCH_PAGE_ID);
        this.queryCompositeAreaFactory = (IModelSearchAreaFactory)this.configElement.createExecutableExtension(QUERY_COMPOSITE_AREA_FACTORY_CLASS);
        this.image = ModelSearchImagesUtil.getImageDescriptor((Bundle)bundle, (String)this.configElement.getAttribute(QUERY_IMAGE_ID)).createImage();
        String indexStringValue = this.configElement.getAttribute(QUERY_IDX_ID);
        try {
            this.idx = Integer.parseInt(indexStringValue);
        }
        catch (NumberFormatException numberFormatException) {
            this.idx = 0;
        }
        if (this.ID == null || this.queryCompositeAreaFactory == null || this.label == null || this.image == null || this.targetSearchPageID == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getContributor().getName(), 0, String.valueOf(Messages.getString("QueryTabDescriptor.invalidExtensionErrorMessage")) + this.ID, null));
        }
    }

    public String getID() {
        return this.ID;
    }

    public int getIndex() {
        return this.idx;
    }

    public IModelSearchAreaFactory getQueryCompositeAreaFactory() {
        return this.queryCompositeAreaFactory;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public IModelSearchArea createArea(Composite parent, AbstractModelSearchPage searchPage) {
        this.queryModelSearchArea = this.queryCompositeAreaFactory.createArea(parent, searchPage);
        if (this.queryModelSearchArea instanceof AbstractModelSearchCompositeArea) {
            ((AbstractModelSearchCompositeArea)this.queryModelSearchArea).getDataMap().put("SETTINGS_PREFIX", searchPage.getID());
        }
        return this.queryModelSearchArea;
    }

    public IModelSearchArea getQueryModelSearchArea() {
        return this.queryModelSearchArea;
    }

    public Image getImage() {
        return this.image;
    }

    public String getTargetSearchPageID() {
        return this.targetSearchPageID;
    }
}

