/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.core.services;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.core.factories.IModelSearchQueryFactory;
import org.eclipse.emf.search.core.factories.IModelSearchQueryParametersFactory;
import org.eclipse.emf.search.core.resource.IModelResourceValidator;
import org.eclipse.emf.search.l10n.Messages;

public final class ModelSearchEngineDescriptor {
    public static final String MODEL_SEARCH_ENGINE_ID = "id";
    public static final String MODEL_SEARCH_ENGINE_LABEL_ID = "label";
    public static final String MODEL_SEARCH_ENGINE_QUERY_CLASS_ID = "searchQueryFactory";
    public static final String MODEL_SEARCH_ENGINE_PARAMETERS_CLASS_ID = "queryParametersFactory";
    public static final String MODEL_SEARCH_ENGINE_RESOURCE_VALIDATOR_CLASS_ID = "modelResourceValidator";
    private String ID;
    private String label;
    private IModelSearchQueryFactory modelSearchQueryFactory;
    private IModelSearchQueryParametersFactory modelSearchParametersFactory;
    private IModelResourceValidator modelResourceValidator;
    private IConfigurationElement configElement;

    public ModelSearchEngineDescriptor(IConfigurationElement element) throws CoreException {
        this.configElement = element;
        this.load();
    }

    private void load() throws CoreException {
        this.ID = this.configElement.getAttribute(MODEL_SEARCH_ENGINE_ID);
        this.label = this.configElement.getAttribute(MODEL_SEARCH_ENGINE_LABEL_ID);
        this.modelSearchQueryFactory = (IModelSearchQueryFactory)this.configElement.createExecutableExtension(MODEL_SEARCH_ENGINE_QUERY_CLASS_ID);
        this.modelSearchParametersFactory = (IModelSearchQueryParametersFactory)this.configElement.createExecutableExtension(MODEL_SEARCH_ENGINE_PARAMETERS_CLASS_ID);
        this.modelResourceValidator = (IModelResourceValidator)this.configElement.createExecutableExtension(MODEL_SEARCH_ENGINE_RESOURCE_VALIDATOR_CLASS_ID);
        if (this.ID == null || this.label == null || this.modelSearchParametersFactory == null || this.modelSearchQueryFactory == null || this.modelResourceValidator == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getContributor().getName(), 0, String.valueOf(Messages.getString("ModelSearchEngineDescriptor.invalidExtensionErrorMessage")) + this.ID, null));
        }
    }

    public String getID() {
        return this.ID;
    }

    public String getLabel() {
        return this.label;
    }

    public IModelSearchQueryParametersFactory getModelSearchParametersFactory() {
        return this.modelSearchParametersFactory;
    }

    public IModelSearchQueryFactory getModelSearchQueryFactory() {
        return this.modelSearchQueryFactory;
    }

    public IModelResourceValidator getModelResourceValidator() {
        return this.modelResourceValidator;
    }
}

