/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.adapter;

import java.util.Set;
import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.IBinding;
import org.eclipse.net4j.examples.mvc.adapter.AdapterAspectData;
import org.eclipse.net4j.examples.mvc.util.AbstractAspectDataMap;
import org.eclipse.net4j.examples.mvc.util.NoTargetException;
import org.eclipse.net4j.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAdapter<TARGET>
extends AbstractAspectDataMap<AdapterAspectData<TARGET>, TARGET>
implements IAdapter<TARGET> {
    private TARGET target;

    public AbstractAdapter(IAdapter.Factory<TARGET> factory) {
        Class[] aspects;
        Class[] classArray = aspects = factory.getAspects();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class aspect = classArray[n];
            this.ensureAspectData(aspect);
            ++n;
        }
    }

    @Override
    public TARGET getTarget() throws NoTargetException {
        return this.target;
    }

    @Override
    public void setTarget(TARGET target) {
        Class aspect;
        int n;
        int n2;
        Class[] classArray;
        if (this.target == target) {
            return;
        }
        Class[] aspects = this.getAspects();
        if (this.target != null) {
            classArray = aspects;
            n2 = 0;
            n = classArray.length;
            while (n2 < n) {
                aspect = classArray[n2];
                this.disconnectTarget(aspect);
                ++n2;
            }
        }
        this.target = target;
        if (this.target != null) {
            classArray = aspects;
            n2 = 0;
            n = classArray.length;
            while (n2 < n) {
                aspect = classArray[n2];
                this.connectTarget(aspect);
                ++n2;
            }
        }
        this.onRetarget();
    }

    protected Set<IBinding<TARGET>> getBindings(Class aspect) {
        AdapterAspectData data = (AdapterAspectData)this.getAspectData(aspect);
        return data.getBindings();
    }

    @Override
    public void addBinding(IBinding<TARGET> binding) {
        Set<IBinding<TARGET>> bindings = this.getBindings(binding.getAspect());
        bindings.add(binding);
        if (bindings.size() == 1) {
            this.connectTarget(binding.getAspect());
        }
    }

    @Override
    public boolean removeBinding(IBinding<TARGET> binding) {
        Set<IBinding<TARGET>> bindings = this.getBindings(binding.getAspect());
        bindings.remove(binding);
        if (bindings.size() == 0) {
            this.disconnectTarget(binding.getAspect());
            Class[] classArray = this.getAspects();
            int n = 0;
            int n2 = classArray.length;
            while (n < n2) {
                Class aspect = classArray[n];
                if (this.getBindings(aspect).size() > 0) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(StringHelper.getSimpleClassName(this.getClass())) + "(target: " + this.target + ")";
    }

    @Override
    protected AdapterAspectData<TARGET> createData() {
        return new AdapterAspectData();
    }

    protected void onRetarget() {
    }

    protected abstract void connectTarget(Class var1);

    protected abstract void disconnectTarget(Class var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractFactory<TARGET>
    implements IAdapter.Factory<TARGET> {
        private IAdapter.Manager<TARGET> adapterManager;

        @Override
        public IAdapter.Manager<TARGET> getAdapterManager() {
            return this.adapterManager;
        }

        public void setAdapterManager(IAdapter.Manager<TARGET> adapterManager) {
            this.adapterManager = adapterManager;
        }
    }
}

