/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.reconcile;

import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.common.reconcile.Decision;
import org.eclipse.gmf.internal.common.reconcile.DecisionMaker;

public class StringPatternDecisionMaker
extends DecisionMaker {
    private Pattern myPattern;

    public StringPatternDecisionMaker(String valuePattern, EAttribute attribute) {
        this(Pattern.compile(valuePattern), attribute);
    }

    public StringPatternDecisionMaker(Pattern valuePattern, EAttribute attribute) {
        super((EStructuralFeature)attribute);
        if (attribute.getEAttributeType() != EcorePackage.eINSTANCE.getEString()) {
            throw new IllegalArgumentException("Expected string attribute");
        }
        if (attribute.getUpperBound() != 1) {
            throw new IllegalArgumentException("Expected multiplicity [0..1] or [1]");
        }
        this.myPattern = valuePattern;
    }

    public Decision makeDecision(EObject current, EObject old) {
        String oldValue = (String)old.eGet(this.getFeature());
        if (oldValue != null && !this.myPattern.matcher(oldValue).matches()) {
            return Decision.PRESERVE_OLD;
        }
        return Decision.ACCEPT_NEW;
    }
}

