/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.dialogs.CopyToImageDialog;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.l10n.DiagramUIRenderMessages;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class CopyToImageAction
extends DiagramAction {
    private CopyToImageDialog dialog = null;

    public CopyToImageAction(IWorkbenchPage page) {
        super(page);
    }

    public void init() {
        super.init();
        this.setText(DiagramUIRenderMessages.CopyToImageAction_Label);
        this.setId("CopyToImageAction");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
    }

    public void run() {
        IPath path = null;
        String fileName = null;
        if (this.getWorkbenchPart() instanceof IEditorPart) {
            IFile file;
            IEditorPart editor = (IEditorPart)this.getWorkbenchPart();
            IContainer container = (IContainer)editor.getEditorInput().getAdapter(IContainer.class);
            if (container != null && container.exists()) {
                path = container.getLocation();
            }
            if (path == null && (file = (IFile)editor.getEditorInput().getAdapter(IFile.class)) != null) {
                path = file.getLocation().removeLastSegments(1);
                fileName = file.getLocation().removeFileExtension().lastSegment();
            }
        }
        this.dialog = new CopyToImageDialog(Display.getCurrent().getActiveShell(), path, fileName);
        if (this.dialog.open() == 1) {
            return;
        }
        if (!this.overwriteExisting()) {
            return;
        }
        Trace.trace((Plugin)DiagramUIRenderPlugin.getInstance(), (String)("Copy Diagram to " + this.dialog.getDestination().toOSString() + " as " + this.dialog.getImageFormat().toString()));
        MultiStatus status = new MultiStatus(DiagramUIRenderPlugin.getPluginId(), 0, DiagramUIRenderMessages.CopyToImageAction_Label, null);
        IRunnableWithProgress runnable = this.createRunnable(status);
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            progressMonitorDialog.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            Log.warning((Plugin)DiagramUIRenderPlugin.getInstance(), (int)9, (String)e.getTargetException().getMessage(), (Throwable)e.getTargetException());
            if (e.getTargetException() instanceof OutOfMemoryError) {
                this.openErrorDialog(DiagramUIRenderMessages.CopyToImageAction_outOfMemoryMessage);
            } else if (e.getTargetException() instanceof SWTError) {
                this.openErrorDialog(DiagramUIRenderMessages.CopyToImageAction_outOfMemoryMessage);
            } else {
                this.openErrorDialog(e.getTargetException().getMessage());
            }
            return;
        }
        catch (InterruptedException e) {
            Log.warning((Plugin)DiagramUIRenderPlugin.getInstance(), (int)9, (String)e.getMessage(), (Throwable)e);
        }
        if (!status.isOK()) {
            this.openErrorDialog(status.getChildren()[0].getMessage());
        }
    }

    private IRunnableWithProgress createRunnable(final MultiStatus status) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                block6: {
                    try {
                        try {
                            List editparts = CopyToImageAction.this.getOperationSet();
                            if (editparts.size() == 1 && editparts.get(0) instanceof DiagramEditPart) {
                                monitor.beginTask("", 6);
                                monitor.worked(1);
                                monitor.setTaskName(NLS.bind((String)DiagramUIRenderMessages.CopyToImageAction_copyingDiagramToImageFileMessage, (Object)CopyToImageAction.this.dialog.getDestination().toOSString()));
                                new CopyToImageUtil().copyToImage((DiagramEditPart)editparts.get(0), CopyToImageAction.this.dialog.getDestination(), CopyToImageAction.this.dialog.getImageFormat(), monitor);
                                break block6;
                            }
                            monitor.beginTask("", 6);
                            monitor.worked(1);
                            monitor.setTaskName(NLS.bind((String)DiagramUIRenderMessages.CopyToImageAction_copyingSelectedElementsToImageFileMessage, (Object)CopyToImageAction.this.dialog.getDestination().toOSString()));
                            new CopyToImageUtil().copyToImage(CopyToImageAction.this.getDiagramEditPart(), editparts, CopyToImageAction.this.dialog.getDestination(), CopyToImageAction.this.dialog.getImageFormat(), monitor);
                        }
                        catch (CoreException e) {
                            Log.warning((Plugin)DiagramUIRenderPlugin.getInstance(), (int)9, (String)e.getMessage(), (Throwable)e);
                            status.add(e.getStatus());
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        };
    }

    protected boolean calculateEnabled() {
        return !this.getOperationSet().isEmpty();
    }

    private void openErrorDialog(String message) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DiagramUIRenderMessages.CopyToImageAction_copyToImageErrorDialogTitle, (String)NLS.bind((String)DiagramUIRenderMessages.CopyToImageAction_copyToImageErrorDialogMessage, (Object)message));
    }

    private boolean overwriteExisting() {
        if (this.dialog.overwriteExisting()) {
            return true;
        }
        if (!this.dialog.getDestination().toFile().exists()) {
            return true;
        }
        return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)DiagramUIRenderMessages.CopyToImageAction_overwriteExistingConfirmDialogTitle, (String)NLS.bind((String)DiagramUIRenderMessages.CopyToImageAction_overwriteExistingConfirmDialogMessage, (Object)this.dialog.getDestination().toOSString()));
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.size() == 1) {
            Object editpart = selection.get(0);
            if (editpart instanceof DiagramEditPart) {
                return selection;
            }
            if (editpart instanceof ISurfaceEditPart) {
                selection = ((ISurfaceEditPart)editpart).getPrimaryEditParts();
            }
        }
        for (Object editpart : selection) {
            if (!(editpart instanceof ShapeEditPart)) continue;
            return selection;
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        try {
            this.getDiagramEditPart().getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    CopyToImageAction.this.run();
                }
            });
        }
        catch (Exception e) {
            Trace.catching((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"doRun()", (Throwable)e);
        }
    }

    protected CopyToImageUtil getCopyToImageUtil() {
        return new CopyToImageUtil();
    }
}

