/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemsAwareFreeFormLayer;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.GridLayerEx;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.PageBreakEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ZoomableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.PageBreaksFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageInfoHelper;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.DiagramRuler;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.MeasurementUnitHelper;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.ConnectionLayerEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScalableFreeformLayeredPane;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.mapmode.IMapModeHolder;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeTypes;
import org.eclipse.gmf.runtime.gef.ui.internal.editparts.AnimatableZoomManager;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class DiagramRootEditPart
extends ScalableFreeformRootEditPart
implements ZoomableEditPart,
IDiagramPreferenceSupport {
    private WrapperMapMode mm;
    private DiagramRuler verticalRuler;
    private DiagramRuler horizontalRuler;
    private AnimatableZoomManager zoomManager;
    private double[] zoomLevels = new double[]{0.05, 0.1, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 4.0};
    private PageBreakEditPart pageBreakEditPart;
    private PreferenceStoreListener listener = new PreferenceStoreListener();
    private org.eclipse.draw2d.ScalableFreeformLayeredPane layers;
    private PreferencesHint preferencesHint = PreferencesHint.USE_DEFAULTS;
    private int printableLayerIndex;
    private GridLayer gridLayer;
    public static final String PAGE_BREAKS_LAYER = "Page Breaks Layer";
    public static final String DECORATION_PRINTABLE_LAYER = "Decoration Printable Layer";
    public static final String DECORATION_UNPRINTABLE_LAYER = "Decoration Unprintable Layer";
    private static final int LIGHT_GRAY_RGB = 0xC0C0C0;

    public DiagramRootEditPart() {
    }

    public DiagramRootEditPart(MeasurementUnit mu) {
        if (this.getMapMode() != null) {
            this.mm.setContainedMapMode(MeasurementUnitHelper.getMapMode(mu));
        }
    }

    private void initPreferenceStoreListener() {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getPreferencesHint().getPreferenceStore();
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.listener);
    }

    private void removePreferenceStoreListener() {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getPreferencesHint().getPreferenceStore();
        preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.listener);
        this.listener = null;
    }

    protected LayeredPane createPrintableLayers() {
        FreeformLayeredPane layeredPane = new FreeformLayeredPane();
        layeredPane.add((IFigure)new BorderItemsAwareFreeFormLayer(), (Object)"Primary Layer");
        layeredPane.add((IFigure)new ConnectionLayerEx(), (Object)"Connection Layer");
        layeredPane.add((IFigure)new FreeformLayer(), (Object)DECORATION_PRINTABLE_LAYER);
        return layeredPane;
    }

    protected void moveGridLayer(boolean inFront) {
        if (this.layers.getChildren().indexOf(this.gridLayer) > this.printableLayerIndex && !inFront) {
            this.layers.remove((IFigure)this.gridLayer);
            this.layers.add((IFigure)this.gridLayer, (Object)"Grid Layer", this.printableLayerIndex);
        } else if (this.layers.getChildren().indexOf(this.gridLayer) <= this.printableLayerIndex && inFront) {
            this.layers.remove((IFigure)this.gridLayer);
            this.layers.add((IFigure)this.gridLayer, (Object)"Grid Layer", this.printableLayerIndex + 1);
        }
    }

    protected org.eclipse.draw2d.ScalableFreeformLayeredPane createScaledLayers() {
        this.layers = this.createScalableFreeformLayeredPane();
        this.layers.add((IFigure)new FreeformLayer(), (Object)PAGE_BREAKS_LAYER);
        this.printableLayerIndex = this.layers.getChildren().size();
        this.layers.add((IFigure)this.getPrintableLayers(), (Object)"Printable Layers");
        this.gridLayer = this.createGridLayer();
        this.layers.add((IFigure)this.gridLayer, (Object)"Grid Layer");
        this.layers.add((IFigure)new FreeformLayer(), (Object)DECORATION_UNPRINTABLE_LAYER);
        return this.layers;
    }

    protected org.eclipse.draw2d.ScalableFreeformLayeredPane createScalableFreeformLayeredPane() {
        return new DiagramScalableFreeformLayeredPane(this.getMapMode());
    }

    public ZoomManager getZoomManager() {
        if (this.zoomManager == null) {
            this.zoomManager = new AnimatableZoomManager((ScalableFigure)this.getScaledLayers(), (Viewport)this.getFigure());
            this.zoomManager.setZoomLevels(this.zoomLevels);
            this.refreshEnableZoomAnimation((ZoomManager)this.zoomManager);
        }
        return this.zoomManager;
    }

    public void zoomTo(double zoom, Point center) {
        this.zoomManager.zoomTo(zoom, center);
    }

    public void zoomTo(Rectangle rect) {
        this.zoomManager.zoomTo(rect);
    }

    public void zoomIn() {
        this.zoomManager.zoomIn();
    }

    public void zoomIn(Point center) {
        this.zoomManager.zoomTo(this.zoomManager.getNextZoomLevel(), center);
    }

    public void zoomOut() {
        this.zoomManager.zoomOut();
    }

    public void zoomOut(Point center) {
        this.zoomManager.zoomTo(this.zoomManager.getPreviousZoomLevel(), center);
    }

    protected IPreferenceStore getWorkspaceViewerPreferences() {
        if (this.getViewer() == null) {
            return null;
        }
        return ((DiagramGraphicalViewer)this.getViewer()).getWorkspaceViewerPreferenceStore();
    }

    public double getGridSpacing() {
        double gridSpacing = 0.0;
        if (this.getWorkspaceViewerPreferences() != null) {
            gridSpacing = this.getWorkspaceViewerPreferences().getDouble("rulergrid.gridspacing");
        }
        if (gridSpacing == 0.0) {
            IPreferenceStore pluginStore = (IPreferenceStore)this.getPreferencesHint().getPreferenceStore();
            gridSpacing = pluginStore.getDouble("GridRuler.gridSpacing");
        }
        return gridSpacing;
    }

    public void setGridStyle(int style) {
        if (this.gridLayer instanceof GridLayerEx) {
            ((GridLayerEx)this.gridLayer).setLineStyle(style);
        }
        this.gridLayer.repaint();
    }

    public void setGridColor(Integer rgbValue) {
        this.gridLayer.setForegroundColor(DiagramColorRegistry.getInstance().getColor(rgbValue));
    }

    public void setGridSpacing(double gridSpacing) {
        int rulerUnits = 0;
        if (this.getWorkspaceViewerPreferences() != null) {
            rulerUnits = this.getWorkspaceViewerPreferences().getInt("rulergrid.rulerunit");
        }
        double dotsPerInch = Display.getDefault().getDPI().x;
        int spacingInPixels = 0;
        switch (rulerUnits) {
            case 0: {
                spacingInPixels = (int)Math.round(dotsPerInch * gridSpacing);
                break;
            }
            case 1: {
                spacingInPixels = (int)Math.round(dotsPerInch * gridSpacing / 2.54);
                break;
            }
            default: {
                spacingInPixels = (int)gridSpacing;
            }
        }
        int spacing = this.getMapMode().DPtoLP(spacingInPixels);
        this.getViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(spacing, spacing));
    }

    public PageBreakEditPart getPageBreakEditPart() {
        if (this.pageBreakEditPart == null) {
            this.pageBreakEditPart = new PageBreakEditPart();
            this.pageBreakEditPart.setParent((EditPart)this);
        }
        return this.pageBreakEditPart;
    }

    protected void refreshPageBreaks() {
        if (this.getWorkspaceViewerPreferences().getBoolean("viewpagebreaks")) {
            this.showPageBreaks();
        } else {
            this.hidePageBreaks();
        }
    }

    private void showPageBreaks() {
        this.getLayer(PAGE_BREAKS_LAYER).add(this.getPageBreakEditPart().getFigure());
        Point p = new Point(this.getWorkspaceViewerPreferences().getInt("pagebreak.x"), this.getWorkspaceViewerPreferences().getInt("pagebreak.y"));
        this.getPageBreakEditPart().set(p, PageInfoHelper.getChildrenBounds((DiagramEditPart)this.getContents(), PageBreaksFigure.class));
    }

    private void hidePageBreaks() {
        if (this.getLayer(PAGE_BREAKS_LAYER).getChildren().contains(this.getPageBreakEditPart().getFigure())) {
            this.getLayer(PAGE_BREAKS_LAYER).remove(this.getPageBreakEditPart().getFigure());
            this.getPageBreakEditPart().updatePreferenceStore();
        }
    }

    private void handlePreferenceStorePropertyChanged(PropertyChangeEvent event) {
        if ("viewpagebreaks".equals(event.getProperty())) {
            this.refreshPageBreaks();
        } else if (this.isPageSizeChange(event.getProperty())) {
            Rectangle diagramBounds = PageInfoHelper.getChildrenBounds((DiagramEditPart)this.getContents(), PageBreaksFigure.class);
            this.getPageBreakEditPart().resize(diagramBounds);
            this.getPageBreakEditPart().updatePreferenceStore();
            this.refreshPageBreaks();
        } else if ("rulergrid.viewgrid".equals(event.getProperty())) {
            this.getViewer().setProperty("SnapToGrid.isVisible", event.getNewValue());
        } else if ("rulergrid.snaptogrid".equals(event.getProperty())) {
            this.getViewer().setProperty("SnapToGeometry.isEnabled", event.getNewValue());
        } else if ("rulergrid.gridlevel".equals(event.getProperty())) {
            this.moveGridLayer((Boolean)event.getNewValue());
        } else if ("rulergrid.gridspacing".equals(event.getProperty())) {
            Double spacing = (Double)event.getNewValue();
            this.setGridSpacing(spacing);
        } else if ("rulergrid.viewrulers".equals(event.getProperty())) {
            this.getViewer().setProperty("ruler$visibility", event.getNewValue());
        } else if ("rulergrid.rulerunit".equals(event.getProperty())) {
            Object newValue = event.getNewValue();
            if (newValue.getClass() == Integer.class) {
                int rulerUnits = (Integer)newValue;
                this.setRulers(rulerUnits);
            } else if (newValue.getClass() == String.class) {
                try {
                    int rulerUnits = Integer.parseInt((String)newValue);
                    this.setRulers(rulerUnits);
                }
                catch (NumberFormatException e) {
                    Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)5, (String)e.toString());
                }
            } else {
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)5, (String)newValue.getClass().getName());
            }
            Boolean oldValue = (Boolean)this.getViewer().getProperty("ruler$visibility");
            this.getViewer().setProperty("ruler$visibility", (Object)Boolean.FALSE);
            this.getViewer().setProperty("ruler$visibility", (Object)oldValue);
            double spacing = this.getGridSpacing();
            this.setGridSpacing(spacing);
        } else if ("rulergrid.gridlinecolor".equals(event.getProperty())) {
            Integer newValue = (Integer)event.getNewValue();
            this.setGridColor(newValue);
        } else if ("rulergrid.gridlinestyle".equals(event.getProperty())) {
            Integer newValue = (Integer)event.getNewValue();
            this.setGridStyle(newValue);
        } else if (event.getProperty().equals("Global.enableAnimatedZoom")) {
            this.refreshEnableZoomAnimation(this.getZoomManager());
        } else if (event.getProperty().equals("Global.enableAntiAlias")) {
            this.refreshEnableAntiAlias();
        }
    }

    private void setRulers(int rulerUnits) {
        if (this.getVerticalRuler() != null) {
            this.getVerticalRuler().setUnit(rulerUnits);
        } else {
            this.setVerticalRuler(new DiagramRuler(false, rulerUnits, null));
        }
        if (this.getHorizontalRuler() != null) {
            this.getHorizontalRuler().setUnit(rulerUnits);
        } else {
            this.setHorizontalRuler(new DiagramRuler(true, rulerUnits, null));
        }
    }

    private void refreshEnableZoomAnimation(ZoomManager zoomMangr) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getPreferencesHint().getPreferenceStore();
        boolean animatedZoom = preferenceStore.getBoolean("Global.enableAnimatedZoom");
        zoomMangr.setZoomAnimationStyle(animatedZoom ? 1 : 0);
    }

    public void refreshVisuals() {
        this.refreshEnableAntiAlias();
    }

    protected void refreshEnableAntiAlias() {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getPreferencesHint().getPreferenceStore();
        boolean antiAlias = preferenceStore.getBoolean("Global.enableAntiAlias");
        if (this.getLayers() instanceof ScalableFreeformLayeredPane) {
            ((ScalableFreeformLayeredPane)this.layers).setAntiAlias(antiAlias);
        }
    }

    protected void refreshRulerUnits() {
        if (this.getWorkspaceViewerPreferences() != null) {
            this.setRulers(this.getWorkspaceViewerPreferences().getInt("rulergrid.rulerunit"));
        }
    }

    public void performRequest(Request request) {
        if (request.getType().equals("recalculate_pagebreaks")) {
            this.getPageBreakEditPart().calculatePageBreakFigureBounds();
        }
    }

    public void activate() {
        super.activate();
        if (this.getWorkspaceViewerPreferences() != null) {
            this.getWorkspaceViewerPreferences().addPropertyChangeListener((IPropertyChangeListener)this.listener);
        }
        this.initPreferenceStoreListener();
        org.eclipse.draw2d.ScalableFreeformLayeredPane pane = this.getLayers();
        this.refreshEnableAntiAlias();
        this.initWorkspaceViewerProperties();
        this.refreshRulerUnits();
        if (pane instanceof ZoomListener) {
            this.getZoomManager().addZoomListener((ZoomListener)pane);
        }
    }

    private void initWorkspaceViewerProperties() {
        IPreferenceStore wsPrefStore = this.getWorkspaceViewerPreferences();
        if (wsPrefStore != null) {
            if (!wsPrefStore.contains("rulergrid.gridlevel")) {
                wsPrefStore.setValue("rulergrid.gridlevel", true);
            } else {
                this.moveGridLayer(wsPrefStore.getBoolean("rulergrid.gridlevel"));
            }
            if (!wsPrefStore.contains("rulergrid.gridlinecolor")) {
                wsPrefStore.setValue("rulergrid.gridlinecolor", 0xC0C0C0);
            } else {
                this.setGridColor(new Integer(wsPrefStore.getInt("rulergrid.gridlinecolor")));
            }
            if (!wsPrefStore.contains("rulergrid.gridlinestyle")) {
                wsPrefStore.setValue("rulergrid.gridlinestyle", 6);
            } else {
                this.setGridStyle(wsPrefStore.getInt("rulergrid.gridlinestyle"));
            }
            if (!wsPrefStore.contains("rulergrid.rulerunit") || !wsPrefStore.contains("rulergrid.gridspacing")) {
                IPreferenceStore preferenceStore = (IPreferenceStore)this.getPreferencesHint().getPreferenceStore();
                wsPrefStore.setValue("rulergrid.rulerunit", 999);
                wsPrefStore.setValue("rulergrid.rulerunit", preferenceStore.getInt("GridRuler.rulerUnits"));
                wsPrefStore.setValue("rulergrid.gridspacing", preferenceStore.getDouble("GridRuler.gridSpacing"));
            }
        }
    }

    public void deactivate() {
        if (this.getPageBreakEditPart() != null) {
            this.getPageBreakEditPart().updatePreferenceStore();
        }
        if (this.getWorkspaceViewerPreferences() != null) {
            this.getWorkspaceViewerPreferences().removePropertyChangeListener((IPropertyChangeListener)this.listener);
        }
        this.removePreferenceStoreListener();
        org.eclipse.draw2d.ScalableFreeformLayeredPane pane = this.getLayers();
        if (pane instanceof ZoomListener) {
            this.getZoomManager().removeZoomListener((ZoomListener)pane);
        }
        super.deactivate();
    }

    private boolean isPageSizeChange(String s) {
        return "print.margin.top".equals(s) || "print.margin.left".equals(s) || "print.margin.right".equals(s) || "print.margin.bottom".equals(s) || "print.page.size".equals(s) || "print.useLandscape".equals(s) || "print.usePortrait".equals(s) || "print.page.height".equals(s) || "print.page.width".equals(s) || "print.useDiagramSettings".equals(s);
    }

    protected org.eclipse.draw2d.ScalableFreeformLayeredPane getLayers() {
        return this.layers;
    }

    protected void setLayers(org.eclipse.draw2d.ScalableFreeformLayeredPane layers) {
        this.layers = layers;
    }

    public void setPreferencesHint(PreferencesHint preferenceHint) {
        this.preferencesHint = preferenceHint;
    }

    public PreferencesHint getPreferencesHint() {
        return this.preferencesHint;
    }

    public final IMapMode getMapMode() {
        if (this.mm == null) {
            this.mm = new WrapperMapMode();
        }
        return this.mm;
    }

    public DiagramRuler getHorizontalRuler() {
        return this.horizontalRuler;
    }

    private void setHorizontalRuler(DiagramRuler horizontalRuler) {
        this.horizontalRuler = horizontalRuler;
    }

    public DiagramRuler getVerticalRuler() {
        return this.verticalRuler;
    }

    private void setVerticalRuler(DiagramRuler verticalRuler) {
        this.verticalRuler = verticalRuler;
    }

    protected GridLayer createGridLayer() {
        return new GridLayerEx();
    }

    protected GridLayer createGridLayer(int r, int g, int b) {
        return new GridLayerEx(new Color(null, r, g, b));
    }

    protected static class DiagramScalableFreeformLayeredPane
    extends ScalableFreeformLayeredPane
    implements ZoomListener {
        public DiagramScalableFreeformLayeredPane(IMapMode mm) {
            super(mm);
        }

        public void zoomChanged(double zoom) {
            ScaledGraphics.resetFontCache();
        }
    }

    class FeedbackLayer
    extends FreeformLayer {
        FeedbackLayer() {
            this.setEnabled(false);
        }
    }

    private class PreferenceStoreListener
    implements IPropertyChangeListener {
        private PreferenceStoreListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            DiagramRootEditPart.this.handlePreferenceStorePropertyChanged(event);
        }
    }

    private class WrapperMapMode
    implements IMapModeHolder {
        IMapMode containedMM = MapModeTypes.DEFAULT_MM;

        public void setContainedMapMode(IMapMode mm) {
            this.containedMM = mm;
        }

        public int DPtoLP(int deviceUnit) {
            return this.containedMM.DPtoLP(deviceUnit);
        }

        public Translatable DPtoLP(Translatable t) {
            return this.containedMM.DPtoLP(t);
        }

        public int LPtoDP(int logicalUnit) {
            return this.containedMM.LPtoDP(logicalUnit);
        }

        public Translatable LPtoDP(Translatable t) {
            return this.containedMM.LPtoDP(t);
        }

        public IMapMode getMapMode() {
            return this.containedMM;
        }
    }
}

