/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.notation.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.FlatEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Sorting;
import org.eclipse.gmf.runtime.notation.SortingDirection;
import org.eclipse.gmf.runtime.notation.SortingStyle;

public class SortingStyleImpl
extends FlatEObjectImpl
implements SortingStyle {
    protected static final Sorting SORTING_EDEFAULT = Sorting.NONE_LITERAL;
    protected Sorting sorting = SORTING_EDEFAULT;
    protected static final Map SORTING_KEYS_EDEFAULT = Collections.EMPTY_MAP;
    protected Map sortingKeys = SORTING_KEYS_EDEFAULT;
    protected EList sortedObjects = null;

    protected SortingStyleImpl() {
    }

    protected EClass eStaticClass() {
        return NotationPackage.Literals.SORTING_STYLE;
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public void setSorting(Sorting newSorting) {
        Sorting oldSorting = this.sorting;
        Sorting sorting = this.sorting = newSorting == null ? SORTING_EDEFAULT : newSorting;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldSorting, (Object)this.sorting));
        }
    }

    public Map getSortingKeys() {
        return Collections.unmodifiableMap(this.sortingKeys);
    }

    public void setSortingKeys(Map newSortingKeys) {
        Map oldSortingKeys = this.sortingKeys;
        if (newSortingKeys == null) {
            throw new NullPointerException("the 'newSortingKeys' parameter is null");
        }
        if (newSortingKeys.isEmpty()) {
            this.sortingKeys = SORTING_KEYS_EDEFAULT;
        } else {
            LinkedHashMap tempMap = new LinkedHashMap(newSortingKeys.size());
            for (Object key : newSortingKeys.keySet()) {
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("One or more keys in the map is not of type java.lang.String");
                }
                Object value = newSortingKeys.get(key);
                if (!(value instanceof SortingDirection)) {
                    throw new IllegalArgumentException("One or more values in the map is not of type org.eclipse.gmf.runtime.notation.SortingDirection");
                }
                tempMap.put(key, value);
            }
            this.sortingKeys = tempMap;
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSortingKeys, (Object)this.sortingKeys));
        }
    }

    public EList getSortedObjects() {
        if (this.sortedObjects == null) {
            this.sortedObjects = new EObjectResolvingEList(EObject.class, (InternalEObject)this, 2);
        }
        return this.sortedObjects;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getSorting();
            }
            case 1: {
                return this.getSortingKeys();
            }
            case 2: {
                return this.getSortedObjects();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setSorting((Sorting)((Object)newValue));
                return;
            }
            case 1: {
                this.setSortingKeys((Map)newValue);
                return;
            }
            case 2: {
                this.getSortedObjects().clear();
                this.getSortedObjects().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setSorting(SORTING_EDEFAULT);
                return;
            }
            case 1: {
                this.setSortingKeys(SORTING_KEYS_EDEFAULT);
                return;
            }
            case 2: {
                this.getSortedObjects().clear();
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.sorting != SORTING_EDEFAULT;
            }
            case 1: {
                return SORTING_KEYS_EDEFAULT == null ? this.sortingKeys != null : !SORTING_KEYS_EDEFAULT.equals(this.sortingKeys);
            }
            case 2: {
                return this.sortedObjects != null && !this.sortedObjects.isEmpty();
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (sorting: ");
        result.append((Object)this.sorting);
        result.append(", sortingKeys: ");
        result.append(this.sortingKeys);
        result.append(')');
        return result.toString();
    }
}

