/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.ScrollPaneLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.AnimatableScrollPane;

public class OverlayScrollPaneLayout
extends ScrollPaneLayout {
    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        ScrollPane scrollpane = (ScrollPane)container;
        Insets insets = scrollpane.getInsets();
        int excludedWidth = insets.getWidth();
        int excludedHeight = insets.getHeight();
        return scrollpane.getViewport().getPreferredSize(wHint - excludedWidth, hHint - excludedHeight).getExpanded(excludedWidth, excludedHeight);
    }

    public void layout(IFigure parent) {
        Rectangle bounds;
        ScrollPane scrollpane;
        int vVis;
        int hVis;
        ScrollBar vBar;
        ScrollBar hBar;
        if (parent instanceof AnimatableScrollPane) {
            AnimatableScrollPane p = (AnimatableScrollPane)parent;
            hBar = p.basicGetHorizontalScrollBar();
            vBar = p.basicGetVerticalScrollBar();
            hVis = p.getHorizontalScrollBarVisibility();
            vVis = p.getVerticalScrollBarVisibility();
            scrollpane = p;
        } else {
            scrollpane = (ScrollPane)parent;
            hVis = scrollpane.getHorizontalScrollBarVisibility();
            vVis = scrollpane.getVerticalScrollBarVisibility();
            hBar = hVis != 0 ? scrollpane.getHorizontalScrollBar() : null;
            vBar = vVis != 0 ? scrollpane.getVerticalScrollBar() : null;
        }
        Rectangle clientArea = parent.getClientArea();
        int bottom = 0;
        int right = 0;
        Viewport viewport = scrollpane.getViewport();
        Dimension available = clientArea.getSize();
        Dimension preferred = viewport.getPreferredSize(available.width, available.height).getCopy();
        boolean none = available.contains(preferred);
        boolean both = !none && vVis != 0 && hVis != 0 && preferred.contains(available);
        boolean showV = both || preferred.height > available.height && available.height > 0;
        boolean showH = both || preferred.width > available.width && available.width > 0;
        showV = vVis != 0 && (showV || vVis == 2);
        showH = hVis != 0 && (showH || hVis == 2);
        Rectangle viewportArea = clientArea;
        int hPad = 0;
        int vPad = 0;
        if (showH) {
            hBar = scrollpane.getHorizontalScrollBar();
            bottom = hBar.getPreferredSize((int)clientArea.width, (int)clientArea.height).height;
            hPad = hBar.getSize().height;
        }
        if (showV) {
            vBar = scrollpane.getVerticalScrollBar();
            right = vBar.getPreferredSize((int)clientArea.width, (int)clientArea.height).width;
            vPad = vBar.getSize().width;
        }
        if (showV) {
            bounds = new Rectangle(viewportArea.right() - right, viewportArea.y, right, viewportArea.height - hPad);
            vBar.setBounds(bounds);
        }
        if (showH) {
            bounds = new Rectangle(viewportArea.x, viewportArea.bottom() - bottom, viewportArea.width - vPad, bottom);
            hBar.setBounds(bounds);
        }
        if (vBar != null) {
            vBar.setVisible(showV);
        }
        if (hBar != null) {
            hBar.setVisible(showH);
        }
        viewport.setBounds(viewportArea);
    }

    public Dimension calculateMinimumSize(IFigure container) {
        ScrollPane scrollpane = (ScrollPane)container;
        return scrollpane.getViewport().getMinimumSize();
    }
}

