/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.text;

import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.swt.graphics.Font;

public class TextUtilitiesEx
extends TextUtilities {
    private IMapMode mapmode;

    public TextUtilitiesEx(IMapMode mapmode) {
        this.mapmode = mapmode;
    }

    public int getAscent(Font font) {
        int ascent = super.getAscent(font);
        return this.mapmode.DPtoLP(ascent);
    }

    public int getDescent(Font font) {
        int descent = super.getDescent(font);
        return this.mapmode.DPtoLP(descent);
    }

    public Dimension getStringExtents(String s, Font f) {
        Dimension dimension = super.getStringExtents(s, f);
        if ((f.getFontData()[0].getStyle() & 2) != 0) {
            dimension.width += dimension.width / s.length() / 2;
        }
        return new Dimension(this.mapmode.DPtoLP(dimension.width), this.mapmode.DPtoLP(dimension.height));
    }

    public Dimension getTextExtents(String s, Font f) {
        Dimension dimension = super.getTextExtents(s, f);
        if ((f.getFontData()[0].getStyle() & 2) != 0 && s.length() > 0) {
            dimension.width += dimension.width / s.length() / 2;
        }
        return new Dimension(this.mapmode.DPtoLP(dimension.width), this.mapmode.DPtoLP(dimension.height));
    }
}

