/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.notationprovider;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.notationprovider.EmfNotationException;
import org.eclipse.gmf.runtime.notation.Diagram;

public class EMFNotationModelFactory {
    public static Diagram load(IFile file, TransactionalEditingDomain editingDomain) throws EmfNotationException {
        EList contents;
        Resource notationModel = null;
        try {
            file.refreshLocal(0, null);
            String fileName = file.getLocation().toOSString();
            notationModel = editingDomain.loadResource(fileName);
        }
        catch (Exception e) {
            Trace.catching((Plugin)EditorPlugin.getInstance(), (String)EditorDebugOptions.EXCEPTIONS_CATCHING, EMFNotationModelFactory.class, (String)"load", (Throwable)e);
            EmfNotationException t = new EmfNotationException(e);
            Trace.throwing((Plugin)EditorPlugin.getInstance(), (String)EditorDebugOptions.EXCEPTIONS_CATCHING, EMFNotationModelFactory.class, (String)"load", (Throwable)e);
            throw t;
        }
        if (notationModel != null && !(contents = notationModel.getContents()).isEmpty()) {
            Object element = contents.get(0);
            return element instanceof Diagram ? (Diagram)element : null;
        }
        return null;
    }

    public static void save(IFile file, Diagram diagram, boolean clone, IProgressMonitor progressMonitor) throws Exception {
        Resource notationModel = diagram.eResource();
        String fileName = file.getLocation().toOSString();
        if (clone) {
            notationModel.setURI(URI.createURI((String)fileName));
            notationModel.save(null);
        } else {
            notationModel.save(null);
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }
}

