/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import lpg.lpgjavaruntime.LexStream;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModelExt;
import org.eclipse.gmf.internal.xpand.ResourceMarker;
import org.eclipse.gmf.internal.xpand.eval.EvaluationListener;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.BooleanLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.BooleanOperation;
import org.eclipse.gmf.internal.xpand.expression.ast.Case;
import org.eclipse.gmf.internal.xpand.expression.ast.Cast;
import org.eclipse.gmf.internal.xpand.expression.ast.ChainExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.CollectionExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.ConstructorCallExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.FeatureCall;
import org.eclipse.gmf.internal.xpand.expression.ast.IfExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.IntegerLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.LetExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.ListLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.NullLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.OperationCall;
import org.eclipse.gmf.internal.xpand.expression.ast.RealLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.StringLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.SwitchExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.expression.ast.TypeSelectExpression;
import org.eclipse.gmf.internal.xpand.expression.parser.ExpressionLexer;
import org.eclipse.gmf.internal.xpand.expression.parser.ExpressionParser;
import org.eclipse.gmf.internal.xpand.migration.CollectionExpressionTrace;
import org.eclipse.gmf.internal.xpand.migration.ExpressionAnalyzeTrace;
import org.eclipse.gmf.internal.xpand.migration.FeatureCallTrace;
import org.eclipse.gmf.internal.xpand.migration.MigrationException;
import org.eclipse.gmf.internal.xpand.migration.MigrationExecutionContext;
import org.eclipse.gmf.internal.xpand.migration.ModelManager;
import org.eclipse.gmf.internal.xpand.migration.OperationCallTrace;
import org.eclipse.gmf.internal.xpand.migration.TypeManager;
import org.eclipse.gmf.internal.xpand.migration.TypeSelectExpressionTrace;
import org.eclipse.gmf.internal.xpand.migration.VariableNameDispatcher;
import org.eclipse.gmf.internal.xpand.util.ClassLoadContext;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionMigrationFacade {
    public static final String LF = System.getProperty("line.separator");
    static final EcoreEnvironmentFactory ECORE_ENV_FACTORY = new EcoreEnvironmentFactory(null);
    private static final Set<EOperation> infixOperations = new HashSet<EOperation>(Arrays.asList(BuiltinMetaModel.Boolean_NE, BuiltinMetaModel.Int_Unary_Minus, BuiltinMetaModel.Double_Unary_Minus, BuiltinMetaModel.Int_Minus_Double, BuiltinMetaModel.Int_Minus_Int, BuiltinMetaModel.Double_Minus_Double, BuiltinMetaModel.Double_Minus_Int, BuiltinMetaModel.Int_Plus_Double, BuiltinMetaModel.Int_Plus_Int, BuiltinMetaModel.Double_Plus_Double, BuiltinMetaModel.Double_Plus_Int, BuiltinMetaModel.Int_Mult_Double, BuiltinMetaModel.Int_Mult_Int, BuiltinMetaModel.Double_Mult_Double, BuiltinMetaModel.Double_Mult_Int, BuiltinMetaModel.Int_Div_Double, BuiltinMetaModel.Double_Div_Double, BuiltinMetaModel.Double_Div_Int, BuiltinMetaModel.Int_Less, BuiltinMetaModel.Int_LessOrEqual, BuiltinMetaModel.Int_Greater, BuiltinMetaModel.Int_GreatOrEqual, BuiltinMetaModel.EString_Plus_EJavaObject, BuiltinMetaModel.Object_EQ, BuiltinMetaModel.Object_NotEQ));
    private static final Set<EOperation> collectionOperations = new HashSet<EOperation>(Arrays.asList(BuiltinMetaModel.Collection_Add, BuiltinMetaModel.Collection_AddAll, BuiltinMetaModel.Collection_Clear, BuiltinMetaModel.Collection_Contains, BuiltinMetaModel.Collection_ContainsAll, BuiltinMetaModel.Collection_Flatten, BuiltinMetaModel.Collection_Intersect, BuiltinMetaModel.Collection_IsEmpty, BuiltinMetaModel.Collection_Size, BuiltinMetaModel.Collection_ToList, BuiltinMetaModel.Collection_ToSet, BuiltinMetaModel.Collection_Union, BuiltinMetaModel.Collection_Without, BuiltinMetaModel.List_First, BuiltinMetaModel.List_Get, BuiltinMetaModel.List_IndexOf, BuiltinMetaModel.List_Last, BuiltinMetaModel.List_PurgeDups, BuiltinMetaModel.List_WithoutFirst, BuiltinMetaModel.List_WithoutLast));
    private Stack<Expression> expressionsStack = new Stack();
    private StringBuilder output = new StringBuilder();
    private MigrationExecutionContext ctx;
    private int returnPosition;
    private VariableNameDispatcher variableDispatcher;
    private Expression rootExpression;
    private TypeManager typeManager;
    private ModelManager modelManager;
    private Stack<QvtExecutionContext> qvtContexts = new Stack();
    private EClassifier rootExpressionType;
    private String resourceName;
    private HashMap<String, EClassifier> envVariables;

    public ExpressionMigrationFacade(String expression, EClassifier requiredType, Map<String, EClassifier> envVariables, TypeManager typeManager, ModelManager modelManager, VariableNameDispatcher variableDispatcher, MigrationExecutionContext context, String resourceName) throws MigrationException {
        this(ExpressionMigrationFacade.parseXtend(expression), requiredType, envVariables, typeManager, modelManager, variableDispatcher, context, resourceName);
        HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
        this.rootExpression.analyze(this.ctx, issues);
        if (MigrationException.hasErrors(issues)) {
            throw new MigrationException(issues, resourceName);
        }
    }

    public ExpressionMigrationFacade(Expression expression, EClassifier requiredType, Map<String, EClassifier> envVariables, TypeManager typeManager, ModelManager modelManager, VariableNameDispatcher variableDispatcher, MigrationExecutionContext context, String resourceName) {
        this.rootExpression = expression;
        this.rootExpressionType = requiredType;
        this.envVariables = new HashMap<String, EClassifier>(envVariables);
        this.typeManager = typeManager;
        this.modelManager = modelManager;
        this.variableDispatcher = variableDispatcher;
        this.resourceName = resourceName;
        this.ctx = context;
        this.markReturnPosition();
    }

    private static Expression parseXtend(String expression) {
        ExpressionLexer scanner = new ExpressionLexer(expression.toCharArray(), "nofile");
        ExpressionParser parser = new ExpressionParser((LexStream)scanner);
        scanner.lexer(parser);
        return parser.parser();
    }

    public Expression getRootExpression() {
        return this.rootExpression;
    }

    public StringBuilder migrate() throws MigrationException {
        this.qvtContexts.push(QvtExecutionContext.createNewContext(this.envVariables));
        try {
            EClassifier expressionQvtType = this.migrateExpression(this.rootExpression);
            this.internalConvertTypes(expressionQvtType, this.rootExpressionType);
        }
        finally {
            this.qvtContexts.pop();
        }
        return this.output;
    }

    private void internalConvertTypes(EClassifier actualType, EClassifier expectedType) {
        if (expectedType != BuiltinMetaModel.VOID && BuiltinMetaModel.isCollectionType(expectedType)) {
            assert (BuiltinMetaModel.isCollectionType(actualType));
            if (BuiltinMetaModelExt.isListType(expectedType)) {
                if (BuiltinMetaModelExt.isSetType(actualType) || BuiltinMetaModelExt.isOrderedSetType(actualType) || BuiltinMetaModelExt.isBagType(actualType)) {
                    this.write("->asSequence()");
                } else if (BuiltinMetaModelExt.isAbstractCollectionType(actualType)) {
                    this.internalMigrateCollectionToBag();
                    this.write("->asSequence()");
                }
            } else if (BuiltinMetaModelExt.isSetType(expectedType)) {
                if (BuiltinMetaModelExt.isListType(actualType)) {
                    this.write("->asOrderedSet()");
                } else if (BuiltinMetaModelExt.isBagType(actualType)) {
                    this.write("->asSet()");
                } else if (BuiltinMetaModelExt.isAbstractCollectionType(actualType)) {
                    this.internalMigrateCollectionToBag();
                    this.write("->asSet()");
                }
            }
        }
    }

    int getReturnPosition() {
        return this.returnPosition;
    }

    private EClassifier migrateExpression(Expression expression) throws MigrationException {
        this.expressionsStack.push(expression);
        try {
            if (expression instanceof BooleanOperation) {
                EClassifier eClassifier = this.migrateBooleanOperation((BooleanOperation)expression);
                return eClassifier;
            }
            if (expression instanceof Cast) {
                EClassifier eClassifier = this.migrateCast((Cast)expression);
                return eClassifier;
            }
            if (expression instanceof ChainExpression) {
                EClassifier eClassifier = this.migrateChainExpression((ChainExpression)expression);
                return eClassifier;
            }
            if (expression instanceof ConstructorCallExpression) {
                EClassifier eClassifier = this.migrateConstructorCallExpression((ConstructorCallExpression)expression);
                return eClassifier;
            }
            if (expression instanceof CollectionExpression) {
                EClassifier eClassifier = this.migrateCollectionExpression((CollectionExpression)expression);
                return eClassifier;
            }
            if (expression instanceof OperationCall) {
                EClassifier eClassifier = this.migrateOperationCall((OperationCall)expression);
                return eClassifier;
            }
            if (expression instanceof TypeSelectExpression) {
                EClassifier eClassifier = this.migrateTypeSelectExpression((TypeSelectExpression)expression);
                return eClassifier;
            }
            if (expression instanceof FeatureCall) {
                EClassifier eClassifier = this.migrateFeatureCall((FeatureCall)expression);
                return eClassifier;
            }
            if (expression instanceof IfExpression) {
                EClassifier eClassifier = this.migrateIfExpression((IfExpression)expression);
                return eClassifier;
            }
            if (expression instanceof LetExpression) {
                EClassifier eClassifier = this.migrateLetExpression((LetExpression)expression);
                return eClassifier;
            }
            if (expression instanceof ListLiteral) {
                EClassifier eClassifier = this.migrateListLiteral((ListLiteral)expression);
                return eClassifier;
            }
            if (expression instanceof BooleanLiteral) {
                EClassifier eClassifier = this.migrateBooleanLiteral((BooleanLiteral)expression);
                return eClassifier;
            }
            if (expression instanceof IntegerLiteral) {
                EClassifier eClassifier = this.migrateIntegerLiteral((IntegerLiteral)expression);
                return eClassifier;
            }
            if (expression instanceof NullLiteral) {
                EClassifier eClassifier = this.migrateNullLiteral((NullLiteral)expression);
                return eClassifier;
            }
            if (expression instanceof RealLiteral) {
                EClassifier eClassifier = this.migrateRealLiteral((RealLiteral)expression);
                return eClassifier;
            }
            if (expression instanceof StringLiteral) {
                EClassifier eClassifier = this.migrateStringLiteral((StringLiteral)expression);
                return eClassifier;
            }
            if (expression instanceof SwitchExpression) {
                EClassifier eClassifier = this.migrateSwitchExpression((SwitchExpression)expression);
                return eClassifier;
            }
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_EXPRESSION, this.resourceName, (SyntaxElement)expression, expression.getClass().getName());
        }
        finally {
            this.expressionsStack.pop();
        }
    }

    private EClassifier migrateSwitchExpression(SwitchExpression switchExpression) throws MigrationException {
        ArrayList<EClassifier> expressionTypes = new ArrayList<EClassifier>();
        if (switchExpression.getCases().size() == 0) {
            expressionTypes.add(this.migrateExpression(switchExpression.getDefaultExpr()));
        } else {
            this.write("switch { ");
            for (Case caseExpression : switchExpression.getCases()) {
                this.write("case (");
                this.migrateExpression(switchExpression.getSwitchExpr());
                this.write(" = ");
                this.migrateExpression(caseExpression.getCondition());
                this.write(") ");
                expressionTypes.add(this.migrateExpression(caseExpression.getThenPart()));
                this.write("; ");
            }
            this.write("else ");
            expressionTypes.add(this.migrateExpression(switchExpression.getDefaultExpr()));
            this.write("; }");
        }
        return BuiltinMetaModelExt.getCommonSuperType(expressionTypes);
    }

    private EClassifier migrateStringLiteral(StringLiteral expression) {
        this.write("'");
        this.write(this.escape(expression.getValue()));
        this.write("'");
        return EcorePackage.eINSTANCE.getEString();
    }

    private String escape(String value) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            char nextChar = value.charAt(i);
            if (nextChar == '\b') {
                sb.append("\\b");
            } else if (nextChar == '\n') {
                sb.append("\\n");
            } else if (nextChar == '\f') {
                sb.append("\\f");
            } else if (nextChar == '\r') {
                sb.append("\\r");
            } else if (nextChar == '\"') {
                sb.append("\\\"");
            } else if (nextChar == '\'') {
                sb.append("\\'");
            } else if (nextChar == '\\') {
                sb.append("\\\\");
            } else {
                sb.append(nextChar);
            }
            ++i;
        }
        return sb.toString();
    }

    private EClassifier migrateRealLiteral(RealLiteral realLiteral) {
        this.write(new Double(realLiteral.getLiteralValue()).toString());
        return EcorePackage.eINSTANCE.getEDouble();
    }

    private EClassifier migrateNullLiteral(NullLiteral expression) {
        this.write("null");
        return BuiltinMetaModel.VOID;
    }

    private EClassifier migrateIntegerLiteral(IntegerLiteral integerLiteral) {
        this.write(new Integer(integerLiteral.getLiteralValue()).toString());
        return EcorePackage.eINSTANCE.getEInt();
    }

    private EClassifier migrateBooleanLiteral(BooleanLiteral booleanLiteral) {
        this.write(Boolean.valueOf(booleanLiteral.getLiteralValue()) != false ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        return EcorePackage.eINSTANCE.getEBoolean();
    }

    private EClassifier migrateListLiteral(ListLiteral listLiteral) throws MigrationException {
        ArrayList<EClassifier> expressionTypes = new ArrayList<EClassifier>();
        this.write("Sequence { ");
        int i = 0;
        while (i < listLiteral.getElements().length) {
            if (i > 0) {
                this.write(", ");
            }
            expressionTypes.add(this.migrateExpression(listLiteral.getElements()[i]));
            ++i;
        }
        this.write(" }");
        return BuiltinMetaModelExt.getListType(BuiltinMetaModelExt.getCommonSuperType(expressionTypes));
    }

    private EClassifier migrateLetExpression(LetExpression letExpression) throws MigrationException {
        String varName = this.modelManager.getOclKeywordManager().getValidIdentifierValue(letExpression.getVarName());
        this.write("let ");
        this.write(varName);
        this.write(" = ");
        this.pushContextWithVariable(varName, this.migrateExpression(letExpression.getVarExpression()));
        try {
            this.write(" in ");
            EClassifier eClassifier = this.migrateExpression(letExpression.getTargetExpression());
            return eClassifier;
        }
        finally {
            this.qvtContexts.pop();
        }
    }

    private EClassifier migrateIfExpression(IfExpression ifExpression) throws MigrationException {
        this.write("(if ");
        this.migrateExpression(ifExpression.getCondition());
        this.write(" then ");
        EClassifier thenType = this.migrateExpression(ifExpression.getThenPart());
        this.write(" else ");
        EClassifier elseType = this.migrateExpression(ifExpression.getElsePart());
        this.write(" endif)");
        return BuiltinMetaModelExt.getCommonSuperType(thenType, elseType);
    }

    private EClassifier migrateConstructorCallExpression(ConstructorCallExpression constructorCall) throws MigrationException {
        this.write("object ");
        EClassifier type = this.ctx.getTypeForName(constructorCall.getType().getValue());
        if (type == null) {
            throw new MigrationException(MigrationException.Type.TYPE_NOT_FOUND, this.resourceName, (SyntaxElement)constructorCall.getType(), constructorCall.getType().getValue());
        }
        this.write(this.typeManager.getQvtFQName(type));
        this.write(" {}");
        return type;
    }

    private EClassifier migrateChainExpression(ChainExpression chainExpression) throws MigrationException {
        this.write("compute (");
        String varName = this.variableDispatcher.getNextVariableName();
        this.write(varName);
        this.write(" : ");
        int typePosition = this.getCurrentPosition();
        this.write(") {");
        this.internalMigrateChainExpressionFirstArg(chainExpression.getFirst());
        this.write(varName);
        this.write(" = ");
        EClassifier varType = this.migrateExpression(chainExpression.getNext());
        this.write(this.typeManager.getQvtFQName(varType), typePosition);
        this.write("}");
        return varType;
    }

    private void internalMigrateChainExpressionFirstArg(Expression first) throws MigrationException {
        if (first instanceof ChainExpression) {
            ChainExpression innerChain = (ChainExpression)first;
            this.internalMigrateChainExpressionFirstArg(innerChain.getFirst());
            this.migrateExpression(innerChain.getNext());
        } else {
            this.migrateExpression(first);
        }
        this.write("; ");
    }

    private EClassifier migrateBooleanOperation(BooleanOperation booleanOperation) throws MigrationException {
        int operationPrecedence = this.getPrecedence(booleanOperation);
        int leftPosition = this.getCurrentPosition();
        this.migrateExpression(booleanOperation.getLeft());
        this.encloseExpressionIntoParenthesis(booleanOperation.getLeft(), operationPrecedence, leftPosition, false);
        if (booleanOperation.isAndOperation()) {
            this.write(" and ");
        } else if (booleanOperation.isOrOperation()) {
            this.write(" or ");
        } else if (booleanOperation.isImpliesOperation()) {
            this.write(" implies ");
        } else {
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_BOOLEAN_OPERATION, this.resourceName, (SyntaxElement)booleanOperation, booleanOperation.getOperator());
        }
        int rightPosition = this.getCurrentPosition();
        this.migrateExpression(booleanOperation.getRight());
        this.encloseExpressionIntoParenthesis(booleanOperation.getRight(), operationPrecedence, rightPosition, true);
        return EcorePackage.eINSTANCE.getEBoolean();
    }

    private EClassifier migrateCast(Cast cast) throws MigrationException {
        EClassifier migratedExpressionType = this.migrateExpression(cast.getTarget());
        EClassifier type = this.ctx.getTypeForName(cast.getType().getValue());
        if (type == null) {
            throw new MigrationException(MigrationException.Type.TYPE_NOT_FOUND, this.resourceName, (SyntaxElement)cast.getType(), cast.getType().getValue());
        }
        if (BuiltinMetaModel.isCollectionType(type)) {
            return migratedExpressionType;
        }
        this.write(".oclAsType(");
        this.write(this.typeManager.getQvtFQName(type));
        this.write(")");
        return type;
    }

    private EClassifier migrateTypeSelectExpression(TypeSelectExpression typeSelectExpression) throws MigrationException {
        int placeholder = this.getCurrentPosition();
        EClassifier targetQvtType = this.migrateExpression(typeSelectExpression.getTarget());
        EClassifier type = this.ctx.getTypeForName(typeSelectExpression.getTypeLiteral().getValue());
        if (type == null) {
            throw new MigrationException(MigrationException.Type.TYPE_NOT_FOUND, this.resourceName, (SyntaxElement)typeSelectExpression.getTypeLiteral(), typeSelectExpression.getTypeLiteral().getValue());
        }
        ExpressionAnalyzeTrace expressionTrace = this.ctx.getTraces().get(typeSelectExpression);
        if (!(expressionTrace instanceof TypeSelectExpressionTrace)) {
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_TYPE_SELECT_EXPRESSION_TRACE, this.resourceName, (SyntaxElement)typeSelectExpression, expressionTrace);
        }
        TypeSelectExpressionTrace trace = (TypeSelectExpressionTrace)expressionTrace;
        if (!trace.isValid()) {
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_TYPE_SELECT_EXPRESSION, this.resourceName, (SyntaxElement)typeSelectExpression, trace);
        }
        this.internalMigrateTypeSelectCastingCollectionToBag(targetQvtType, this.typeManager.getQvtFQName(type), placeholder);
        if (!BuiltinMetaModelExt.isListType(targetQvtType) && !BuiltinMetaModelExt.isOrderedSetType(targetQvtType)) {
            this.write("->asSequence()");
        }
        return BuiltinMetaModelExt.isOrderedSetType(targetQvtType) ? BuiltinMetaModelExt.getOrderedSetType(type) : BuiltinMetaModelExt.getListType(type);
    }

    private void internalMigrateTypeSelectCastingCollectionToBag(EClassifier collectionType, String typeName, int placeholder) {
        assert (BuiltinMetaModel.isCollectionType(collectionType));
        if (BuiltinMetaModelExt.isAbstractCollectionType(collectionType)) {
            this.internalMigrateCollectionToBag();
        }
        this.internalMigrateTypeSelect(typeName, placeholder, this.getCurrentPosition());
    }

    private void internalMigrateTypeSelect(String typeName, int expressionStartPosition, int expressionEndPosition) {
        StringBuilder sb = new StringBuilder();
        sb.append(")[");
        sb.append(typeName);
        sb.append("]");
        this.write(sb, expressionEndPosition);
        this.write("(", expressionStartPosition);
    }

    private void internalMigrateCollectionToBag() {
        String iteratorName = this.variableDispatcher.getNextIteratorName();
        this.write("->collect(");
        this.write(iteratorName);
        this.write(" | ");
        this.write(iteratorName);
        this.write(")");
    }

    private EClassifier migrateCollectionExpression(CollectionExpression collectionExpression) throws MigrationException {
        EClassifier expressionType;
        EClassifier targetQvtType;
        ExpressionAnalyzeTrace expressionTrace = this.ctx.getTraces().get(collectionExpression);
        if (!(expressionTrace instanceof CollectionExpressionTrace)) {
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_COLLECTION_EXPRESSION_TRACE, this.resourceName, (SyntaxElement)collectionExpression, expressionTrace);
        }
        CollectionExpressionTrace trace = (CollectionExpressionTrace)expressionTrace;
        int placeholder = this.getCurrentPosition();
        boolean hasNegation = false;
        if (collectionExpression.getTarget() != null) {
            targetQvtType = this.migrateExpression(collectionExpression.getTarget());
        } else {
            this.write("self");
            targetQvtType = this.getEnvVariableType("this");
        }
        assert (BuiltinMetaModel.isCollectionType(targetQvtType));
        EClassifier innerTargetQvtType = BuiltinMetaModel.getInnerType(targetQvtType);
        this.write("->");
        switch (trace.getType()) {
            case NOTEXISTS_REF: {
                hasNegation = true;
                this.write("not ", placeholder);
                this.write("exists");
                break;
            }
            case COLLECT_REF: 
            case SELECT_REF: 
            case REJECT_REF: 
            case EXISTS_REF: 
            case FORALL_REF: {
                this.write(collectionExpression.getName().getValue());
                break;
            }
            case UNDESOLVED_TARGET_TYPE: 
            case INCORRECT_EXPRESSION_TYPE: {
                throw new MigrationException(MigrationException.Type.UNSUPPORTED_COLLECTION_EXPRESSION, this.resourceName, (SyntaxElement)collectionExpression, trace);
            }
            default: {
                throw new MigrationException(MigrationException.Type.UNSUPPORTED_COLLECTION_EXPRESSION_TRACE, this.resourceName, (SyntaxElement)collectionExpression, trace);
            }
        }
        this.write("(");
        String varName = collectionExpression.getElementName();
        this.write(this.modelManager.getOclKeywordManager().getValidIdentifierValue(varName));
        this.pushContextWithVariable(varName, innerTargetQvtType);
        try {
            this.write(" | ");
            expressionType = this.migrateExpression(collectionExpression.getClosure());
        }
        finally {
            this.qvtContexts.pop();
        }
        this.write(")");
        try {
            switch (trace.getType()) {
                case EXISTS_REF: 
                case NOTEXISTS_REF: 
                case FORALL_REF: {
                    EDataType eDataType = EcorePackage.eINSTANCE.getEBoolean();
                    return eDataType;
                }
                case COLLECT_REF: {
                    if (BuiltinMetaModelExt.isSetType(trace.getResultType())) {
                        this.write("->asSet()");
                        EClass eClass = BuiltinMetaModel.getSetType(expressionType);
                        return eClass;
                    }
                    if (BuiltinMetaModelExt.isListType(trace.getResultType())) {
                        EClass eClass = BuiltinMetaModelExt.getListType(expressionType);
                        return eClass;
                    }
                    EClass eClass = BuiltinMetaModelExt.getBagType(expressionType);
                    return eClass;
                }
                case SELECT_REF: 
                case REJECT_REF: {
                    EClassifier eClassifier = targetQvtType;
                    return eClassifier;
                }
            }
            return null;
        }
        finally {
            if (hasNegation) {
                this.addNegationBraces(placeholder);
            }
        }
    }

    private void addNegationBraces(int placeholder) {
        if (this.expressionsStack.size() == 1) {
            return;
        }
        this.write("(", placeholder);
        this.write(")");
    }

    private EClassifier migrateOperationCall(OperationCall operationCall) throws MigrationException {
        ExpressionAnalyzeTrace expressionTrace = this.ctx.getTraces().get(operationCall);
        if (!(expressionTrace instanceof OperationCallTrace)) {
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_OPERATION_CALL_TRACE, this.resourceName, (SyntaxElement)operationCall, expressionTrace);
        }
        OperationCallTrace trace = (OperationCallTrace)expressionTrace;
        switch (trace.getType()) {
            case UNDESOLVED_PARAMETER_TYPE: 
            case UNDESOLVED_TARGET_TYPE: {
                throw new MigrationException(MigrationException.Type.UNSUPPORTED_OPERATION_CALL, this.resourceName, (SyntaxElement)operationCall, trace.toString());
            }
            case STATIC_EXTENSION_REF: {
                if (trace.isStaticQvtoCall()) {
                    this.write(this.modelManager.getName(operationCall, trace));
                    this.write("(");
                    this.internalMigrateOperationCallParameters(operationCall, trace.getParamTypes());
                    this.write(")");
                } else {
                    List<EClassifier> expectedParameterTypes = trace.getParamTypes();
                    assert (operationCall.getParams().length > 0);
                    assert (expectedParameterTypes == null || operationCall.getParams().length == expectedParameterTypes.size());
                    EClassifier actualParameterType = this.migrateExpression(operationCall.getParams()[0]);
                    if (expectedParameterTypes != null) {
                        this.internalConvertTypes(actualParameterType, expectedParameterTypes.get(0));
                    }
                    if (BuiltinMetaModel.isCollectionType(actualParameterType)) {
                        this.write("->");
                    } else {
                        this.write(".");
                    }
                    this.write(this.modelManager.getName(operationCall, trace));
                    this.write("(");
                    int i = 1;
                    while (i < operationCall.getParams().length) {
                        if (i > 1) {
                            this.write(", ");
                        }
                        actualParameterType = this.migrateExpression(operationCall.getParams()[i]);
                        if (expectedParameterTypes != null) {
                            this.internalConvertTypes(actualParameterType, expectedParameterTypes.get(i));
                        }
                        ++i;
                    }
                    this.write(")");
                }
                return trace.getResultType();
            }
            case OPERATION_REF: {
                if (this.isInfixOperation(trace)) {
                    return this.internalMigrateInfixOperation(trace, operationCall);
                }
                if (this.isCollectionOperation(trace)) {
                    return this.internalMigrateCollectionOperationCall(trace, operationCall);
                }
                if (this.isEClassOperationOnTypeLiteral(trace, operationCall)) {
                    return this.internalMigrateEClassOperationOnTypeLiteral(trace, operationCall);
                }
            }
            case IMPLICIT_COLLECT_OPERATION_REF: {
                EOperation eOperation = trace.getEOperation();
                assert (eOperation != null);
                EClassifier targetQvtType = trace.getTargetType();
                if (operationCall.getTarget() != null) {
                    targetQvtType = this.migrateExpression(operationCall.getTarget());
                    this.write(".");
                }
                this.write(this.modelManager.getName(operationCall, trace));
                this.write("(");
                if (BuiltinMetaModel.EString_SubString_StartEnd == eOperation) {
                    this.write("1 + ");
                }
                List<EClassifier> parameterTypes = this.internalMigrateOperationCallParameters(operationCall, trace.getParamTypes());
                if (BuiltinMetaModel.EString_Plus_EJavaObject == eOperation) {
                    assert (parameterTypes.size() == 1);
                    if (parameterTypes.get(0) != EcorePackage.eINSTANCE.getEString()) {
                        this.write(".repr()");
                    }
                }
                this.write(")");
                if (trace.getType() == OperationCallTrace.Type.OPERATION_REF) {
                    return this.getTypedElementQvtType((ETypedElement)eOperation);
                }
                if (!BuiltinMetaModel.isParameterizedType(targetQvtType)) {
                    throw new MigrationException(MigrationException.Type.UNSUPPORTED_EXPRESSION, this.resourceName, (SyntaxElement)operationCall.getTarget(), "Implicit collect is not supported for simple types: " + targetQvtType.toString() + "." + operationCall.getName().getValue());
                }
                this.convertImplicitCollectProduct(targetQvtType);
                return BuiltinMetaModelExt.getListType(BuiltinMetaModel.getInnerType(targetQvtType));
            }
            case EXTENSION_REF: {
                if (!trace.isStaticQvtoCall()) {
                    if (operationCall.getTarget() != null) {
                        this.migrateExpression(operationCall.getTarget());
                    } else {
                        this.write("self");
                    }
                    if (BuiltinMetaModel.isCollectionType(trace.getParamTypes().get(0))) {
                        this.write("->");
                    } else {
                        this.write(".");
                    }
                }
                this.write(this.modelManager.getName(operationCall, trace));
                this.write("(");
                if (trace.isStaticQvtoCall()) {
                    if (operationCall.getTarget() != null) {
                        this.migrateExpression(operationCall.getTarget());
                    } else {
                        this.write("self");
                    }
                    if (operationCall.getParams().length > 0) {
                        this.write(", ");
                    }
                }
                this.internalMigrateOperationCallParameters(operationCall, ExpressionMigrationFacade.withoutFirst(trace.getParamTypes()));
                this.write(")");
                return trace.getResultType();
            }
            case IMPLICIT_COLLECT_EXTENSION_REF: {
                assert (operationCall.getTarget() != null);
                EClassifier implicitCollectTargetQvtType = this.migrateExpression(operationCall.getTarget());
                if (!BuiltinMetaModel.isParameterizedType(implicitCollectTargetQvtType)) {
                    throw new MigrationException(MigrationException.Type.UNSUPPORTED_EXPRESSION, this.resourceName, (SyntaxElement)operationCall.getTarget(), "Implicit collect is not supported for simple types: " + implicitCollectTargetQvtType.toString() + "." + operationCall.getName().getValue());
                }
                String iteratorName = this.variableDispatcher.getNextIteratorName();
                this.write("->collect(");
                this.write(iteratorName);
                this.write(" | ");
                if (!trace.isStaticQvtoCall()) {
                    this.write(iteratorName);
                    if (BuiltinMetaModel.isCollectionType(BuiltinMetaModel.getInnerType(implicitCollectTargetQvtType))) {
                        this.write("->");
                    } else {
                        this.write(".");
                    }
                }
                this.write(this.modelManager.getName(operationCall, trace));
                this.write("(");
                if (trace.isStaticQvtoCall()) {
                    this.write(iteratorName);
                    if (operationCall.getParams().length > 0) {
                        this.write(", ");
                    }
                }
                this.internalMigrateOperationCallParameters(operationCall, ExpressionMigrationFacade.withoutFirst(trace.getParamTypes()));
                this.write(")");
                this.write(")");
                this.convertImplicitCollectProduct(implicitCollectTargetQvtType);
                return trace.getResultType();
            }
        }
        throw new MigrationException(MigrationException.Type.UNSUPPORTED_OPERATION_CALL_TRACE, this.resourceName, (SyntaxElement)operationCall, trace);
    }

    private EClassifier internalMigrateEClassOperationOnTypeLiteral(OperationCallTrace trace, OperationCall operationCall) throws MigrationException {
        EOperation eOperation = trace.getEOperation();
        assert (eOperation != null);
        if ("isSuperTypeOf".equals(eOperation.getName())) {
            OperationCall parameterOpCall;
            assert (operationCall.getParams().length == 1);
            Expression parameter = operationCall.getParams()[0];
            if (parameter instanceof OperationCall && "eClass".equals((parameterOpCall = (OperationCall)parameter).getName().getValue()) && parameterOpCall.getTarget() != null && parameterOpCall.getParams().length == 0) {
                this.migrateExpression(parameterOpCall.getTarget());
                this.write(".oclIsKindOf(");
                Expression target = operationCall.getTarget();
                assert (target instanceof FeatureCall);
                EClassifier type = this.ctx.getTypeForName(((FeatureCall)target).getName().getValue());
                this.write(this.typeManager.getQvtFQName(type));
                this.write(")");
                return EcorePackage.eINSTANCE.getEBoolean();
            }
        }
        throw new MigrationException(MigrationException.Type.UNSUPPORTED_OPERATION_CALL, this.resourceName, (SyntaxElement)operationCall.getName(), "Migration of operation \"" + eOperation.getName() + "\" is not supported for TypeLiteral expressions now");
    }

    private boolean isEClassOperationOnTypeLiteral(OperationCallTrace trace, OperationCall operationCall) throws MigrationException {
        Expression target;
        if (trace.getTargetType() == EcorePackage.eINSTANCE.getEClass() && (target = operationCall.getTarget()) instanceof FeatureCall) {
            ExpressionAnalyzeTrace expressionTrace = this.ctx.getTraces().get(target);
            if (!(expressionTrace instanceof FeatureCallTrace)) {
                throw new MigrationException(MigrationException.Type.UNSUPPORTED_FEATURE_CALL_TRACE, this.resourceName, (SyntaxElement)target, expressionTrace);
            }
            return ((FeatureCallTrace)expressionTrace).getType() == FeatureCallTrace.Type.UNSUPPORTED_CLASSIFIER_REF;
        }
        return false;
    }

    private static <T> List<T> withoutFirst(List<T> parameters) {
        assert (parameters.size() > 0);
        return parameters.subList(1, parameters.size());
    }

    private EClassifier internalMigrateInfixOperation(OperationCallTrace trace, OperationCall operationCall) throws MigrationException {
        EOperation eOperation = trace.getEOperation();
        assert (eOperation != null);
        TypeSelectExpression typeSelect = this.getInfixInstanceOfTypeSelect(eOperation, operationCall);
        if (typeSelect != null) {
            return this.internalMigrateInfixInstanceof(typeSelect);
        }
        typeSelect = this.getInfixNotInstanceOfTypeSelect(eOperation, operationCall);
        if (typeSelect != null) {
            this.write("not ");
            return this.internalMigrateInfixInstanceof(typeSelect);
        }
        OperationCall indexOfOperation = this.getInfixContains(eOperation, operationCall);
        if (indexOfOperation != null) {
            return this.internalMigrateInfixContains(indexOfOperation);
        }
        indexOfOperation = this.getInfixNotContains(eOperation, operationCall);
        if (indexOfOperation != null) {
            this.write("not ");
            return this.internalMigrateInfixContains(indexOfOperation);
        }
        int operationPrecedence = this.getPrecedence(operationCall);
        int targetStartPosition = this.getCurrentPosition();
        this.internalMigrateOperationCallTarget(operationCall);
        this.encloseExpressionIntoParenthesis(operationCall.getTarget(), operationPrecedence, targetStartPosition, false);
        String opName = eOperation.getName();
        if (BuiltinMetaModel.Boolean_NE == eOperation) {
            this.write("not ", targetStartPosition);
        } else if (BuiltinMetaModel.Int_Unary_Minus == eOperation || BuiltinMetaModel.Double_Unary_Minus == eOperation) {
            this.write(opName, targetStartPosition);
        } else if (BuiltinMetaModel.Int_Minus_Int == eOperation || BuiltinMetaModel.Int_Minus_Double == eOperation || BuiltinMetaModel.Double_Minus_Int == eOperation || BuiltinMetaModel.Double_Minus_Double == eOperation || BuiltinMetaModel.Int_Plus_Int == eOperation || BuiltinMetaModel.Int_Plus_Double == eOperation || BuiltinMetaModel.Double_Plus_Int == eOperation || BuiltinMetaModel.Double_Plus_Double == eOperation || BuiltinMetaModel.Int_Mult_Int == eOperation || BuiltinMetaModel.Int_Mult_Double == eOperation || BuiltinMetaModel.Double_Mult_Int == eOperation || BuiltinMetaModel.Double_Mult_Double == eOperation || BuiltinMetaModel.Int_Div_Double == eOperation || BuiltinMetaModel.Double_Div_Double == eOperation || BuiltinMetaModel.Double_Div_Int == eOperation || BuiltinMetaModel.Int_Less == eOperation || BuiltinMetaModel.Int_LessOrEqual == eOperation || BuiltinMetaModel.Int_Greater == eOperation || BuiltinMetaModel.Int_GreatOrEqual == eOperation || BuiltinMetaModel.EString_Plus_EJavaObject == eOperation) {
            this.write(" ");
            this.write(opName);
            this.write(" ");
        } else if (BuiltinMetaModel.Object_EQ == eOperation) {
            this.write(" = ");
        } else if (BuiltinMetaModel.Object_NotEQ == eOperation) {
            this.write(" <> ");
        } else {
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_EXPRESSION, this.resourceName, (SyntaxElement)operationCall.getName(), "Incorrect infix operation: " + opName);
        }
        int parameterStartPosition = this.getCurrentPosition();
        List<EClassifier> parameterTypes = this.internalMigrateOperationCallParameters(operationCall, null);
        if (operationCall.getParams().length == 1) {
            this.encloseExpressionIntoParenthesis(operationCall.getParams()[0], operationPrecedence, parameterStartPosition, true);
        }
        if (BuiltinMetaModel.EString_Plus_EJavaObject == eOperation) {
            assert (parameterTypes.size() == 1);
            if (parameterTypes.get(0) != EcorePackage.eINSTANCE.getEString()) {
                this.write(".repr()");
            }
        }
        return this.getTypedElementQvtType((ETypedElement)eOperation);
    }

    private OperationCall getInfixNotContains(EOperation eOperation, OperationCall operationCall) throws MigrationException {
        Integer intLiteral;
        if (operationCall.getParams().length == 1 && operationCall.getTarget() instanceof OperationCall && (intLiteral = this.getIntLiteralValue(operationCall.getParams()[0])) != null && (eOperation == BuiltinMetaModel.Object_EQ && intLiteral == -1 || eOperation == BuiltinMetaModel.Int_Less && intLiteral == 0)) {
            return this.getIndexOfOpCall((OperationCall)operationCall.getTarget());
        }
        return null;
    }

    private Integer getIntLiteralValue(Expression expression) throws MigrationException {
        if (expression instanceof IntegerLiteral) {
            return new Integer(((IntegerLiteral)expression).getLiteralValue());
        }
        if (expression instanceof OperationCall) {
            OperationCall operationCall = (OperationCall)expression;
            ExpressionAnalyzeTrace expressionTrace = this.ctx.getTraces().get(operationCall);
            if (!(expressionTrace instanceof OperationCallTrace)) {
                throw new MigrationException(MigrationException.Type.UNSUPPORTED_OPERATION_CALL_TRACE, this.resourceName, (SyntaxElement)operationCall, expressionTrace);
            }
            if (((OperationCallTrace)expressionTrace).getEOperation() == BuiltinMetaModel.Int_Unary_Minus) {
                assert (operationCall.getTarget() instanceof IntegerLiteral);
                return new Integer("-" + ((IntegerLiteral)operationCall.getTarget()).getLiteralValue());
            }
        }
        return null;
    }

    private OperationCall getIndexOfOpCall(OperationCall operationCall) throws MigrationException {
        ExpressionAnalyzeTrace expressionTrace = this.ctx.getTraces().get(operationCall);
        if (!(expressionTrace instanceof OperationCallTrace)) {
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_OPERATION_CALL_TRACE, this.resourceName, (SyntaxElement)operationCall, expressionTrace);
        }
        OperationCallTrace trace = (OperationCallTrace)expressionTrace;
        return trace.getEOperation() == BuiltinMetaModel.List_IndexOf ? operationCall : null;
    }

    private EClassifier internalMigrateInfixContains(OperationCall indexOfOperation) throws MigrationException {
        assert (indexOfOperation.getParams().length == 1);
        EClassifier targetType = this.internalMigrateOperationCallTarget(indexOfOperation);
        assert (BuiltinMetaModelExt.isListType(targetType) || BuiltinMetaModelExt.isOrderedSetType(targetType));
        this.write("->includes(");
        this.internalMigrateOperationCallParameters(indexOfOperation, null);
        this.write(")");
        return EcorePackage.eINSTANCE.getEBoolean();
    }

    private OperationCall getInfixContains(EOperation eOperation, OperationCall operationCall) throws MigrationException {
        Integer intLiteral;
        if (operationCall.getParams().length == 1 && operationCall.getTarget() instanceof OperationCall && (intLiteral = this.getIntLiteralValue(operationCall.getParams()[0])) != null && (eOperation == BuiltinMetaModel.Object_NotEQ && intLiteral == -1 || eOperation == BuiltinMetaModel.Int_GreatOrEqual && intLiteral == 0 || eOperation == BuiltinMetaModel.Int_Greater && intLiteral == -1)) {
            return this.getIndexOfOpCall((OperationCall)operationCall.getTarget());
        }
        return null;
    }

    private EClassifier internalMigrateInfixInstanceof(TypeSelectExpression typeSelect) throws MigrationException {
        assert (typeSelect.getTarget() instanceof ListLiteral);
        ListLiteral listLiteral = (ListLiteral)typeSelect.getTarget();
        assert (listLiteral.getElements().length == 1);
        this.migrateExpression(listLiteral.getElements()[0]);
        this.write(".oclIsKindOf(");
        this.write(this.typeManager.getQvtFQName(this.ctx.getTypeForName(typeSelect.getTypeLiteral().getValue())));
        this.write(")");
        return EcorePackage.eINSTANCE.getEBoolean();
    }

    private TypeSelectExpression getInfixNotInstanceOfTypeSelect(EOperation eOperation, OperationCall operationCall) {
        if (operationCall.getParams().length == 1 && operationCall.getTarget() instanceof OperationCall) {
            TypeSelectExpression result;
            Expression paramExpression = operationCall.getParams()[0];
            OperationCall target = (OperationCall)operationCall.getTarget();
            if (eOperation == BuiltinMetaModel.Object_EQ && paramExpression instanceof IntegerLiteral && "0".equals(((IntegerLiteral)paramExpression).getLiteralValue()) && "size".equals(target.getName().getValue()) && target.getTarget() instanceof TypeSelectExpression) {
                TypeSelectExpression result2 = (TypeSelectExpression)target.getTarget();
                if (this.isInstanceofTypeselect(result2)) {
                    return result2;
                }
            } else if (eOperation == BuiltinMetaModel.Int_Less && paramExpression instanceof IntegerLiteral && "1".equals(((IntegerLiteral)paramExpression).getLiteralValue()) && "size".equals(target.getName().getValue()) && target.getTarget() instanceof TypeSelectExpression && this.isInstanceofTypeselect(result = (TypeSelectExpression)target.getTarget())) {
                return result;
            }
        }
        return null;
    }

    private TypeSelectExpression getInfixInstanceOfTypeSelect(EOperation eOperation, OperationCall operationCall) {
        if (operationCall.getTarget() instanceof OperationCall) {
            OperationCall target = (OperationCall)operationCall.getTarget();
            if (operationCall.getParams().length == 0) {
                TypeSelectExpression result;
                if (eOperation == BuiltinMetaModel.Boolean_NE && "isEmpty".equals(target.getName().getValue()) && target.getTarget() instanceof TypeSelectExpression && this.isInstanceofTypeselect(result = (TypeSelectExpression)target.getTarget())) {
                    return result;
                }
            } else if (operationCall.getParams().length == 1) {
                TypeSelectExpression result;
                Expression paramExpression = operationCall.getParams()[0];
                if (eOperation == BuiltinMetaModel.Int_Greater && paramExpression instanceof IntegerLiteral && "0".equals(((IntegerLiteral)paramExpression).getLiteralValue()) && "size".equals(target.getName().getValue()) && target.getTarget() instanceof TypeSelectExpression) {
                    TypeSelectExpression result2 = (TypeSelectExpression)target.getTarget();
                    if (this.isInstanceofTypeselect(result2)) {
                        return result2;
                    }
                } else if (eOperation == BuiltinMetaModel.Object_EQ && paramExpression instanceof BooleanLiteral && !Boolean.valueOf(((BooleanLiteral)paramExpression).getLiteralValue()).booleanValue() && "isEmpty".equals(target.getName().getValue()) && target.getTarget() instanceof TypeSelectExpression && this.isInstanceofTypeselect(result = (TypeSelectExpression)target.getTarget())) {
                    return result;
                }
            }
        }
        return null;
    }

    private boolean isInstanceofTypeselect(TypeSelectExpression typeSelect) {
        if (typeSelect.getTarget() instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)typeSelect.getTarget();
            return listLiteral.getElements().length == 1;
        }
        return false;
    }

    private void encloseExpressionIntoParenthesis(Expression expression, int parentPrecedence, int placeholder, boolean ecloseIfEqualPrecenence) throws MigrationException {
        int expressionPrecedence = this.getPrecedence(expression);
        if (ecloseIfEqualPrecenence ? parentPrecedence <= expressionPrecedence : parentPrecedence < expressionPrecedence) {
            this.write("(", placeholder);
            this.write(")");
        }
    }

    private int getPrecedence(Expression expression) throws MigrationException {
        if (expression instanceof OperationCall) {
            OperationCall operationCall = (OperationCall)expression;
            ExpressionAnalyzeTrace expressionTrace = this.ctx.getTraces().get(operationCall);
            if (!(expressionTrace instanceof OperationCallTrace)) {
                throw new MigrationException(MigrationException.Type.UNSUPPORTED_OPERATION_CALL_TRACE, this.resourceName, (SyntaxElement)expression, expressionTrace);
            }
            OperationCallTrace trace = (OperationCallTrace)expressionTrace;
            if (this.getInfixNotInstanceOfTypeSelect(trace.getEOperation(), operationCall) != null) {
                return 2;
            }
            if (BuiltinMetaModel.Collection_IsEmpty == trace.getEOperation() && operationCall.getTarget() instanceof TypeSelectExpression && this.isInstanceofTypeselect((TypeSelectExpression)operationCall.getTarget())) {
                return 2;
            }
            if (this.getInfixNotContains(trace.getEOperation(), operationCall) != null) {
                return 2;
            }
            if (trace.getEOperation() != null && infixOperations.contains(trace.getEOperation())) {
                EOperation eOperation = trace.getEOperation();
                if (BuiltinMetaModel.Boolean_NE == eOperation || BuiltinMetaModel.Int_Unary_Minus == eOperation || BuiltinMetaModel.Double_Unary_Minus == eOperation) {
                    return 2;
                }
                if (BuiltinMetaModel.Int_Mult_Int == eOperation || BuiltinMetaModel.Int_Mult_Double == eOperation || BuiltinMetaModel.Double_Mult_Int == eOperation || BuiltinMetaModel.Double_Mult_Double == eOperation || BuiltinMetaModel.Int_Div_Int == eOperation || BuiltinMetaModel.Int_Div_Double == eOperation || BuiltinMetaModel.Double_Div_Int == eOperation || BuiltinMetaModel.Double_Div_Double == eOperation) {
                    return 3;
                }
                if (BuiltinMetaModel.Int_Minus_Int == eOperation || BuiltinMetaModel.Int_Minus_Double == eOperation || BuiltinMetaModel.Double_Minus_Int == eOperation || BuiltinMetaModel.Double_Minus_Double == eOperation || BuiltinMetaModel.Int_Plus_Int == eOperation || BuiltinMetaModel.Int_Plus_Double == eOperation || BuiltinMetaModel.Double_Plus_Int == eOperation || BuiltinMetaModel.Double_Plus_Double == eOperation || BuiltinMetaModel.EString_Plus_EJavaObject == eOperation) {
                    return 4;
                }
                if (BuiltinMetaModel.Int_Less == eOperation || BuiltinMetaModel.Int_LessOrEqual == eOperation || BuiltinMetaModel.Int_Greater == eOperation || BuiltinMetaModel.Int_GreatOrEqual == eOperation) {
                    return 6;
                }
                if (BuiltinMetaModel.Object_EQ == eOperation || BuiltinMetaModel.Object_NotEQ == eOperation) {
                    return 7;
                }
            }
        } else if (expression instanceof BooleanOperation) {
            return 8;
        }
        return 0;
    }

    private EClassifier internalMigrateOperationCallTarget(OperationCall operationCall) throws MigrationException {
        if (operationCall.getTarget() != null) {
            return this.migrateExpression(operationCall.getTarget());
        }
        this.write("self");
        return null;
    }

    private EClassifier internalMigrateCollectionOperationCall(OperationCallTrace trace, OperationCall operationCall) throws MigrationException {
        String varName;
        EClass resultType;
        EClassifier targetQvtType;
        EOperation eOperation = trace.getEOperation();
        assert (eOperation != null);
        EClassifier targetType = trace.getTargetType();
        assert (targetType != null);
        assert (BuiltinMetaModel.isCollectionType(targetType));
        EClassifier elementType = BuiltinMetaModel.getInnerType(targetType);
        if (BuiltinMetaModel.Collection_IsEmpty == eOperation && operationCall.getTarget() instanceof TypeSelectExpression && this.isInstanceofTypeselect((TypeSelectExpression)operationCall.getTarget())) {
            this.write("not ");
            return this.internalMigrateInfixInstanceof((TypeSelectExpression)operationCall.getTarget());
        }
        int expressionStartPosition = this.getCurrentPosition();
        if (BuiltinMetaModel.Collection_Clear != eOperation && BuiltinMetaModel.List_WithoutFirst != eOperation && BuiltinMetaModel.List_WithoutLast != eOperation && (targetQvtType = this.internalMigrateOperationCallTarget(operationCall)) != null && BuiltinMetaModel.isCollectionType(targetQvtType)) {
            targetType = targetQvtType;
            elementType = BuiltinMetaModel.getInnerType(targetQvtType);
        }
        if (BuiltinMetaModel.Collection_Add == eOperation) {
            int operationStartPosition = this.getCurrentPosition();
            this.write("->including(");
            EClassifier parameterType = this.getSingleParameterType(this.internalMigrateOperationCallParameters(operationCall, null));
            this.write(")");
            EClassifier commonSuperType = BuiltinMetaModelExt.getCommonSuperType(elementType, parameterType);
            return this.internalMigrateToConcreteCollection(targetType, commonSuperType, expressionStartPosition, operationStartPosition);
        }
        if (BuiltinMetaModel.Collection_AddAll == eOperation) {
            int operationStartPosition = this.getCurrentPosition();
            this.write("->union(");
            EClassifier parameterCollectionType = this.getSingleParameterType(this.internalMigrateOperationCallParameters(operationCall, null));
            EClassifier parameterCollectionElementType = this.getCollectionElementType(parameterCollectionType);
            EClassifier commonSuperType = BuiltinMetaModelExt.getCommonSuperType(elementType, parameterCollectionElementType);
            this.internalMigrateParameterCollectionToMain(parameterCollectionType, targetType);
            this.write(")");
            return this.internalMigrateToConcreteCollection(targetType, commonSuperType, expressionStartPosition, operationStartPosition);
        }
        if (BuiltinMetaModel.Collection_Union == eOperation) {
            int operationStartPosition = this.getCurrentPosition();
            this.write("->union(");
            EClassifier parameterCollectionType = this.getSingleParameterType(this.internalMigrateOperationCallParameters(operationCall, null));
            EClassifier parameterCollectionElementType = this.getCollectionElementType(parameterCollectionType);
            EClassifier commonSuperType = BuiltinMetaModelExt.getCommonSuperType(elementType, parameterCollectionElementType);
            this.internalMigrateParameterCollectionToList(parameterCollectionType);
            this.write(")->asOrderedSet()->asSequence()");
            return this.internalMigrateToList(targetType, commonSuperType, expressionStartPosition, operationStartPosition);
        }
        if (BuiltinMetaModel.Collection_Intersect == eOperation) {
            int operationStartPosition = this.getCurrentPosition();
            this.write("->intersection(");
            EClassifier parameterCollectionType = this.getSingleParameterType(this.internalMigrateOperationCallParameters(operationCall, null));
            EClassifier parameterCollectionElementType = this.getCollectionElementType(parameterCollectionType);
            EClassifier commonSuperType = BuiltinMetaModelExt.getCommonSuperType(elementType, parameterCollectionElementType);
            this.internalMigrateParameterCollectionToSet(parameterCollectionType);
            this.write(")");
            return this.internalMigrateToSet(targetType, commonSuperType, expressionStartPosition, operationStartPosition);
        }
        if (BuiltinMetaModel.Collection_Without == eOperation) {
            int operationStartPosition = this.getCurrentPosition();
            this.write("->-(");
            EClassifier parameterCollectionType = this.getSingleParameterType(this.internalMigrateOperationCallParameters(operationCall, null));
            EClassifier parameterCollectionElementType = this.getCollectionElementType(parameterCollectionType);
            EClassifier commonSuperType = BuiltinMetaModelExt.getCommonSuperType(elementType, parameterCollectionElementType);
            this.internalMigrateParameterCollectionToSet(parameterCollectionType);
            this.write(")");
            return this.internalMigrateToSet(targetType, commonSuperType, expressionStartPosition, operationStartPosition);
        }
        if (BuiltinMetaModel.Collection_Contains == eOperation) {
            int operationStartPosition = this.getCurrentPosition();
            this.write("->includes(");
            EClassifier parameterType = this.getSingleParameterType(this.internalMigrateOperationCallParameters(operationCall, null));
            this.write(")");
            if (!BuiltinMetaModel.isAssignableFrom(elementType, parameterType)) {
                EClassifier commonSuperType = BuiltinMetaModelExt.getCommonSuperType(elementType, parameterType);
                this.internalMigrateTypeSelect(this.typeManager.getQvtFQName(commonSuperType), expressionStartPosition, operationStartPosition);
            }
            return EcorePackage.eINSTANCE.getEBoolean();
        }
        if (BuiltinMetaModel.Collection_ContainsAll == eOperation) {
            int operationStartPosition = this.getCurrentPosition();
            this.write("->includesAll(");
            EClassifier parameterCollectionType = this.getSingleParameterType(this.internalMigrateOperationCallParameters(operationCall, null));
            EClassifier parameterCollectionElementType = this.getCollectionElementType(parameterCollectionType);
            this.write(")");
            if (!BuiltinMetaModel.isAssignableFrom(elementType, parameterCollectionElementType)) {
                EClassifier commonSuperType = BuiltinMetaModelExt.getCommonSuperType(elementType, parameterCollectionElementType);
                this.internalMigrateTypeSelect(this.typeManager.getQvtFQName(commonSuperType), expressionStartPosition, operationStartPosition);
            }
            return EcorePackage.eINSTANCE.getEBoolean();
        }
        if (BuiltinMetaModel.List_IndexOf == eOperation) {
            int operationStartPosition = this.getCurrentPosition();
            this.write("->indexOf(");
            EClassifier parameterType = this.getSingleParameterType(this.internalMigrateOperationCallParameters(operationCall, null));
            this.write(")");
            if (!BuiltinMetaModel.isAssignableFrom(elementType, parameterType)) {
                EClassifier commonSuperType = BuiltinMetaModelExt.getCommonSuperType(elementType, parameterType);
                this.internalMigrateTypeSelect(this.typeManager.getQvtFQName(commonSuperType), expressionStartPosition, operationStartPosition);
            }
            this.write("(", expressionStartPosition);
            this.write(" - 1)");
            return EcorePackage.eINSTANCE.getEInt();
        }
        if (BuiltinMetaModel.Collection_Clear == eOperation) {
            if (BuiltinMetaModelExt.isSetType(targetType)) {
                this.write("Set{}");
                resultType = BuiltinMetaModelExt.getSetType(elementType);
            } else if (BuiltinMetaModelExt.isListType(targetType) || BuiltinMetaModelExt.isOrderedSetType(targetType)) {
                this.write("Sequence{}");
                resultType = BuiltinMetaModelExt.getListType(elementType);
            } else {
                this.write("Bag{}");
                resultType = BuiltinMetaModelExt.getBagType(elementType);
            }
            if (elementType != EcorePackage.eINSTANCE.getEJavaObject()) {
                this.write("[");
                this.write(this.typeManager.getQvtFQName(elementType));
                this.write("]");
            }
            return resultType;
        }
        if (BuiltinMetaModel.Collection_Flatten == eOperation) {
            resultType = this.internalMigrateToConcreteCollection(targetType, elementType, expressionStartPosition, this.getCurrentPosition());
            this.write("->flatten()");
            if (BuiltinMetaModel.isCollectionType(elementType)) {
                elementType = BuiltinMetaModel.getInnerType(elementType);
            }
            if (BuiltinMetaModelExt.isSetType((EClassifier)resultType) || BuiltinMetaModelExt.isOrderedSetType((EClassifier)resultType)) {
                return BuiltinMetaModelExt.getSetType(elementType);
            }
            if (BuiltinMetaModelExt.isListType((EClassifier)resultType)) {
                return BuiltinMetaModelExt.getListType(elementType);
            }
            return BuiltinMetaModelExt.getBagType(elementType);
        }
        if (BuiltinMetaModel.Collection_ToSet == eOperation) {
            return this.internalMigrateToSet(targetType, elementType, expressionStartPosition, this.getCurrentPosition());
        }
        if (BuiltinMetaModel.Collection_ToList == eOperation) {
            return this.internalMigrateToList(targetType, elementType, expressionStartPosition);
        }
        if (BuiltinMetaModel.List_Get == eOperation) {
            this.write("->at(");
            this.internalMigrateOperationCallParameters(operationCall, null);
            this.write(" + 1)");
            return elementType;
        }
        if (BuiltinMetaModel.List_WithoutFirst == eOperation) {
            varName = this.variableDispatcher.getNextVariableName();
            this.write("let ");
            this.write(varName);
            this.write(" = ");
            targetType = this.internalMigrateOperationCallTarget(operationCall);
            assert (BuiltinMetaModelExt.isListType(targetType) || BuiltinMetaModelExt.isOrderedSetType(targetType));
            boolean isOrderedSet = BuiltinMetaModelExt.isOrderedSetType(targetType);
            this.write(" in ");
            this.write("if ");
            this.write(varName);
            this.write("->size() < 2 then ");
            if (isOrderedSet) {
                this.write("OrderedSet");
            } else {
                this.write("Sequence");
            }
            this.write("{}");
            if (elementType != EcorePackage.eINSTANCE.getEJavaObject()) {
                this.write("[");
                this.write(this.typeManager.getQvtFQName(elementType));
                this.write("]");
            }
            this.write(" else ");
            this.write(varName);
            this.write("->");
            if (isOrderedSet) {
                this.write("subOrderedSet");
            } else {
                this.write("subSequence");
            }
            this.write("(2, ");
            this.write(varName);
            this.write("->size()) endif");
            return targetType;
        }
        if (BuiltinMetaModel.List_WithoutLast == eOperation) {
            varName = this.variableDispatcher.getNextVariableName();
            this.write("let ");
            this.write(varName);
            this.write(" = ");
            targetType = this.internalMigrateOperationCallTarget(operationCall);
            assert (BuiltinMetaModelExt.isListType(targetType) || BuiltinMetaModelExt.isOrderedSetType(targetType));
            boolean isOrderedSet = BuiltinMetaModelExt.isOrderedSetType(targetType);
            this.write(" in ");
            this.write("if ");
            this.write(varName);
            this.write("->size() < 2 then ");
            if (isOrderedSet) {
                this.write("OrderedSet");
            } else {
                this.write("Sequence");
            }
            this.write("{}");
            if (elementType != EcorePackage.eINSTANCE.getEJavaObject()) {
                this.write("[");
                this.write(this.typeManager.getQvtFQName(elementType));
                this.write("]");
            }
            this.write(" else ");
            this.write(varName);
            this.write("->");
            if (isOrderedSet) {
                this.write("subOrderedSet");
            } else {
                this.write("subSequence");
            }
            this.write("(1, ");
            this.write(varName);
            this.write("->size() - 1) endif");
            return targetType;
        }
        if (BuiltinMetaModel.List_PurgeDups == eOperation) {
            if (BuiltinMetaModelExt.isListType(targetType)) {
                this.write("->asOrderedSet()->asSequence()");
            }
            return targetType;
        }
        assert (operationCall.getParams().length == 0);
        this.write("->");
        this.write(eOperation.getName());
        this.write("(");
        this.internalMigrateOperationCallParameters(operationCall, null);
        this.write(")");
        if (BuiltinMetaModel.Collection_IsEmpty == eOperation) {
            return EcorePackage.eINSTANCE.getEBoolean();
        }
        if (BuiltinMetaModel.Collection_Size == eOperation) {
            return EcorePackage.eINSTANCE.getEInt();
        }
        if (BuiltinMetaModel.List_First == eOperation || BuiltinMetaModel.List_Last == eOperation) {
            return elementType;
        }
        throw new MigrationException(MigrationException.Type.UNSUPPORTED_COLLECTION_OPERATION, this.resourceName, (SyntaxElement)operationCall.getName(), eOperation.getName());
    }

    private EClassifier getSingleParameterType(List<EClassifier> parameterTypes) {
        assert (parameterTypes.size() == 1);
        return parameterTypes.get(0);
    }

    private EClassifier getCollectionElementType(EClassifier collectionType) {
        assert (BuiltinMetaModel.isCollectionType(collectionType));
        return BuiltinMetaModel.getInnerType(collectionType);
    }

    private EClassifier internalMigrateToConcreteCollection(EClassifier collectionType, EClassifier requestedElementType, int expressionStartPosition, int expressionEndPosition) throws MigrationException {
        assert (BuiltinMetaModel.isCollectionType(collectionType));
        EClassifier elementType = BuiltinMetaModel.getInnerType(collectionType);
        if (BuiltinMetaModelExt.isAbstractCollectionType(collectionType)) {
            String iteratorName = this.variableDispatcher.getNextIteratorName();
            StringBuilder sb = new StringBuilder();
            sb.append("->collect(");
            sb.append(iteratorName);
            sb.append(" | ");
            sb.append(iteratorName);
            if (requestedElementType != elementType) {
                sb.append(".oclAsType(");
                sb.append(this.typeManager.getQvtFQName(requestedElementType));
                sb.append(")");
            }
            sb.append(")");
            this.write(sb, expressionEndPosition);
            return BuiltinMetaModelExt.getBagType(requestedElementType);
        }
        if (requestedElementType != elementType) {
            this.internalMigrateTypeSelect(this.typeManager.getQvtFQName(requestedElementType), expressionStartPosition, expressionEndPosition);
            return BuiltinMetaModelExt.replaceCollectionElementType(collectionType, requestedElementType);
        }
        return collectionType;
    }

    private EClassifier internalMigrateToSet(EClassifier collectionType, EClassifier elementSuperType, int expressionStartPosition, int expressionEndPosition) throws MigrationException {
        if (!BuiltinMetaModelExt.isSetType(collectionType) && !BuiltinMetaModelExt.isOrderedSetType(collectionType)) {
            if (BuiltinMetaModelExt.isListType(collectionType)) {
                this.write("->asOrderedSet()", expressionEndPosition);
            } else {
                this.write("->asSet()", expressionEndPosition);
            }
        }
        this.internalMigrateToConcreteCollection(collectionType, elementSuperType, expressionStartPosition, expressionEndPosition);
        return BuiltinMetaModelExt.isOrderedSetType(collectionType) || BuiltinMetaModelExt.isListType(collectionType) ? BuiltinMetaModelExt.getOrderedSetType(elementSuperType) : BuiltinMetaModelExt.getSetType(elementSuperType);
    }

    private EClassifier internalMigrateToList(EClassifier collectionType, EClassifier elementSuperType, int placeholder) throws MigrationException {
        return this.internalMigrateToList(collectionType, elementSuperType, placeholder, this.getCurrentPosition());
    }

    private EClassifier internalMigrateToList(EClassifier collectionType, EClassifier elementSuperType, int expressionStartPosition, int expressionEndPosition) throws MigrationException {
        if (!BuiltinMetaModelExt.isListType(collectionType)) {
            this.write("->asSequence()", expressionEndPosition);
        }
        this.internalMigrateToConcreteCollection(collectionType, elementSuperType, expressionStartPosition, expressionEndPosition);
        return BuiltinMetaModelExt.getListType(elementSuperType);
    }

    private void internalMigrateParameterCollectionToMain(EClassifier parameterCollectionType, EClassifier mainCollectionType) {
        assert (BuiltinMetaModel.isCollectionType(parameterCollectionType));
        assert (BuiltinMetaModel.isCollectionType(mainCollectionType));
        if (BuiltinMetaModelExt.isListType(mainCollectionType)) {
            if (BuiltinMetaModelExt.isSetType(parameterCollectionType) || BuiltinMetaModelExt.isOrderedSetType(parameterCollectionType)) {
                this.write("->asSequence()");
            } else if (BuiltinMetaModelExt.isAbstractCollectionType(parameterCollectionType)) {
                this.internalMigrateCollectionToBag();
                this.write("->asSequence()");
            }
        } else if (BuiltinMetaModelExt.isSetType(mainCollectionType) || BuiltinMetaModelExt.isOrderedSetType(mainCollectionType)) {
            if (BuiltinMetaModelExt.isListType(parameterCollectionType) || BuiltinMetaModelExt.isBagType(parameterCollectionType)) {
                this.write("->asSet()");
            } else if (BuiltinMetaModelExt.isAbstractCollectionType(parameterCollectionType)) {
                this.internalMigrateCollectionToBag();
                this.write("->asSet()");
            }
        } else if (BuiltinMetaModelExt.isListType(parameterCollectionType)) {
            this.write("->asBag()");
        } else if (BuiltinMetaModelExt.isAbstractCollectionType(parameterCollectionType)) {
            this.internalMigrateCollectionToBag();
        }
    }

    private void internalMigrateParameterCollectionToSet(EClassifier parameterCollectionType) {
        assert (BuiltinMetaModel.isCollectionType(parameterCollectionType));
        if (BuiltinMetaModelExt.isListType(parameterCollectionType) || BuiltinMetaModelExt.isBagType(parameterCollectionType)) {
            this.write("->asSet()");
        } else if (BuiltinMetaModelExt.isAbstractCollectionType(parameterCollectionType)) {
            this.internalMigrateCollectionToBag();
            this.write("->asSet()");
        }
    }

    private void internalMigrateParameterCollectionToList(EClassifier parameterCollectionType) {
        assert (BuiltinMetaModel.isCollectionType(parameterCollectionType));
        if (BuiltinMetaModelExt.isAbstractCollectionType(parameterCollectionType)) {
            this.internalMigrateCollectionToBag();
        }
        if (!BuiltinMetaModelExt.isListType(parameterCollectionType)) {
            this.write("->asSequence()");
        }
    }

    private boolean isCollectionOperation(OperationCallTrace trace) {
        EOperation eOperation = trace.getEOperation();
        assert (eOperation != null);
        return collectionOperations.contains(eOperation);
    }

    private EClassifier getTypedElementQvtType(ETypedElement typedElement) {
        EClassifier type = typedElement.getEType();
        if (typedElement.isMany()) {
            type = typedElement.isOrdered() && typedElement.isUnique() ? BuiltinMetaModelExt.getOrderedSetType(type) : (typedElement.isOrdered() ? BuiltinMetaModelExt.getListType(type) : (typedElement.isUnique() ? BuiltinMetaModelExt.getSetType(type) : BuiltinMetaModelExt.getBagType(type)));
        }
        return type == null ? BuiltinMetaModel.VOID : type;
    }

    private void convertImplicitCollectProduct(EClassifier targetType) {
        assert (targetType != null);
        if (!BuiltinMetaModelExt.isListType(targetType) && !BuiltinMetaModelExt.isOrderedSetType(targetType)) {
            this.write("->asSequence()");
        }
    }

    private List<EClassifier> internalMigrateOperationCallParameters(OperationCall operationCall, List<EClassifier> expectedParameterTypes) throws MigrationException {
        assert (expectedParameterTypes == null || operationCall.getParams().length == expectedParameterTypes.size());
        ArrayList<EClassifier> parameterTypes = new ArrayList<EClassifier>();
        int i = 0;
        while (i < operationCall.getParams().length) {
            if (i > 0) {
                this.write(", ");
            }
            Expression parameter = operationCall.getParams()[i];
            if (operationCall.getTarget() != null && operationCall.getTarget().getLine() != parameter.getLine()) {
                this.write(LF);
            }
            parameterTypes.add(this.migrateExpression(parameter));
            if (expectedParameterTypes != null) {
                this.internalConvertTypes((EClassifier)parameterTypes.get(i), expectedParameterTypes.get(i));
            }
            ++i;
        }
        return parameterTypes;
    }

    private boolean isInfixOperation(OperationCallTrace trace) {
        EOperation eOperation = trace.getEOperation();
        assert (eOperation != null);
        return infixOperations.contains(eOperation);
    }

    private EClassifier migrateFeatureCall(FeatureCall featureCall) throws MigrationException {
        ExpressionAnalyzeTrace expressionTrace = this.ctx.getTraces().get(featureCall);
        if (!(expressionTrace instanceof FeatureCallTrace)) {
            throw new MigrationException(MigrationException.Type.UNSUPPORTED_FEATURE_CALL_TRACE, this.resourceName, (SyntaxElement)featureCall, expressionTrace);
        }
        FeatureCallTrace trace = (FeatureCallTrace)expressionTrace;
        switch (trace.getType()) {
            case ENUM_LITERAL_REF: {
                EEnumLiteral enumLiteral = trace.getEnumLiteral();
                assert (enumLiteral != null);
                this.write(this.typeManager.getQvtFQName(enumLiteral));
                return enumLiteral.getEEnum();
            }
            case ENV_VAR_REF: {
                this.write(this.modelManager.getName(featureCall, trace));
                EClassifier variableType = this.getEnvVariableType(featureCall.getName().getValue());
                return variableType != null ? variableType : trace.getResultType();
            }
            case UNDESOLVED_TARGET_TYPE: 
            case UNSUPPORTED_CLASSIFIER_REF: {
                throw new MigrationException(MigrationException.Type.UNSUPPORTED_FEATURE_CALL, this.resourceName, (SyntaxElement)featureCall.getName(), trace);
            }
        }
        EClassifier targetType = trace.getTargetType();
        if (featureCall.getTarget() != null) {
            this.migrateExpression(featureCall.getTarget());
            if (targetType instanceof EEnum && trace.getType() == FeatureCallTrace.Type.FEATURE_REF) {
                if (this.skipEnumLiteralFeature(trace.getFeature())) {
                    return targetType;
                }
                if (this.addEnumLiteralStringRepresentation(trace.getFeature())) {
                    this.write(".repr()");
                    return EcorePackage.eINSTANCE.getEString();
                }
            }
            this.write(".");
        } else {
            if (targetType instanceof EEnum && trace.getType() == FeatureCallTrace.Type.FEATURE_REF) {
                if (this.skipEnumLiteralFeature(trace.getFeature())) {
                    this.write("self");
                    return targetType;
                }
                if (this.addEnumLiteralStringRepresentation(trace.getFeature())) {
                    this.write("self");
                    this.write(".repr()");
                    return EcorePackage.eINSTANCE.getEString();
                }
            }
            if (FeatureCallTrace.Type.IMPLICIT_COLLECT_FEATURE_REF == trace.getType()) {
                this.write("self");
                this.write(".");
            }
        }
        this.write(this.modelManager.getName(featureCall, trace));
        assert (targetType != null);
        switch (trace.getType()) {
            case FEATURE_REF: {
                if (BuiltinMetaModel.isParameterizedType(targetType)) {
                    throw new MigrationException(MigrationException.Type.UNSUPPORTED_EXPRESSION, this.resourceName, (SyntaxElement)featureCall, "Attribute call is not supported for the collection types: " + targetType.toString() + "." + featureCall.getName().getValue());
                }
                return this.getTypedElementQvtType((ETypedElement)trace.getFeature());
            }
            case IMPLICIT_COLLECT_FEATURE_REF: {
                if (!BuiltinMetaModel.isParameterizedType(targetType)) {
                    throw new MigrationException(MigrationException.Type.UNSUPPORTED_EXPRESSION, this.resourceName, (SyntaxElement)featureCall, "Implicit collect is not supported for simple types: " + targetType.toString() + "." + featureCall.getName().getValue());
                }
                this.convertImplicitCollectProduct(targetType);
                return trace.getResultType();
            }
        }
        throw new MigrationException(MigrationException.Type.UNSUPPORTED_FEATURE_CALL_TRACE, this.resourceName, (SyntaxElement)featureCall, trace);
    }

    private boolean addEnumLiteralStringRepresentation(EStructuralFeature feature) {
        return EcorePackage.eINSTANCE.getENamedElement_Name() == feature;
    }

    private boolean skipEnumLiteralFeature(EStructuralFeature feature) {
        return EcorePackage.eINSTANCE.getEEnumLiteral_Value() == feature || EcorePackage.eINSTANCE.getEEnumLiteral_Literal() == feature;
    }

    private void markReturnPosition() {
        this.returnPosition = this.getCurrentPosition();
    }

    private int getCurrentPosition() {
        return this.output.length();
    }

    private void write(CharSequence cs, int index) {
        this.output.insert(index, cs);
    }

    private void write(CharSequence cs) {
        this.output.append(cs);
    }

    private void pushContextWithVariable(String varName, EClassifier varType) {
        this.qvtContexts.push(this.qvtContexts.peek().cloneWithVariable(varName, varType));
    }

    private EClassifier getEnvVariableType(String varName) {
        return this.qvtContexts.peek().getVariableType(varName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QvtExecutionContext
    extends ExecutionContextImpl {
        public static QvtExecutionContext createNewContext(HashMap<String, EClassifier> envVariables) {
            QvtExecutionContext result = new QvtExecutionContext();
            for (Map.Entry<String, EClassifier> envVar : envVariables.entrySet()) {
                result = result.cloneWithVariable(envVar.getKey(), envVar.getValue());
            }
            return result;
        }

        private QvtExecutionContext() {
            super(null, new EPackage[0]);
        }

        private QvtExecutionContext(QvtExecutionContext original) {
            super(original);
        }

        public QvtExecutionContext cloneWithVariable(String name, EClassifier type) {
            return (QvtExecutionContext)super.cloneWithVariable(new Variable(name, type));
        }

        public EClassifier getVariableType(String name) {
            Variable var = this.getVariable(name);
            if (var != null) {
                return (EClassifier)var.getValue();
            }
            return null;
        }

        @Override
        public QvtExecutionContext cloneContext() {
            return new QvtExecutionContext(this);
        }

        @Override
        public EClassifier[] findTypesForPrefix(String prefix) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setContextClassLoader(ClassLoadContext classLoadContext) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> loadClass(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EClassifier getTypeForName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExecutionContext cloneWithResource(ResourceMarker ns) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResourceMarker currentResource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Extension> getAllExtensions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Extension getExtension(String functionName, EClassifier[] parameterTypes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EvaluationListener getEvaluationListener() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEvaluationListener(EvaluationListener listener) {
            throw new UnsupportedOperationException();
        }
    }
}

