/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmf.internal.xpand.RootManager;
import org.eclipse.gmf.internal.xpand.build.WorkspaceResourceManager;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.migration.MigrationException;
import org.eclipse.gmf.internal.xpand.migration.XpandMigrationFacade;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class MigrateXpandResource
implements IObjectActionDelegate {
    private Shell shell;
    private IFile selectedFile;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (!MessageDialog.openConfirm((Shell)this.shell, (String)"Migrate xpand resource", (String)"Migration action will replace existing xpand resource with new OCL/QVTO based one. Do you want to owerwrite it?")) {
            return;
        }
        try {
            InputStream inputStream = this.getUpdatedResourceContent(this.selectedFile.getCharset());
            if (inputStream == null) {
                return;
            }
            this.selectedFile.setContents(inputStream, true, true, null);
        }
        catch (CoreException e) {
            this.showError("Migration problems", "Following exception appears:\n\n" + e.getMessage());
        }
    }

    private InputStream getUpdatedResourceContent(String charset) {
        RootManager rootManager = new RootManager(this.selectedFile.getProject());
        String templateFullName = rootManager.getTemplateFullName(this.selectedFile);
        if (templateFullName == null) {
            this.showError("Incorrect xtend resource", "Unable to locate proper xpand root for this xtend resource");
            return null;
        }
        WorkspaceResourceManager resourceManager = rootManager.getResourceManager(this.selectedFile);
        XpandMigrationFacade migrationFacade = new XpandMigrationFacade(resourceManager, templateFullName);
        try {
            String updatedResourceContent = migrationFacade.migrateXpandResource();
            return new ByteArrayInputStream(updatedResourceContent.getBytes(charset));
        }
        catch (MigrationException e) {
            this.reportMigrationException(e);
        }
        catch (UnsupportedEncodingException e) {
            this.showError("Unsupported encoding", "Specified encoding \"" + charset + "\" is not supported by the platform: " + e.getMessage());
        }
        return null;
    }

    private void reportMigrationException(MigrationException e) {
        switch (e.getType()) {
            case ANALYZATION_PROBLEMS: {
                StringBuilder sb = new StringBuilder("Following analyzation problems present:\n\n");
                for (AnalysationIssue issue : e.getIssues()) {
                    sb.append(issue.toString());
                    sb.append("\n");
                }
                this.showError("Unable to load xtend resource", sb.toString());
                return;
            }
        }
        this.showError("Migration exception", "Migration exception appears:\n" + e.getMessage());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof IFile) {
            this.selectedFile = (IFile)structuredSelection.getFirstElement();
            action.setEnabled(true);
            return;
        }
        this.selectedFile = null;
        action.setEnabled(false);
    }

    private void showError(String title, String contents) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)contents);
    }
}

