/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class ReferenceFigure
extends Shape {
    private int offset = 8;

    public Insets getInsets() {
        Insets insets = new Insets(0, this.offset, 0, this.offset);
        if (this.getBorder() != null) {
            insets.add(this.getBorder().getInsets((IFigure)this));
        }
        return insets;
    }

    protected void fillShape(Graphics graphics) {
        graphics.fillPolygon(this.getPoints());
    }

    protected void outlineShape(Graphics graphics) {
        graphics.drawPolygon(this.getPoints());
    }

    protected PointList getPoints() {
        Rectangle r = this.getBounds();
        int x = r.x + this.lineWidth / 2;
        int y = r.y + this.lineWidth / 2;
        int w = r.width - Math.max(1, this.lineWidth);
        int h = r.height - Math.max(1, this.lineWidth);
        PointList pl = new PointList(6);
        if (w < this.offset * 2) {
            pl.addPoint(x, y);
            pl.addPoint(x + w, y);
            pl.addPoint(x + w, y + h);
            pl.addPoint(x, y + h);
        } else {
            pl.addPoint(x + this.offset, y);
            pl.addPoint(x + w - this.offset, y);
            pl.addPoint(x + w, y + h / 2);
            pl.addPoint(x + w - this.offset, y + h);
            pl.addPoint(x + this.offset, y + h);
            pl.addPoint(x, y + h / 2);
        }
        return pl;
    }
}

