/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand.migration;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.migration.MigrationException;
import org.eclipse.gmf.internal.xpand.migration.MigrationExecutionContext;
import org.eclipse.gmf.internal.xpand.migration.MigrationExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.migration.XpandMigrationFacade;
import org.eclipse.gmf.tests.xpand.TestsResourceManager;
import org.eclipse.gmf.tests.xpand.migration.testModel.MigrationTestsPackage;

public class XpandMigrationTest
extends TestCase {
    private TestsResourceManager testResourceManager;

    protected void setUp() throws Exception {
        super.setUp();
        this.testResourceManager = new TestsResourceManager();
    }

    public void testDefinition() throws IOException, MigrationException {
        this.checkMigration("Definition");
    }

    public void testDefinitionParameters() throws IOException, MigrationException {
        this.checkMigration("DefinitionParameters");
    }

    public void testStdlibExtension() throws IOException, MigrationException {
        this.checkMigration("StdlibExtension");
    }

    public void testStdlibExtension_withoutOtherExtensions() throws IOException, MigrationException {
        this.checkMigration("StdlibExtension_withoutOtherExtensions");
    }

    public void testStdlibExtension_withOtherExtensions() throws IOException, MigrationException {
        this.checkMigration("StdlibExtension_withOtherExtensions");
    }

    public void testExpressionStatements() throws IOException, MigrationException {
        this.checkMigration("ExpressionStatements");
    }

    public void testErrorStatements() throws IOException, MigrationException {
        this.checkMigration("ErrorStatements");
    }

    public void testExpandStatements() throws IOException, MigrationException {
        this.checkMigration("ExpandStatements");
    }

    public void testFileStatements() throws IOException, MigrationException {
        this.checkMigration("FileStatements");
    }

    public void testForEachStatements() throws IOException, MigrationException {
        this.checkMigration("ForEachStatements");
    }

    public void testIfStatements() throws IOException, MigrationException {
        this.checkMigration("IfStatements");
    }

    public void testLetStatements() throws IOException, MigrationException {
        this.checkMigration("LetStatements");
    }

    public void testFixedProblems() throws IOException, MigrationException {
        String resourceName = "FixedProblems";
        this.checkMigration(new XpandMigrationFacade((ResourceManager)this.testResourceManager, XpandMigrationTest.getResourceName(resourceName), (MigrationExecutionContext)new MigrationExecutionContextImpl((ResourceManager)this.testResourceManager, new EPackage[]{MigrationTestsPackage.eINSTANCE})), resourceName);
    }

    public void testImportedExtensions() throws IOException, MigrationException {
        this.checkMigration("ImportedExtensions");
    }

    public void testImportedExtensionsWReexport() throws IOException, MigrationException {
        this.checkMigration("ImportedExtensionsWReexport");
    }

    private String checkMigration(XpandMigrationFacade facade, String resourceName) throws IOException, MigrationException {
        String content = facade.migrateXpandResource().toString();
        XpandMigrationTest.assertTrue((content.length() > 0 ? 1 : 0) != 0);
        StringBuilder etalon = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(this.testResourceManager.loadFile(XpandMigrationTest.getEtalonResourceName(resourceName), "xpt"), Charset.forName("ISO-8859-1"));
        int ch = ((Reader)reader).read();
        while (ch != -1) {
            etalon.append((char)ch);
            ch = ((Reader)reader).read();
        }
        XpandMigrationTest.assertEquals((String)etalon.toString(), (String)content);
        return content;
    }

    private String checkMigration(String resourceName) throws IOException, MigrationException {
        return this.checkMigration(new XpandMigrationFacade((ResourceManager)this.testResourceManager, XpandMigrationTest.getResourceName(resourceName)), resourceName);
    }

    private static String getEtalonResourceName(String resourceName) {
        return String.valueOf(XpandMigrationTest.getResourceName(resourceName)) + "_etalon";
    }

    private static String getResourceName(String resourceName) {
        return "org::eclipse::gmf::tests::xpand::migration::xpand::" + resourceName;
    }
}

