/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.parser;

import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.gmf.internal.xpand.expression.ast.BooleanLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.BooleanOperation;
import org.eclipse.gmf.internal.xpand.expression.ast.Case;
import org.eclipse.gmf.internal.xpand.expression.ast.Cast;
import org.eclipse.gmf.internal.xpand.expression.ast.ChainExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.CollectionExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.ConstructorCallExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.FeatureCall;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.IfExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.IntegerLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.LetExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.ListLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.NullLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.OperationCall;
import org.eclipse.gmf.internal.xpand.expression.ast.RealLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.StringLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.SwitchExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.expression.ast.TypeSelectExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFactory {
    private String fileName;

    public ExpressionFactory(String string) {
        this.fileName = string;
    }

    protected static int end(IToken c) {
        return c.getEndColumn();
    }

    protected static int start(IToken c) {
        return c.getColumn() - 1;
    }

    protected static int line(IToken c) {
        return c.getLine();
    }

    public StringLiteral createStringLiteral(IToken t) {
        return this.handle(new StringLiteral(ExpressionFactory.start(t), ExpressionFactory.end(t), ExpressionFactory.line(t), t.getStartOffset(), t.getEndOffset(), t.toString()));
    }

    public IntegerLiteral createIntegerLiteral(IToken t) {
        return this.handle(new IntegerLiteral(ExpressionFactory.start(t), ExpressionFactory.end(t), ExpressionFactory.line(t), t.getStartOffset(), t.getEndOffset(), t.toString()));
    }

    public BooleanLiteral createBooleanLiteral(IToken t) {
        return this.handle(new BooleanLiteral(ExpressionFactory.start(t), ExpressionFactory.end(t), ExpressionFactory.line(t), t.getStartOffset(), t.getEndOffset(), t.toString()));
    }

    public NullLiteral createNullLiteral(IToken t) {
        return this.handle(new NullLiteral(ExpressionFactory.start(t), ExpressionFactory.end(t), t.getStartOffset(), t.getEndOffset(), ExpressionFactory.line(t)));
    }

    public ListLiteral createListLiteral(IToken start, IToken end, List<Expression> paramExpr) {
        return this.handle(new ListLiteral(ExpressionFactory.start(start), ExpressionFactory.end(end), ExpressionFactory.line(start), start.getStartOffset(), end.getEndOffset(), paramExpr.toArray(new Expression[paramExpr.size()])));
    }

    public FeatureCall createFeatureCall(Identifier name, Expression target) {
        return this.handle(new FeatureCall(name.getStart(), name.getEnd(), name.getLine(), name.getStartOffset(), name.getEndOffset(), name, target));
    }

    public Identifier createIdentifier(IToken name) {
        return new Identifier(ExpressionFactory.start(name), ExpressionFactory.end(name), ExpressionFactory.line(name), name.getStartOffset(), name.getEndOffset(), name.toString());
    }

    public OperationCall createOperationCall(IToken endToken, IToken name, Expression target, List<Expression> parameterExpressions) {
        int start = ExpressionFactory.start(name);
        int line = ExpressionFactory.line(name);
        int end = ExpressionFactory.end(endToken);
        Expression[] params = parameterExpressions.toArray(new Expression[parameterExpressions.size()]);
        return this.handle(new OperationCall(start, end, line, name.getStartOffset(), endToken.getEndOffset(), this.createIdentifier(name), target, params));
    }

    public OperationCall createOperationCall(int start, int end, int line, int startOffset, int endOffset, IToken name, Expression target, List<Expression> parameterExpressions) {
        Expression[] params = parameterExpressions.toArray(new Expression[parameterExpressions.size()]);
        return this.handle(new OperationCall(start, end, line, startOffset, endOffset, this.createIdentifier(name), target, params));
    }

    public IfExpression createIf(Expression cond, Expression then, Expression elseExpr) {
        int start = cond.getStart();
        int line = cond.getLine();
        int end = elseExpr.getEnd();
        return this.handle(new IfExpression(start, end, line, cond.getStartOffset(), elseExpr.getEndOffset(), cond, then, elseExpr));
    }

    public CollectionExpression createCollectionExpression(IToken opName, IToken endToken, IToken elementName, Expression closure, Expression target) {
        return this.handle(new CollectionExpression(ExpressionFactory.end(endToken), endToken.getEndOffset(), this.createIdentifier(opName), elementName == null ? null : elementName.toString(), closure, target));
    }

    public DeclaredParameter createDeclaredParameter(Identifier type, Identifier name) {
        return this.handle(new DeclaredParameter(type.getStart(), name.getEnd(), type.getLine(), type.getStartOffset(), name.getEndOffset(), type, name));
    }

    public Expression createCast(IToken start, Identifier t, Expression e) {
        return this.handle(new Cast(ExpressionFactory.start(start), e.getEnd(), ExpressionFactory.line(start), start.getStartOffset(), e.getEndOffset(), t, e));
    }

    protected <T extends SyntaxElement> T handle(T expr) {
        expr.setFileName(this.fileName);
        return expr;
    }

    public Case createCase(IToken start, Expression cond, Expression then) {
        return this.handle(new Case(ExpressionFactory.start(start), then.getEnd(), ExpressionFactory.line(start), start.getStartOffset(), then.getEndOffset(), cond, then));
    }

    public SwitchExpression createSwitchExpression(IToken start, IToken end, Expression switchExpr, List<Case> cases, Expression defaultExpr) {
        return this.handle(new SwitchExpression(ExpressionFactory.start(start), ExpressionFactory.end(end), ExpressionFactory.line(start), start.getStartOffset(), end.getEndOffset(), switchExpr, cases, defaultExpr));
    }

    public ChainExpression createChainExpression(Expression head, Expression next) {
        return this.handle(new ChainExpression(head.getStart(), next.getEnd(), head.getLine(), head.getStartOffset(), next.getEndOffset(), head, next));
    }

    public RealLiteral createRealLiteral(IToken token) {
        return this.handle(new RealLiteral(ExpressionFactory.start(token), ExpressionFactory.end(token), ExpressionFactory.line(token), token.getStartOffset(), token.getEndOffset(), token.toString()));
    }

    public FeatureCall createTypeSelectExpression(IToken id, IToken c1, Identifier ident, Expression e) {
        return this.handle(new TypeSelectExpression(ExpressionFactory.end(c1), c1.getEndOffset(), this.createIdentifier(id), ident, e));
    }

    public BooleanOperation createBooleanOperation(int start, int end, int line, int startOffset, int endOffest, IToken name, Expression e, Expression r) {
        return this.handle(new BooleanOperation(start, end, line, startOffset, endOffest, name.toString(), e, r));
    }

    public LetExpression createLetExpression(IToken start, IToken v, Expression varExpr, Expression target) {
        return this.handle(new LetExpression(ExpressionFactory.start(start), target.getEnd(), ExpressionFactory.line(start), start.getStartOffset(), target.getEndOffset(), this.createIdentifier(v), varExpr, target));
    }

    public Expression createConstructorCall(IToken s, Identifier type) {
        return this.handle(new ConstructorCallExpression(ExpressionFactory.start(s), type.getEnd(), ExpressionFactory.line(s), s.getStartOffset(), type.getEndOffset(), type));
    }
}

