/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.internal.listener;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;

public class NotationSemProc
extends TriggerListener {
    private static NotationPackage notation = NotationPackage.eINSTANCE;
    private static Set autoNamedElements = new HashSet();
    private static Set nonAutoNamedElements = new HashSet();

    static {
        autoNamedElements.add(notation.getDiagram());
    }

    private boolean shouldHandleNotification(Notification notification) {
        Object newValue;
        if (notification.getNotifier() instanceof EObject && notification.getFeature() instanceof EReference && ((EReference)notification.getFeature()).isContainment() && (newValue = notification.getNewValue()) != null) {
            if (newValue instanceof Diagram) {
                return true;
            }
            if (newValue instanceof Collection) {
                Collection collection = (Collection)newValue;
                Iterator iter = collection.iterator();
                while (iter.hasNext()) {
                    if (!(iter.next() instanceof Diagram)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected Command trigger(TransactionalEditingDomain editingDomain, Notification notification) {
        if (!this.shouldHandleNotification(notification)) {
            return null;
        }
        int eventType = notification.getEventType();
        Object notifier = notification.getNotifier();
        Object feature = notification.getFeature();
        Object newValue = notification.getNewValue();
        if (notifier instanceof EObject) {
            EObject eObject = (EObject)notifier;
            if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                if (eventType == 3 && newValue instanceof EObject) {
                    return this.getAutoNameCommand(editingDomain, eObject, (EReference)feature, (EObject)newValue);
                }
                if (eventType == 5 && newValue instanceof Collection) {
                    return this.getAutoNameCommand(editingDomain, eObject, (EReference)feature, (Collection)newValue);
                }
                if ((eventType == 1 || eventType == 2) && newValue instanceof EObject) {
                    return this.getAutoNameCommand(editingDomain, eObject, (EReference)feature, (EObject)newValue);
                }
            }
        }
        return null;
    }

    private Command getAutoNameCommand(TransactionalEditingDomain editingDomain, final EObject container, final EReference reference, final Collection objects) {
        return new RecordingCommand(editingDomain){

            protected void doExecute() {
                NotationSemProc.autoName(container, reference, objects);
            }
        };
    }

    private Command getAutoNameCommand(TransactionalEditingDomain editingDomain, final EObject container, final EReference reference, final EObject eObject) {
        return new RecordingCommand(editingDomain){

            protected void doExecute() {
                NotationSemProc.autoName(container, reference, eObject);
            }
        };
    }

    private static boolean canAutoName(EClass eClass) {
        if (autoNamedElements.contains(eClass)) {
            return true;
        }
        if (nonAutoNamedElements.contains(eClass)) {
            return false;
        }
        Iterator i = eClass.getESuperTypes().iterator();
        while (i.hasNext()) {
            if (!NotationSemProc.canAutoName((EClass)i.next())) continue;
            return true;
        }
        return false;
    }

    private static void autoName(EObject container, EReference reference, Collection objects) {
        for (Object object : objects) {
            if (!(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            NotationSemProc.autoName(container, reference, eObject);
        }
    }

    private static void autoName(EObject container, EReference reference, EObject eObject) {
        String name = null;
        if (!(eObject instanceof Diagram)) {
            return;
        }
        name = ((Diagram)eObject).getName();
        if (name == null || name.equals("") && NotationSemProc.canAutoName(eObject.eClass())) {
            name = PackageUtil.getLocalizedName((ENamedElement)eObject.eClass());
            if (reference.isMany()) {
                String n;
                HashSet<String> set = new HashSet<String>();
                for (Object sibling : (Collection)container.eGet((EStructuralFeature)reference)) {
                    if (sibling == null) continue;
                    n = null;
                    if (sibling instanceof Diagram) {
                        n = ((Diagram)sibling).getName();
                    }
                    if (n == null) continue;
                    set.add(n);
                }
                int j = 1;
                while (j <= Integer.MAX_VALUE) {
                    n = String.valueOf(name) + j;
                    if (!set.contains(n)) {
                        name = n;
                        break;
                    }
                    ++j;
                }
            }
            if (eObject instanceof Diagram) {
                ((Diagram)eObject).setName(name);
            }
        }
    }
}

