/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.io.Serializable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;

public class Rectangle
implements Cloneable,
Serializable,
Translatable {
    private static final long serialVersionUID = 1L;
    public static final Rectangle SINGLETON = new Rectangle();
    public int height;
    public int width;
    public int x;
    public int y;

    public Rectangle() {
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(org.eclipse.swt.graphics.Rectangle rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public Rectangle(Point p, Dimension size) {
        this(p.x(), p.y(), size.width(), size.height());
    }

    public Rectangle(Point p1, Point p2) {
        this.x = Math.min(p1.x(), p2.x());
        this.y = Math.min(p1.y(), p2.y());
        this.width = Math.abs(p2.x() - p1.x()) + 1;
        this.height = Math.abs(p2.y() - p1.y()) + 1;
    }

    public Rectangle(Rectangle rect) {
        this(rect.x(), rect.y(), rect.width(), rect.height());
    }

    public int bottom() {
        return this.y + this.height;
    }

    public boolean contains(double x, double y) {
        return this.contains((int)x, (int)y);
    }

    public boolean contains(int x, int y) {
        return y >= this.y && y < this.y + this.height && x >= this.x && x < this.x + this.width;
    }

    public boolean contains(Point p) {
        return this.contains(p.x(), p.y());
    }

    public boolean contains(Rectangle rect) {
        return this.x <= rect.x() && this.y <= rect.y() && this.right() >= rect.right() && this.bottom() >= rect.bottom();
    }

    public Rectangle crop(Insets insets) {
        return this.shrink(insets);
    }

    public boolean equals(int x, int y, int width, int height) {
        return this.x == x && this.y == y && this.width == width && this.height == height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Rectangle) {
            Rectangle r = (Rectangle)o;
            return this.x == r.x() && this.y == r.y() && this.width == r.width() && this.height == r.height();
        }
        return false;
    }

    public Rectangle expand(double h, double v) {
        return this.expand((int)h, (int)v);
    }

    public Rectangle expand(Insets insets) {
        this.x -= insets.left;
        this.y -= insets.top;
        this.width += insets.getWidth();
        this.height += insets.getHeight();
        return this;
    }

    public Rectangle expand(int h, int v) {
        return this.shrink(-h, -v);
    }

    public Point getBottom() {
        return new Point(this.x + this.width / 2, this.bottom());
    }

    public Point getBottomLeft() {
        return new Point(this.x, this.y + this.height);
    }

    public Point getBottomRight() {
        return new Point(this.x + this.width, this.y + this.height);
    }

    public Point getCenter() {
        return new Point(this.x + this.width / 2, this.y + this.height / 2);
    }

    public Rectangle getCopy() {
        if (this.getClass() == Rectangle.class) {
            return new Rectangle(this);
        }
        try {
            return (Rectangle)this.clone();
        }
        catch (CloneNotSupportedException exc) {
            return new Rectangle(this);
        }
    }

    public Rectangle getCropped(Insets insets) {
        return this.getShrinked(insets);
    }

    public Rectangle getExpanded(double h, double v) {
        return this.getCopy().expand(h, v);
    }

    public Rectangle getExpanded(Insets insets) {
        return this.getCopy().expand(insets);
    }

    public Rectangle getExpanded(int h, int v) {
        return this.getCopy().expand(h, v);
    }

    public Rectangle getIntersection(Rectangle rect) {
        return this.getCopy().intersect(rect);
    }

    public Point getLeft() {
        return new Point(this.x, this.y + this.height / 2);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public int getPosition(Point p) {
        int result = 0;
        if (this.contains(p)) {
            return result;
        }
        if (p.x() < this.x) {
            result = 8;
        } else if (p.x() >= this.x + this.width) {
            result = 16;
        }
        if (p.y() < this.y) {
            result |= 1;
        } else if (p.y() >= this.y + this.height) {
            result |= 4;
        }
        return result;
    }

    public Rectangle getResized(Dimension d) {
        return this.getCopy().resize(d);
    }

    public Rectangle getResized(double w, double h) {
        return this.getCopy().resize(w, h);
    }

    public Rectangle getResized(int w, int h) {
        return this.getCopy().resize(w, h);
    }

    public Point getRight() {
        return new Point(this.right(), this.y + this.height / 2);
    }

    public Rectangle getShrinked(double h, double v) {
        return this.getCopy().shrink(h, v);
    }

    public Rectangle getShrinked(Insets insets) {
        return this.getCopy().shrink(insets);
    }

    public Rectangle getShrinked(int h, int v) {
        return this.getCopy().shrink(h, v);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public Point getTop() {
        return new Point(this.x + this.width / 2, this.y);
    }

    public Point getTopLeft() {
        return new Point(this.x, this.y);
    }

    public Point getTopRight() {
        return new Point(this.x + this.width, this.y);
    }

    public Rectangle getTranslated(double dx, double dy) {
        return this.getCopy().translate(dx, dy);
    }

    public Rectangle getTranslated(int dx, int dy) {
        return this.getCopy().translate(dx, dy);
    }

    public Rectangle getTranslated(Point pt) {
        return this.getCopy().translate(pt);
    }

    public Rectangle getTransposed() {
        return this.getCopy().transpose();
    }

    public Rectangle getUnion(Point p) {
        Rectangle copy = this.getCopy();
        copy.union(p);
        return copy;
    }

    public Rectangle getUnion(Rectangle rect) {
        return this.getCopy().union(rect);
    }

    public int hashCode() {
        return (this.x + this.height + 1) * (this.y + this.width + 1) ^ this.x ^ this.y;
    }

    public int height() {
        return this.height;
    }

    public Rectangle intersect(Rectangle rect) {
        int x1 = Math.max(this.x, rect.x());
        int x2 = Math.min(this.x + this.width, rect.x() + rect.width());
        int y1 = Math.max(this.y, rect.y());
        int y2 = Math.min(this.y + this.height, rect.y() + rect.height());
        if (x2 - x1 < 0 || y2 - y1 < 0) {
            return this.setBounds(0, 0, 0, 0);
        }
        return this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean intersects(Rectangle rect) {
        return !this.getIntersection(rect).isEmpty();
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    @Override
    public void performScale(double factor) {
        this.scale(factor);
    }

    @Override
    public void performTranslate(int dx, int dy) {
        this.translate(dx, dy);
    }

    public double preciseHeight() {
        return this.height;
    }

    public double preciseWidth() {
        return this.width;
    }

    public double preciseX() {
        return this.x;
    }

    public double preciseY() {
        return this.y;
    }

    public Rectangle resize(Dimension d) {
        this.width += d.width();
        this.height += d.height();
        return this;
    }

    public Rectangle resize(double w, double h) {
        return this.resize((int)w, (int)h);
    }

    public Rectangle resize(int w, int h) {
        this.width += w;
        this.height += h;
        return this;
    }

    public int right() {
        return this.x + this.width;
    }

    public final Rectangle scale(double scaleFactor) {
        return this.scale(scaleFactor, scaleFactor);
    }

    public Rectangle scale(double scaleX, double scaleY) {
        int oldX = this.x;
        int oldY = this.y;
        this.x = (int)Math.floor((double)this.x * scaleX);
        this.y = (int)Math.floor((double)this.y * scaleY);
        this.width = (int)Math.ceil((double)(oldX + this.width) * scaleX) - this.x;
        this.height = (int)Math.ceil((double)(oldY + this.height) * scaleY) - this.y;
        return this;
    }

    public Rectangle setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        return this;
    }

    public Rectangle setBounds(Point location, Dimension size) {
        return this.setBounds(location.x(), location.y(), size.width(), size.height());
    }

    public Rectangle setBounds(Rectangle rect) {
        return this.setBounds(rect.x(), rect.y(), rect.width(), rect.height());
    }

    public Rectangle setHeight(int height) {
        this.height = height;
        return this;
    }

    public Rectangle setLocation(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Rectangle setLocation(Point p) {
        return this.setLocation(p.x(), p.y());
    }

    public Rectangle setSize(Dimension d) {
        return this.setSize(d.width(), d.height());
    }

    public Rectangle setSize(int w, int h) {
        this.width = w;
        this.height = h;
        return this;
    }

    public Rectangle setWidth(int width) {
        this.width = width;
        return this;
    }

    public Rectangle setX(int x) {
        this.x = x;
        return this;
    }

    public Rectangle setY(int y) {
        this.y = y;
        return this;
    }

    public Rectangle shrink(double h, double v) {
        return this.shrink((int)h, (int)v);
    }

    public Rectangle shrink(Insets insets) {
        if (insets == null) {
            return this;
        }
        this.x += insets.left;
        this.y += insets.top;
        this.width -= insets.getWidth();
        this.height -= insets.getHeight();
        return this;
    }

    public Rectangle shrink(int h, int v) {
        this.x += h;
        this.width -= h + h;
        this.y += v;
        this.height -= v + v;
        return this;
    }

    public String toString() {
        return "Rectangle(" + this.preciseX() + ", " + this.preciseY() + ", " + this.preciseWidth() + ", " + this.preciseHeight() + ")";
    }

    public boolean touches(Rectangle rect) {
        return rect.x() <= this.x + this.width && rect.y() <= this.y + this.height && rect.x() + rect.width() >= this.x && rect.y() + rect.height() >= this.y;
    }

    public Rectangle translate(double dx, double dy) {
        return this.translate((int)dx, (int)dy);
    }

    public Rectangle translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public Rectangle translate(Point p) {
        this.x += p.x;
        this.y += p.y;
        return this;
    }

    public Rectangle transpose() {
        int temp = this.x;
        this.x = this.y;
        this.y = temp;
        temp = this.width;
        this.width = this.height;
        this.height = temp;
        return this;
    }

    public Rectangle union(Dimension d) {
        this.width = Math.max(this.width, d.width);
        this.height = Math.max(this.height, d.height);
        return this;
    }

    public Rectangle union(double x, double y) {
        return this.union((int)x, (int)y);
    }

    public Rectangle union(double x, double y, double w, double h) {
        return this.union((int)x, (int)y, (int)w, (int)h);
    }

    public Rectangle union(int x1, int y1) {
        if (x1 < this.x) {
            this.width += this.x - x1;
            this.x = x1;
        } else {
            int right = this.x + this.width;
            if (x1 >= right) {
                right = x1 + 1;
                this.width = right - this.x;
            }
        }
        if (y1 < this.y) {
            this.height += this.y - y1;
            this.y = y1;
        } else {
            int bottom = this.y + this.height;
            if (y1 >= bottom) {
                bottom = y1 + 1;
                this.height = bottom - this.y;
            }
        }
        return this;
    }

    public Rectangle union(int x, int y, int w, int h) {
        int right = Math.max(this.x + this.width, x + w);
        int bottom = Math.max(this.y + this.height, y + h);
        this.x = Math.min(this.x, x);
        this.y = Math.min(this.y, y);
        this.width = right - this.x;
        this.height = bottom - this.y;
        return this;
    }

    public void union(Point p) {
        this.union(p.x(), p.y());
    }

    public Rectangle union(Rectangle rect) {
        if (rect == null || rect.isEmpty()) {
            return this;
        }
        return this.union(rect.x, rect.y, rect.width, rect.height);
    }

    public int width() {
        return this.width;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }
}

