/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.properties.actions;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.dialogs.PropertiesDialog;
import org.eclipse.gmf.runtime.common.ui.services.properties.extended.PropertyPagePropertyDescriptor;
import org.eclipse.gmf.runtime.emf.ui.properties.internal.EMFPropertiesDebugOptions;
import org.eclipse.gmf.runtime.emf.ui.properties.internal.EMFPropertiesPlugin;
import org.eclipse.gmf.runtime.emf.ui.properties.internal.l10n.EMFUIPropertiesMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class PropertyPageViewAction
extends Action {
    public PropertyPageViewAction() {
        super(EMFUIPropertiesMessages.PropertyPageViewAction_label, AbstractUIPlugin.imageDescriptorFromPlugin((String)EMFPropertiesPlugin.getPluginId(), (String)"icons/property_page.gif"));
        this.setToolTipText(EMFUIPropertiesMessages.PropertyPageViewAction_tooltip);
    }

    public void run() {
        TransactionalEditingDomain domain;
        ISelection selection;
        Trace.trace((Plugin)EMFPropertiesPlugin.getDefault(), (String)EMFPropertiesDebugOptions.METHODS_ENTERING, (String)"PropertyPageViewActionDelegate.doRun Entering");
        IWorkbenchPage page = EMFPropertiesPlugin.getActivePage();
        if (page != null && (selection = page.getSelection()) != null && selection instanceof IStructuredSelection && (domain = this.getEditingDomain((IStructuredSelection)selection)) != null) {
            try {
                domain.runExclusive(new Runnable(){

                    @Override
                    public void run() {
                        List propertyPages = PropertyPageViewAction.this.getMergedPropertyPages((IStructuredSelection)selection);
                        if (!propertyPages.isEmpty()) {
                            Collections.sort(propertyPages, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    IPreferencePage p1 = (IPreferencePage)o1;
                                    IPreferencePage p2 = (IPreferencePage)o2;
                                    String s1 = p1.getTitle();
                                    String s2 = p2.getTitle();
                                    return Collator.getInstance().compare(s1, s2);
                                }
                            });
                            PropertiesDialog dialog = new PropertiesDialog(Display.getCurrent().getActiveShell(), new PreferenceManager());
                            Iterator iter = propertyPages.iterator();
                            while (iter.hasNext()) {
                                dialog.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("", (IPreferencePage)iter.next()));
                            }
                            dialog.create();
                            dialog.open();
                        } else {
                            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)EMFUIPropertiesMessages.PropertyPageViewAction_NoPropertiesMessageBox_Title, (String)EMFUIPropertiesMessages.PropertyPageViewAction_NoPropertiesMessageBox_Message);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                Trace.catching((Plugin)EMFPropertiesPlugin.getDefault(), (String)EMFPropertiesDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"run", (Throwable)e);
                Log.error((Plugin)EMFPropertiesPlugin.getDefault(), (int)3, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        Trace.trace((Plugin)EMFPropertiesPlugin.getDefault(), (String)EMFPropertiesDebugOptions.METHODS_EXITING, (String)"PropertyPageViewActionDelegate.doRun Exiting");
    }

    private List getMergedPropertyPages(IStructuredSelection selection) {
        List mergedDescriptors = this.computeMergedPropertyDescriptors(selection);
        ArrayList mergedPages = new ArrayList();
        if (mergedDescriptors != null) {
            for (PropertyPagePropertyDescriptor descriptor : mergedDescriptors) {
                List pages = descriptor.createPropertyPages();
                pages.removeAll(mergedPages);
                mergedPages.addAll(pages);
            }
        }
        return mergedPages;
    }

    private List computeMergedPropertyDescriptors(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return new ArrayList(0);
        }
        Map[] propertyDescriptorMaps = new Map[selection.size()];
        Iterator i = selection.iterator();
        int index = 0;
        while (i.hasNext()) {
            Object object = i.next();
            IPropertySource source = (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
            if (source == null) {
                return new ArrayList(0);
            }
            propertyDescriptorMaps[index] = this.computePropertyDescriptorsFor(source);
            ++index;
        }
        Map intersection = propertyDescriptorMaps[0];
        int p = 1;
        while (p < propertyDescriptorMaps.length) {
            Object[] ids = intersection.keySet().toArray();
            int j = 0;
            while (j < ids.length) {
                Object object = propertyDescriptorMaps[p].get(ids[j]);
                if (object == null || !((IPropertyDescriptor)intersection.get(ids[j])).isCompatibleWith((IPropertyDescriptor)object)) {
                    intersection.remove(ids[j]);
                }
                ++j;
            }
            ++p;
        }
        return new ArrayList(intersection.values());
    }

    private Map computePropertyDescriptorsFor(IPropertySource source) {
        IPropertyDescriptor[] descriptors = source.getPropertyDescriptors();
        HashMap<Object, IPropertyDescriptor> result = new HashMap<Object, IPropertyDescriptor>(descriptors.length * 2 + 1);
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i] instanceof PropertyPagePropertyDescriptor) {
                result.put(descriptors[i].getId(), descriptors[i]);
            }
            ++i;
        }
        return result;
    }

    private TransactionalEditingDomain getEditingDomain(IStructuredSelection s) {
        TransactionalEditingDomain result = null;
        for (Object next : s) {
            result = TransactionUtil.getEditingDomain(next);
            if (result == null && next instanceof IAdaptable) {
                EObject eObject = (EObject)((IAdaptable)next).getAdapter(EObject.class);
                result = TransactionUtil.getEditingDomain((EObject)eObject);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

