/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.bridge.ui.dashboard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IMemento;

public final class DashboardState {
    private static final String DM_KEY = "domainModel";
    private static final String DGM_KEY = "domainGenerationModel";
    private static final String GDM_KEY = "graphicalDefinitionModel";
    private static final String TDM_KEY = "toolingDefinitionModel";
    private static final String MM_KEY = "mappingModel";
    private static final String GM_KEY = "generationModel";
    private URI dm;
    private URI dgm;
    private URI gdm;
    private URI tdm;
    private URI mm;
    private URI gm;

    public DashboardState() {
    }

    public DashboardState(IMemento memento) {
        if (memento != null) {
            this.read(memento);
        }
    }

    public URI getDM() {
        return this.dm;
    }

    public URI getDGM() {
        return this.dgm;
    }

    public URI getGDM() {
        return this.gdm;
    }

    public URI getTDM() {
        return this.tdm;
    }

    public URI getMM() {
        return this.mm;
    }

    public URI getGM() {
        return this.gm;
    }

    public void setDM(URI uri) {
        this.dm = uri;
    }

    public void setDGM(URI uri) {
        this.dgm = uri;
    }

    public void setGDM(URI uri) {
        this.gdm = uri;
    }

    public void setTDM(URI uri) {
        this.tdm = uri;
    }

    public void setMM(URI uri) {
        this.mm = uri;
    }

    public void setGM(URI uri) {
        this.gm = uri;
    }

    public void setDM(IFile file) {
        this.dm = DashboardState.getURI(file);
    }

    public void setDGM(IFile file) {
        this.dgm = DashboardState.getURI(file);
    }

    public void setGDM(IFile file) {
        this.gdm = DashboardState.getURI(file);
    }

    public void setTDM(IFile file) {
        this.tdm = DashboardState.getURI(file);
    }

    public void setMM(IFile file) {
        this.mm = DashboardState.getURI(file);
    }

    public void setGM(IFile file) {
        this.gm = DashboardState.getURI(file);
    }

    private static URI getURI(IFile file) {
        if (file == null) {
            return null;
        }
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    public int getModelsCount() {
        return 6;
    }

    public int getSpecifiedModelsCount() {
        int count = 0;
        if (this.dm != null) {
            ++count;
        }
        if (this.dgm != null) {
            ++count;
        }
        if (this.gdm != null) {
            ++count;
        }
        if (this.tdm != null) {
            ++count;
        }
        if (this.mm != null) {
            ++count;
        }
        if (this.gm != null) {
            ++count;
        }
        return count;
    }

    private void read(IMemento memento) {
        this.dm = DashboardState.read(memento, DM_KEY);
        this.dgm = DashboardState.read(memento, DGM_KEY);
        this.gdm = DashboardState.read(memento, GDM_KEY);
        this.tdm = DashboardState.read(memento, TDM_KEY);
        this.mm = DashboardState.read(memento, MM_KEY);
        this.gm = DashboardState.read(memento, GM_KEY);
    }

    private static URI read(IMemento memento, String key) {
        String s = memento.getString(key);
        if (s == null) {
            return null;
        }
        try {
            return URI.createURI((String)s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public void write(IMemento memento) {
        DashboardState.write(memento, DM_KEY, this.dm);
        DashboardState.write(memento, DGM_KEY, this.dgm);
        DashboardState.write(memento, GDM_KEY, this.gdm);
        DashboardState.write(memento, TDM_KEY, this.tdm);
        DashboardState.write(memento, MM_KEY, this.mm);
        DashboardState.write(memento, GM_KEY, this.gm);
    }

    private static void write(IMemento memento, String key, URI uri) {
        String s = null;
        if (uri != null) {
            s = uri.toString();
        }
        memento.putString(key, s);
    }
}

