/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class WizardUtil {
    private WizardUtil() {
    }

    public static String getDefaultFileName(IStructuredSelection selection, String defaultName, String extension) {
        Object selected;
        if (selection != null && !selection.isEmpty() && (selected = selection.getFirstElement()) instanceof IFile) {
            return WizardUtil.getDefaultFileName((IFile)selected, extension);
        }
        return String.valueOf(defaultName) + '.' + extension;
    }

    public static String getDefaultFileName(IFile file, String extension) {
        String fileNameBase = WizardUtil.getFileBaseName(file);
        String modelFilename = String.valueOf(fileNameBase) + '.' + extension;
        int i = 1;
        while (file.getParent().findMember(modelFilename) != null) {
            modelFilename = String.valueOf(fileNameBase) + i + '.' + extension;
            ++i;
        }
        return modelFilename;
    }

    public static String getCapped(String s) {
        if (s == null) {
            return "";
        }
        return (s = s.trim()).length() > 1 ? String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1) : s.toUpperCase();
    }

    public static String getCapName(EObject element) {
        if (element instanceof EClass) {
            return WizardUtil.getCapName((EClass)element);
        }
        if (element instanceof EStructuralFeature) {
            return WizardUtil.getCapName((EStructuralFeature)element);
        }
        return null;
    }

    public static String getCapName(EClass type) {
        return WizardUtil.getCapped(type.getName());
    }

    public static String getCapName(EStructuralFeature feature) {
        EClass type = feature.getEContainingClass();
        return String.valueOf(WizardUtil.getCapped(type.getName())) + WizardUtil.getCapped(feature.getName());
    }

    public static void saveModel(IWizardContainer container, final Resource resource) throws Exception {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("ENCODING", "UTF-8");
                        resource.save(options);
                    }
                    catch (Exception exception) {
                        Plugin.log(exception);
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        container.run(false, false, (IRunnableWithProgress)operation);
    }

    public static boolean openEditor(IFile modelFile) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
            workbenchWindow.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        try {
            page.openEditor((IEditorInput)new FileEditorInput(modelFile), workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)NLS.bind((String)Messages.WizardUtilUnableToOpenEditor, (Object)modelFile), (String)exception.getMessage());
            return false;
        }
        return true;
    }

    public static void selectReveal(IWorkbench workbench, final ISelection selection) {
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            workbench.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(selection);
                }
            });
        }
    }

    public static void openInEditor(IWorkbench workbench, IFile file) throws PartInitException {
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        page.openEditor((IEditorInput)new FileEditorInput(file), workbench.getEditorRegistry().getDefaultEditor(file.getFullPath().toString()).getId());
    }

    public static IFile findExistingFile(IStructuredSelection selection, String fileExt) {
        if (selection == null || selection.isEmpty() || !(selection.getFirstElement() instanceof IFile)) {
            return null;
        }
        IFile selected = (IFile)selection.getFirstElement();
        String fileNameBase = WizardUtil.getFileBaseName(selected);
        IResource candidate = selected.getParent().findMember(String.valueOf(fileNameBase) + '.' + fileExt);
        if (candidate != null && candidate.getType() == 1 && candidate.exists()) {
            return (IFile)candidate;
        }
        return null;
    }

    private static String getFileBaseName(IFile file) {
        String fileNameBase = file.getName();
        if (file.getFileExtension() != null) {
            fileNameBase = fileNameBase.substring(0, fileNameBase.length() - (file.getFileExtension().length() + 1));
        }
        return fileNameBase;
    }
}

