/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.genmodel;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.gmf.common.codegen.ImportAssistant;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureAccessor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FigureHandle;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeFQNSwitch;
import org.eclipse.gmf.graphdef.codegen.FigureGenerator;
import org.eclipse.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.gmf.graphdef.codegen.NamingStrategy;
import org.eclipse.gmf.internal.bridge.genmodel.DefaultViewmapProducer;
import org.eclipse.gmf.internal.common.codegen.NullImportAssistant;

public class InnerClassViewmapProducer
extends DefaultViewmapProducer {
    private final FigureGenerator figureGenerator;
    private final FigureQualifiedNameSwitch fqnSwitch;
    private final Set<Figure> processedFigures;

    public InnerClassViewmapProducer() {
        this((FigureQualifiedNameSwitch)new RuntimeFQNSwitch(), MapModeCodeGenStrategy.DYNAMIC, null);
    }

    public InnerClassViewmapProducer(FigureQualifiedNameSwitch figureNameSwitch, MapModeCodeGenStrategy mapModeCodeGenStrategy, URL[] dynamicFigureTemplates) {
        assert (figureNameSwitch != null);
        this.fqnSwitch = figureNameSwitch;
        this.processedFigures = new HashSet<Figure>();
        this.figureGenerator = new FigureGenerator(this.fqnSwitch, mapModeCodeGenStrategy, null, true, dynamicFigureTemplates);
    }

    public Viewmap create(Node node) {
        if (node.getFigure() == null) {
            return super.create(node);
        }
        Viewmap viewmap = this.createViewmap((FigureHandle)node.getNodeFigure());
        this.setupResizeConstraints(viewmap, node);
        this.setupLayoutType(viewmap, node);
        this.setupDefaultSize(viewmap, node);
        return viewmap;
    }

    public Viewmap create(Connection link) {
        if (link.getFigure() == null) {
            return super.create(link);
        }
        return this.createViewmap((FigureHandle)link.getConnectionFigure());
    }

    public Viewmap create(DiagramLabel label) {
        if (label.getFigure() == null) {
            return super.create(label);
        }
        return this.createViewmap(label.getFigure());
    }

    public Viewmap create(Compartment compartment) {
        FigureHandle handle = compartment.getFigure();
        if (handle == null) {
            return super.create(compartment);
        }
        return this.createViewmap(compartment.getFigure());
    }

    private Viewmap createFigureViewmap(Figure figure) {
        FigureViewmap result;
        if (EcoreUtil.isAncestor(this.processedFigures, (EObject)figure.getParent())) {
            ParentAssignedViewmap v = GMFGenFactory.eINSTANCE.createParentAssignedViewmap();
            v.setGetterName(NamingStrategy.INSTANCE.getChildFigureGetterName(figure));
            v.setFigureQualifiedClassName(this.fqnSwitch.get((EObject)figure));
            result = v;
        } else if (InnerClassViewmapProducer.isBareInstance(figure)) {
            FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
            v.setFigureQualifiedClassName(this.fqnSwitch.get((EObject)figure));
            result = v;
        } else {
            InnerClassViewmap v = GMFGenFactory.eINSTANCE.createInnerClassViewmap();
            NullImportAssistant importManager = new NullImportAssistant(null, CodeGenUtil.validJavaIdentifier((String)figure.getName()));
            v.setClassBody(this.figureGenerator.go(figure, (ImportAssistant)importManager));
            v.setClassName(importManager.getCompilationUnitName());
            result = v;
        }
        if (!(result instanceof ParentAssignedViewmap)) {
            this.setupPluginDependencies((Viewmap)result, figure);
        }
        this.processedFigures.add(figure);
        return result;
    }

    private Viewmap createViewmap(FigureHandle figure) {
        Viewmap result;
        if (figure instanceof Figure) {
            result = this.createFigureViewmap((Figure)figure);
        } else if (figure instanceof FigureAccessor) {
            result = this.createFigureAccessorViewmap((FigureAccessor)figure);
        } else {
            throw new IllegalStateException();
        }
        this.setupStyleAttributes(result, figure);
        return result;
    }

    private Viewmap createFigureAccessorViewmap(FigureAccessor figureAccess) {
        ParentAssignedViewmap v = GMFGenFactory.eINSTANCE.createParentAssignedViewmap();
        v.setGetterName(figureAccess.getAccessor());
        if (figureAccess.getTypedFigure() != null) {
            v.setFigureQualifiedClassName(figureAccess.getTypedFigure().getQualifiedClassName());
        }
        return v;
    }

    private void setupPluginDependencies(Viewmap viewmap, Figure figure) {
        FigureGallery gallery = InnerClassViewmapProducer.findAncestorFigureGallery(figure);
        if (gallery != null) {
            viewmap.getRequiredPluginIDs().addAll((Collection)Arrays.asList(this.fqnSwitch.getDependencies(gallery)));
        }
    }

    public static FigureGallery findAncestorFigureGallery(Figure figure) {
        EObject next;
        Figure current = figure;
        while ((next = current.eContainer()) instanceof Figure) {
            current = next;
        }
        if (next instanceof FigureGallery) {
            return (FigureGallery)next;
        }
        return null;
    }

    private static boolean isBareInstance(Figure figure) {
        if (!figure.getChildren().isEmpty()) {
            return false;
        }
        LinkedList featuresToCheck = new LinkedList(figure.eClass().getEAllStructuralFeatures());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getIdentity_Name());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getFigure_Children());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getFigureMarker_Parent());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getFigureHandle_ReferencingElements());
        if (figure instanceof CustomFigure) {
            featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomClass_BundleName());
            featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomClass_QualifiedClassName());
            featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomFigure_CustomChildren());
        }
        for (EStructuralFeature next : featuresToCheck) {
            if (next.isDerived() || !figure.eIsSet(next)) continue;
            return false;
        }
        return true;
    }
}

