/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.ui.action.actions.global;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.GlobalUndoAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class GlobalUndoActionTest
extends TestCase {
    private GlobalUndoAction undoAction;
    private IViewPart part;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        TestRunner.run((Test)GlobalUndoActionTest.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.common.ui.action.actions.global.GlobalUndoActionTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz, "GlobalUndoAction Test Suite");
    }

    protected void setUp() throws Exception {
        this.part = (IViewPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        IOperationHistory history = OperationHistoryFactory.getOperationHistory();
        UndoContext undoContext = new UndoContext();
        this.undoAction = new GlobalUndoAction((IWorkbenchPart)this.part);
        this.undoAction.setUndoContext((IUndoContext)undoContext);
        AbstractOperation operation = new AbstractOperation("test_nullWorkbenchPart"){

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }

            public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return null;
            }

            public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return null;
            }
        };
        try {
            operation.addContext((IUndoContext)undoContext);
            history.execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            GlobalUndoActionTest.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
    }

    public void test_dispose_131781() {
        SafeRunnable.setIgnoreErrors((boolean)false);
        this.undoAction.setUndoContext(this.undoAction.getUndoContext());
        GlobalUndoActionTest.assertTrue((boolean)this.undoAction.isEnabled());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(this.part);
        GlobalUndoActionTest.assertFalse((boolean)this.undoAction.isEnabled());
        SafeRunnable.setIgnoreErrors((boolean)true);
    }

    public void test_nullUndoContext() {
        GlobalUndoActionTest.assertTrue((boolean)this.undoAction.isEnabled());
        this.undoAction.setUndoContext(null);
        GlobalUndoActionTest.assertFalse((boolean)this.undoAction.isEnabled());
    }
}

