/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.map.editor.part.GMFMapDiagramEditorPlugin;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.DesignLabelMapping;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.GMFMapPackage;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class GMFMapVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(GMFMapDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("GMFMap".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return GMFMapVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                GMFMapDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return GMFMapVisualIDRegistry.getDiagramVisualID(domainElement, domainElementMetaclass);
    }

    private static int getDiagramVisualID(EObject domainElement, EClass domainElementMetaclass) {
        if (GMFMapPackage.eINSTANCE.getMapping().isSuperTypeOf(domainElementMetaclass) && GMFMapVisualIDRegistry.isDiagramMapping_1000((Mapping)domainElement)) {
            return 1000;
        }
        return GMFMapVisualIDRegistry.getUnrecognizedDiagramID(domainElement);
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return GMFMapVisualIDRegistry.getNodeVisualID(containerView, domainElement, domainElementMetaclass, null);
    }

    public static int getNodeVisualID(View containerView, EObject domainElement, EClass domainElementMetaclass, String semanticHint) {
        int containerVisualID;
        String containerModelID = GMFMapVisualIDRegistry.getModelID(containerView);
        if (!"GMFMap".equals(containerModelID)) {
            return -1;
        }
        if ("GMFMap".equals(containerModelID)) {
            containerVisualID = GMFMapVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        int nodeVisualID = semanticHint != null ? GMFMapVisualIDRegistry.getVisualID(semanticHint) : -1;
        switch (containerVisualID) {
            case 2001: {
                if (5001 == nodeVisualID) {
                    return 5001;
                }
                if (7001 == nodeVisualID) {
                    return 7001;
                }
                return GMFMapVisualIDRegistry.getUnrecognizedCanvasMapping_2001ChildNodeID(domainElement, semanticHint);
            }
            case 2003: {
                if (5003 == nodeVisualID) {
                    return 5003;
                }
                if (7003 == nodeVisualID) {
                    return 7003;
                }
                if (7004 == nodeVisualID) {
                    return 7004;
                }
                return GMFMapVisualIDRegistry.getUnrecognizedNodeMapping_2003ChildNodeID(domainElement, semanticHint);
            }
            case 2002: {
                if (5002 == nodeVisualID) {
                    return 5002;
                }
                if (7002 == nodeVisualID) {
                    return 7002;
                }
                return GMFMapVisualIDRegistry.getUnrecognizedLinkMapping_2002ChildNodeID(domainElement, semanticHint);
            }
            case 3001: {
                if (5005 == nodeVisualID) {
                    return 5005;
                }
                return GMFMapVisualIDRegistry.getUnrecognizedTopNodeReference_3001ChildNodeID(domainElement, semanticHint);
            }
            case 3006: {
                return GMFMapVisualIDRegistry.getUnrecognizedFeatureLabelMapping_3006ChildNodeID(domainElement, semanticHint);
            }
            case 3007: {
                return GMFMapVisualIDRegistry.getUnrecognizedDesignLabelMapping_3007ChildNodeID(domainElement, semanticHint);
            }
            case 3002: {
                return GMFMapVisualIDRegistry.getUnrecognizedLabelMapping_3002ChildNodeID(domainElement, semanticHint);
            }
            case 3004: {
                if (5006 == nodeVisualID) {
                    return 5006;
                }
                return GMFMapVisualIDRegistry.getUnrecognizedChildReference_3004ChildNodeID(domainElement, semanticHint);
            }
            case 3005: {
                if (5004 == nodeVisualID) {
                    return 5004;
                }
                return GMFMapVisualIDRegistry.getUnrecognizedCompartmentMapping_3005ChildNodeID(domainElement, semanticHint);
            }
            case 3008: {
                return GMFMapVisualIDRegistry.getUnrecognizedFeatureLabelMapping_3008ChildNodeID(domainElement, semanticHint);
            }
            case 3009: {
                return GMFMapVisualIDRegistry.getUnrecognizedDesignLabelMapping_3009ChildNodeID(domainElement, semanticHint);
            }
            case 3003: {
                return GMFMapVisualIDRegistry.getUnrecognizedLabelMapping_3003ChildNodeID(domainElement, semanticHint);
            }
            case 7001: {
                if ((semanticHint == null || 3001 == nodeVisualID) && GMFMapPackage.eINSTANCE.getTopNodeReference().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFMapVisualIDRegistry.isNodeTopNodeReference_3001((TopNodeReference)domainElement))) {
                    return 3001;
                }
                return GMFMapVisualIDRegistry.getUnrecognizedCanvasMappingContents_7001ChildNodeID(domainElement, semanticHint);
            }
            case 7003: {
                if ((semanticHint == null || 3006 == nodeVisualID) && GMFMapPackage.eINSTANCE.getFeatureLabelMapping().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFMapVisualIDRegistry.isNodeFeatureLabelMapping_3006((FeatureLabelMapping)domainElement))) {
                    return 3006;
                }
                if ((semanticHint == null || 3007 == nodeVisualID) && GMFMapPackage.eINSTANCE.getDesignLabelMapping().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFMapVisualIDRegistry.isNodeDesignLabelMapping_3007((DesignLabelMapping)domainElement))) {
                    return 3007;
                }
                if ((semanticHint == null || 3002 == nodeVisualID) && GMFMapPackage.eINSTANCE.getLabelMapping().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFMapVisualIDRegistry.isNodeLabelMapping_3002((LabelMapping)domainElement))) {
                    return 3002;
                }
                return GMFMapVisualIDRegistry.getUnrecognizedNodeMappingLabels_7003ChildNodeID(domainElement, semanticHint);
            }
            case 7004: {
                if ((semanticHint == null || 3004 == nodeVisualID) && GMFMapPackage.eINSTANCE.getChildReference().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFMapVisualIDRegistry.isNodeChildReference_3004((ChildReference)domainElement))) {
                    return 3004;
                }
                if ((semanticHint == null || 3005 == nodeVisualID) && GMFMapPackage.eINSTANCE.getCompartmentMapping().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFMapVisualIDRegistry.isNodeCompartmentMapping_3005((CompartmentMapping)domainElement))) {
                    return 3005;
                }
                return GMFMapVisualIDRegistry.getUnrecognizedNodeMappingContents_7004ChildNodeID(domainElement, semanticHint);
            }
            case 7002: {
                if ((semanticHint == null || 3008 == nodeVisualID) && GMFMapPackage.eINSTANCE.getFeatureLabelMapping().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFMapVisualIDRegistry.isNodeFeatureLabelMapping_3008((FeatureLabelMapping)domainElement))) {
                    return 3008;
                }
                if ((semanticHint == null || 3009 == nodeVisualID) && GMFMapPackage.eINSTANCE.getDesignLabelMapping().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFMapVisualIDRegistry.isNodeDesignLabelMapping_3009((DesignLabelMapping)domainElement))) {
                    return 3009;
                }
                if ((semanticHint == null || 3003 == nodeVisualID) && GMFMapPackage.eINSTANCE.getLabelMapping().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFMapVisualIDRegistry.isNodeLabelMapping_3003((LabelMapping)domainElement))) {
                    return 3003;
                }
                return GMFMapVisualIDRegistry.getUnrecognizedLinkMappingLabels_7002ChildNodeID(domainElement, semanticHint);
            }
            case 1000: {
                if ((semanticHint == null || 2001 == nodeVisualID) && GMFMapPackage.eINSTANCE.getCanvasMapping().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFMapVisualIDRegistry.isNodeCanvasMapping_2001((CanvasMapping)domainElement))) {
                    return 2001;
                }
                if ((semanticHint == null || 2003 == nodeVisualID) && GMFMapPackage.eINSTANCE.getNodeMapping().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFMapVisualIDRegistry.isNodeNodeMapping_2003((NodeMapping)domainElement))) {
                    return 2003;
                }
                if ((semanticHint == null || 2002 == nodeVisualID) && GMFMapPackage.eINSTANCE.getLinkMapping().isSuperTypeOf(domainElementMetaclass) && (domainElement == null || GMFMapVisualIDRegistry.isNodeLinkMapping_2002((LinkMapping)domainElement))) {
                    return 2002;
                }
                return GMFMapVisualIDRegistry.getUnrecognizedMapping_1000ChildNodeID(domainElement, semanticHint);
            }
        }
        return -1;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        EClass domainElementMetaclass = domainElement.eClass();
        return GMFMapVisualIDRegistry.getLinkWithClassVisualID(domainElement, domainElementMetaclass);
    }

    public static int getLinkWithClassVisualID(EObject domainElement, EClass domainElementMetaclass) {
        return GMFMapVisualIDRegistry.getUnrecognizedLinkWithClassID(domainElement);
    }

    private static boolean isDiagramMapping_1000(Mapping element) {
        return true;
    }

    private static int getUnrecognizedDiagramID(EObject domainElement) {
        return -1;
    }

    private static boolean isNodeCanvasMapping_2001(CanvasMapping element) {
        return true;
    }

    private static boolean isNodeNodeMapping_2003(NodeMapping element) {
        return true;
    }

    private static boolean isNodeLinkMapping_2002(LinkMapping element) {
        return true;
    }

    private static boolean isNodeTopNodeReference_3001(TopNodeReference element) {
        return true;
    }

    private static boolean isNodeFeatureLabelMapping_3006(FeatureLabelMapping element) {
        return true;
    }

    private static boolean isNodeDesignLabelMapping_3007(DesignLabelMapping element) {
        return true;
    }

    private static boolean isNodeLabelMapping_3002(LabelMapping element) {
        return true;
    }

    private static boolean isNodeChildReference_3004(ChildReference element) {
        return true;
    }

    private static boolean isNodeCompartmentMapping_3005(CompartmentMapping element) {
        return true;
    }

    private static boolean isNodeFeatureLabelMapping_3008(FeatureLabelMapping element) {
        return true;
    }

    private static boolean isNodeDesignLabelMapping_3009(DesignLabelMapping element) {
        return true;
    }

    private static boolean isNodeLabelMapping_3003(LabelMapping element) {
        return true;
    }

    private static int getUnrecognizedCanvasMapping_2001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedNodeMapping_2003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLinkMapping_2002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedTopNodeReference_3001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedFeatureLabelMapping_3006ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedDesignLabelMapping_3007ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLabelMapping_3002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedChildReference_3004ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedCompartmentMapping_3005ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedFeatureLabelMapping_3008ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedDesignLabelMapping_3009ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLabelMapping_3003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedCanvasMappingContents_7001ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedNodeMappingLabels_7003ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedNodeMappingContents_7004ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLinkMappingLabels_7002ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedMapping_1000ChildNodeID(EObject domainElement, String semanticHint) {
        return -1;
    }

    private static int getUnrecognizedLinkWithClassID(EObject domainElement) {
        return -1;
    }
}

