/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class OffscreenEditPartFactory {
    private static OffscreenEditPartFactory INSTANCE = new OffscreenEditPartFactory();

    public static OffscreenEditPartFactory getInstance() {
        return INSTANCE;
    }

    public DiagramEditPart createDiagramEditPart(Diagram diagram) {
        return this.createDiagramEditPart(diagram, new Shell(), null);
    }

    public DiagramEditPart createDiagramEditPart(Diagram diagram, Shell shell) {
        return this.createDiagramEditPart(diagram, shell, null);
    }

    public DiagramEditPart createDiagramEditPart(Diagram diagram, Shell shell, PreferencesHint preferencesHint) {
        DiagramGraphicalViewer customViewer = new DiagramGraphicalViewer();
        customViewer.createControl((Composite)shell);
        DiagramEditDomain editDomain = new DiagramEditDomain(null);
        editDomain.setCommandStack(new DiagramCommandStack(editDomain));
        customViewer.setEditDomain((EditDomain)editDomain);
        RootEditPart rootEP = EditPartService.getInstance().createRootEditPart(diagram);
        if (rootEP instanceof IDiagramPreferenceSupport) {
            if (preferencesHint == null) {
                preferencesHint = ((IDiagramPreferenceSupport)rootEP).getPreferencesHint();
            } else {
                ((IDiagramPreferenceSupport)rootEP).setPreferencesHint(preferencesHint);
            }
            customViewer.hookWorkspacePreferenceStore((IPreferenceStore)preferencesHint.getPreferenceStore());
        }
        customViewer.setRootEditPart(rootEP);
        customViewer.setEditPartFactory(EditPartService.getInstance());
        DiagramEventBroker.startListening((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)diagram));
        customViewer.setContents(diagram);
        customViewer.flush();
        Assert.isTrue((boolean)(customViewer.getContents() instanceof DiagramEditPart));
        Display display = Display.getCurrent();
        if (display != null) {
            while (!display.readAndDispatch()) {
            }
        }
        return (DiagramEditPart)customViewer.getContents();
    }
}

