/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkConstraints;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelMatcher;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.GeneratedCanvasTest;
import org.eclipse.gmf.tests.setup.LinksSessionSetup;

public class LinkCreationConstraintsTest
extends GeneratedCanvasTest {
    public LinkCreationConstraintsTest(String name) {
        super(name);
        this.myDefaultSetup = LinksSessionSetup.newInstance();
    }

    public void testEndContexts() {
        GenLink genLinkOrigin = this.getGenModel().getLinkC();
        GenLink genLink = (GenLink)EcoreUtil.copy((EObject)genLinkOrigin);
        LinkCreationConstraintsTest.assertTrue((boolean)(genLink.getModelFacet() instanceof TypeLinkModelFacet));
        TypeLinkModelFacet tlModelFacet = (TypeLinkModelFacet)genLink.getModelFacet();
        LinkCreationConstraintsTest.assertTrue((tlModelFacet.getContainmentMetaFeature() != null && tlModelFacet.getTargetMetaFeature() != null ? 1 : 0) != 0);
        GenLinkConstraints constraints = GMFGenFactory.eINSTANCE.createGenLinkConstraints();
        constraints.setSourceEnd(LinkCreationConstraintsTest.createDummyConstraint());
        constraints.setTargetEnd(LinkCreationConstraintsTest.createDummyConstraint());
        genLink.setCreationConstraints(constraints);
        LinkCreationConstraintsTest.assertSame((String)"Target end context must be the containment feature owner", (Object)tlModelFacet.getContainmentMetaFeature().getGenClass(), (Object)constraints.getSourceEndContextClass());
        LinkCreationConstraintsTest.assertSame((String)"Source end context must be the target feature type", (Object)tlModelFacet.getTargetMetaFeature().getTypeGenClass(), (Object)constraints.getTargetEndContextClass());
        GenModelMatcher genModelMatcher = new GenModelMatcher(this.getGenModel().getGenDiagram().getDomainDiagramElement().getGenModel());
        GenFeature sourceFeature = genModelMatcher.findGenFeature(tlModelFacet.getMetaClass().getEcoreClass().getEStructuralFeature("source"));
        LinkCreationConstraintsTest.assertNotNull((String)"Link element's source feature not found", (Object)sourceFeature);
        tlModelFacet.setSourceMetaFeature(sourceFeature);
        LinkCreationConstraintsTest.assertSame((String)"Source end context with source feature must the feature's owner class", (Object)sourceFeature.getTypeGenClass(), (Object)constraints.getSourceEndContextClass());
    }

    private static GenConstraint createDummyConstraint() {
        GenConstraint constraint = GMFGenFactory.eINSTANCE.createGenConstraint();
        constraint.setBody("dummy");
        return constraint;
    }

    public void testCreateConstrainedLinks() throws Exception {
        Diagram diagram = (Diagram)this.getDiagramEditPart().getModel();
        Node sourceContainerNode = this.createNode((GenCommonBase)this.getSourceGenNode(), (View)diagram);
        this.setBusinessElementStructuralFeature((View)sourceContainerNode, "acceptLinkKind", null);
        Node targetNode = this.createNode((GenCommonBase)this.getTargetGenNode(), (View)diagram);
        LinkCreationConstraintsTest.assertNotNull((Object)this.findEditPart((View)targetNode));
        this.setBusinessElementStructuralFeature((View)sourceContainerNode, "acceptLinkKind", null);
        LinkCreationConstraintsTest.assertFalse((String)"Can start link without acceptedLinkKind", (boolean)this.canStartLinkFrom(this.getRefGenLink(), (View)sourceContainerNode));
        String linkKind = "kind1";
        this.setBusinessElementStructuralFeature((View)sourceContainerNode, "acceptLinkKind", linkKind);
        LinkCreationConstraintsTest.assertTrue((String)"Allow start link with acceptedLinkKind", (boolean)this.canStartLinkFrom(this.getRefGenLink(), (View)sourceContainerNode));
        LinkCreationConstraintsTest.assertNull((String)"Do not create link to node with different linkKind", (Object)this.createLink(this.getRefGenLink(), (View)sourceContainerNode, (View)targetNode));
        this.setBusinessElementStructuralFeature((View)targetNode, "acceptLinkKind", linkKind);
        Edge link = this.createLink(this.getRefGenLink(), (View)sourceContainerNode, (View)targetNode);
        LinkCreationConstraintsTest.assertNotNull((String)"Link start should be allowed", (Object)link);
        LinkCreationConstraintsTest.assertNull((String)"Do not create already existing link", (Object)this.createLink(this.getRefGenLink(), (View)sourceContainerNode, (View)targetNode));
        LinkCreationConstraintsTest.assertFalse((String)"Do allow start for 2nd link", (boolean)this.canStartLinkFrom(this.getRefGenLink(), (View)sourceContainerNode));
        LinkCreationConstraintsTest.assertNotNull((String)"Should create link for nodes with equal acceptLinkKind", (Object)this.createLink(this.getClassGenLink(), (View)sourceContainerNode, (View)targetNode));
        this.setBusinessElementStructuralFeature((View)sourceContainerNode, "acceptLinkKind", null);
        LinkCreationConstraintsTest.assertTrue((String)"Should start link with no restriction", (boolean)this.canStartLinkFrom(this.getClassGenLink(), (View)sourceContainerNode));
        LinkCreationConstraintsTest.assertNull((String)"Should not create link for nodes with different acceptLinkKind", (Object)this.createLink(this.getClassGenLink(), (View)sourceContainerNode, (View)targetNode));
        this.setBusinessElementStructuralFeature((View)targetNode, "acceptLinkKind", "kind1");
        this.setBusinessElementStructuralFeature((View)sourceContainerNode, "acceptLinkKind", "kind1");
        LinkCreationConstraintsTest.assertTrue((boolean)this.canStartLinkFrom(this.getClassGenLink(), (View)sourceContainerNode));
        LinkCreationConstraintsTest.assertNotNull((String)"Should create link for nodes with equal acceptLinkKind", (Object)this.createLink(this.getClassGenLink(), (View)sourceContainerNode, (View)targetNode));
    }

    private GenLink getRefGenLink() {
        return this.getGenModel().getLinkD();
    }

    private GenNode getSourceGenNode() {
        return this.getGenModel().getNodeA();
    }

    private GenLink getClassGenLink() {
        return this.getGenModel().getLinkC();
    }

    private GenNode getTargetGenNode() {
        return this.getGenModel().getNodeB();
    }

    private boolean canStartLinkFrom(GenLink linkType, View source) {
        Command cmd = this.getViewerConfiguration().getStartLinkCommand(source, (GenCommonBase)linkType);
        return cmd != null && cmd.canExecute();
    }

    private void setBusinessElementStructuralFeature(View view, String featureName, Object value) {
        Command command = this.getViewerConfiguration().getSetBusinessElementStructuralFeatureCommand(view, featureName, value);
        LinkCreationConstraintsTest.assertNotNull((String)"Command is null", (Object)command);
        command.execute();
    }
}

