/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractMigrationVisitor
implements IResourceVisitor {
    private IProgressMonitor progressMonitor;

    public AbstractMigrationVisitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    protected static CoreException createCoreException(Throwable th) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.gmf.xtend.migration", "Exception during migration", th));
    }

    public boolean visit(IResource resource) throws CoreException {
        if (this.progressMonitor.isCanceled()) {
            throw AbstractMigrationVisitor.createCoreException(new InterruptedException());
        }
        if (resource instanceof IContainer) {
            this.visitContainer((IContainer)resource);
            return true;
        }
        if (resource instanceof IFile) {
            String extension = resource.getProjectRelativePath().getFileExtension();
            if ("xpt".equals(extension)) {
                this.visitXpandResource((IFile)resource);
            } else if ("ext".equals(extension)) {
                this.visitXtendResource((IFile)resource);
            } else {
                this.visitOtherResource((IFile)resource);
            }
        }
        return false;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    protected abstract void visitXtendResource(IFile var1) throws CoreException;

    protected abstract void visitXpandResource(IFile var1) throws CoreException;

    protected abstract void visitOtherResource(IFile var1) throws CoreException;

    protected abstract void visitContainer(IContainer var1) throws CoreException;
}

