/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import org.eclipse.gmf.internal.xpand.ast.TextStatement;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.model.Output;

public abstract class AbstractOutput
implements Output {
    private boolean deleteLine = false;

    public void enterStatement(SyntaxElement stmt) {
        if (stmt instanceof TextStatement) {
            this.deleteLine = ((TextStatement)stmt).isDeleteLine();
        }
    }

    public void exitStatement(SyntaxElement stmt) {
        this.deleteLine = false;
    }

    public void write(String text) {
        if (this.deleteLine) {
            int i = 0;
            while (i < text.length()) {
                char charAt = text.charAt(i);
                if (Character.isWhitespace(charAt) && (charAt == '\r' || charAt == '\n') && i + 1 < text.length()) {
                    char nextToLF;
                    if ((nextToLF = text.charAt(++i)) == charAt || nextToLF != '\n' && nextToLF != '\r') break;
                    ++i;
                    break;
                }
                ++i;
            }
            this.doAppend(text.substring(i));
            this.deleteLine = false;
        } else {
            this.doAppend(text);
        }
    }

    protected abstract void doAppend(String var1);
}

