/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionHandleEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SortFilterCompartmentItemsEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.NoteAttachmentReorientEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.swt.graphics.Color;

public abstract class ShapeNodeEditPart
extends ShapeEditPart
implements INodeEditPart {
    public ShapeNodeEditPart(View view) {
        super(view);
    }

    protected List getModelSourceConnections() {
        return ViewUtil.getSourceConnectionsConnectingVisibleViews((View)((View)this.getModel()));
    }

    protected List getModelTargetConnections() {
        return ViewUtil.getTargetConnectionsConnectingVisibleViews((View)((View)this.getModel()));
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new GraphicalNodeEditPolicy());
        this.installEditPolicy("SortFilterPolicy", (EditPolicy)new SortFilterCompartmentItemsEditPolicy());
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new ConnectionHandleEditPolicy());
        this.installEditPolicy("NoteAttachmentReorient", (EditPolicy)new NoteAttachmentReorientEditPolicy());
    }

    protected final IFigure createFigure() {
        return this.createNodeFigure();
    }

    protected abstract NodeFigure createNodeFigure();

    protected NodeFigure getNodeFigure() {
        return (NodeFigure)this.getFigure();
    }

    public ConnectionAnchor getSourceConnectionAnchor(org.eclipse.gef.ConnectionEditPart connEditPart) {
        final ConnectionEditPart connection = (ConnectionEditPart)connEditPart;
        String t = "";
        try {
            t = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = connection.getEdge().getSourceAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getSourceConnectionAnchor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getSourceConnectionAnchor", (Throwable)e);
        }
        return this.getNodeFigure().getConnectionAnchor(t);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof ReconnectRequest) {
            if (((DropRequest)request).getLocation() == null) {
                return this.getNodeFigure().getSourceConnectionAnchorAt(null);
            }
            Point pt = ((DropRequest)request).getLocation().getCopy();
            return this.getNodeFigure().getSourceConnectionAnchorAt(pt);
        }
        if (request instanceof DropRequest) {
            return this.getNodeFigure().getSourceConnectionAnchorAt(((DropRequest)request).getLocation());
        }
        return this.getNodeFigure().getSourceConnectionAnchorAt(null);
    }

    public ConnectionAnchor getTargetConnectionAnchor(org.eclipse.gef.ConnectionEditPart connEditPart) {
        final ConnectionEditPart connection = (ConnectionEditPart)connEditPart;
        String t = "";
        try {
            t = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = connection.getEdge().getTargetAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getTargetConnectionAnchor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getTargetConnectionAnchor", (Throwable)e);
        }
        return this.getNodeFigure().getConnectionAnchor(t);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof ReconnectRequest) {
            if (((DropRequest)request).getLocation() == null) {
                return this.getNodeFigure().getTargetConnectionAnchorAt(null);
            }
            Point pt = ((DropRequest)request).getLocation().getCopy();
            return this.getNodeFigure().getTargetConnectionAnchorAt(pt);
        }
        if (request instanceof DropRequest) {
            return this.getNodeFigure().getTargetConnectionAnchorAt(((DropRequest)request).getLocation());
        }
        return this.getNodeFigure().getTargetConnectionAnchorAt(null);
    }

    public final String mapConnectionAnchorToTerminal(ConnectionAnchor c) {
        return this.getNodeFigure().getConnectionAnchorTerminal(c);
    }

    public final ConnectionAnchor mapTerminalToConnectionAnchor(String terminal) {
        return this.getNodeFigure().getConnectionAnchor(terminal);
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getView_SourceEdges().equals(feature)) {
            this.refreshSourceConnections();
        } else if (NotationPackage.eINSTANCE.getView_TargetEdges().equals(feature)) {
            this.refreshTargetConnections();
        } else if (NotationPackage.eINSTANCE.getFillStyle_Gradient().equals(feature) || NotationPackage.eINSTANCE.getFillStyle_FillColor().equals(feature)) {
            this.refreshBackgroundColor();
        } else if (NotationPackage.eINSTANCE.getFillStyle_Transparency().equals(feature)) {
            this.refreshTransparency();
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    public boolean canAttachNote() {
        return true;
    }

    protected void refreshBackgroundColor() {
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (style != null) {
            if (style.getGradient() == null || !this.supportsGradient()) {
                this.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(new Integer(style.getFillColor())));
            } else {
                this.setGradient(style.getGradient());
            }
        }
    }

    protected void refreshTransparency() {
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (style != null) {
            this.setTransparency(style.getTransparency());
        }
    }

    protected void setBackgroundColor(Color c) {
        NodeFigure fig = this.getNodeFigure();
        fig.setBackgroundColor(c);
        fig.setIsUsingGradient(false);
        fig.setGradientData(-1, -1, 0);
    }

    protected void setGradient(GradientData gradient) {
        NodeFigure fig = this.getNodeFigure();
        if (gradient != null) {
            fig.setIsUsingGradient(true);
            fig.setGradientData(gradient.getGradientColor1(), gradient.getGradientColor2(), gradient.getGradientStyle());
        } else {
            fig.setIsUsingGradient(false);
        }
    }

    protected void setTransparency(int transp) {
        NodeFigure fig = this.getNodeFigure();
        fig.setTransparency(transp);
    }

    public boolean supportsGradient() {
        return false;
    }

    public boolean supportsRoundedCorners() {
        return false;
    }
}

