/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.gmf.internal.common.codegen.DefaultTextMerger;
import org.eclipse.gmf.internal.common.codegen.TextMerger;

public class TestDefaultMergeService
extends TestCase {
    private DefaultTextMerger myMergeService;

    public TestDefaultMergeService(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        URL controlFile = Platform.getBundle((String)"org.eclipse.gmf.codegen").getEntry("/templates/emf-merge.xml");
        JControlModel controlModel = new JControlModel();
        controlModel.initialize(CodeGenUtil.instantiateFacadeHelper((String)JMerger.DEFAULT_FACADE_HELPER_CLASS), controlFile.toString());
        TestDefaultMergeService.assertTrue((boolean)controlModel.canMerge());
        this.myMergeService = this.createMergeService(controlModel);
    }

    protected final DefaultTextMerger createMergeService(JControlModel controlModel) {
        return new DefaultTextMerger(controlModel);
    }

    public void testProcessHitRightMethod() {
        boolean[] hitXML = new boolean[1];
        boolean[] hitPluginXML = new boolean[1];
        boolean[] hitManifestMF = new boolean[1];
        class TextMergeHitTest
        extends TextMerger {
            private final /* synthetic */ boolean[] val$hitXML;
            private final /* synthetic */ boolean[] val$hitPluginXML;
            private final /* synthetic */ boolean[] val$hitManifestMF;

            TextMergeHitTest(boolean[] blArray, boolean[] blArray2, boolean[] blArray3) {
                this.val$hitXML = blArray;
                this.val$hitPluginXML = blArray2;
                this.val$hitManifestMF = blArray3;
            }

            public String mergeXML(String oldText, String newText) {
                this.val$hitXML[0] = true;
                return super.mergeXML(oldText, newText);
            }

            public String mergePluginXML(String oldText, String newText) {
                this.val$hitPluginXML[0] = true;
                return super.mergePluginXML(oldText, newText);
            }

            public String mergeManifestMF(String oldText, String newText) {
                this.val$hitManifestMF[0] = true;
                return super.mergeManifestMF(oldText, newText);
            }
        }
        TextMergeHitTest hitTest = new TextMergeHitTest(hitXML, hitPluginXML, hitManifestMF);
        hitManifestMF[0] = false;
        hitPluginXML[0] = false;
        hitXML[0] = false;
        hitTest.process("MANIFEST.MF", "", "");
        TestDefaultMergeService.assertTrue((!hitXML[0] && !hitPluginXML[0] && hitManifestMF[0] ? 1 : 0) != 0);
        hitManifestMF[0] = false;
        hitPluginXML[0] = false;
        hitXML[0] = false;
        hitTest.process("sample.xml", "", "");
        TestDefaultMergeService.assertTrue((hitXML[0] && !hitPluginXML[0] && !hitManifestMF[0] ? 1 : 0) != 0);
        hitManifestMF[0] = false;
        hitPluginXML[0] = false;
        hitXML[0] = false;
        hitTest.process("plugin.xml", "", "");
        TestDefaultMergeService.assertTrue((!hitXML[0] && hitPluginXML[0] && !hitManifestMF[0] ? 1 : 0) != 0);
    }

    public void testProperties() throws Exception {
        String merged = this.myMergeService.mergeProperties("prop1=value1\nprop2=value2\n#propRemoved=\npropAdded=newValue\nprop3=value3\n", "prop1=value1\nprop2=modifiedValue2\npropRemoved=someValue\nprop3=value3\n");
        TestDefaultMergeService.assertNotNull((Object)merged);
        Properties result = new Properties();
        result.load(new ByteArrayInputStream(merged.getBytes()));
        TestDefaultMergeService.assertEquals((int)4, (int)result.size());
        TestDefaultMergeService.assertEquals((String)"value1", (String)result.getProperty("prop1"));
        TestDefaultMergeService.assertEquals((String)"value2", (String)result.getProperty("prop2"));
        TestDefaultMergeService.assertEquals((String)"value3", (String)result.getProperty("prop3"));
        TestDefaultMergeService.assertNull((Object)result.getProperty("propRemoved"));
        TestDefaultMergeService.assertEquals((String)"newValue", (String)result.getProperty("propAdded"));
    }

    public void testJava() {
        String mergeRes = this.myMergeService.mergeJava("/**\n* @generated\n*/\nclass B {\n/**\n* @generated\n*/\npublic void methodA() {new Object();}\nprotected void methodB() {new Object();}\n}", "/**\n* @generated\n*/\nclass B {\n/**\n* @generated\n*/\npublic void methodA() {new String();}\n/**\n* @generated\n*/\nprotected void methodB() {new String();}\n}");
        TestDefaultMergeService.assertEquals((String)"/**\n* @generated\n*/\nclass B {\n/**\n* @generated\n*/\npublic void methodA() {new String();}\nprotected void methodB() {new Object();}\n}", (String)mergeRes);
    }

    public void testJavaMergeNoControlModel() {
        DefaultTextMerger mergeServiceNoControl = this.createMergeService(new JControlModel());
        TestDefaultMergeService.assertEquals((String)"merger with uninitialized control model can't perform merge", (String)this.getJavaNewText(), (String)mergeServiceNoControl.mergeJava(this.getJavaOldText(), this.getJavaNewText()));
    }

    public void testProcessJava() {
        String javaResult = this.myMergeService.process("Sample.java", this.getJavaOldText(), this.getJavaNewText());
        TestDefaultMergeService.assertEquals((String)this.myMergeService.mergeJava(this.getJavaOldText(), this.getJavaNewText()), (String)javaResult);
    }

    public void testProcessXml() {
        String xmlResult = this.myMergeService.process("sample.xml", "<p>aaa<i>bbb</i>ccc</p>", "<p>ddd<b>e</b>ccc</p>");
        TestDefaultMergeService.assertEquals((String)this.myMergeService.mergeXML("<p>aaa<i>bbb</i>ccc</p>", "<p>ddd<b>e</b>ccc</p>"), (String)xmlResult);
    }

    public void testProcessProperties() {
        String propResult = this.myMergeService.process("sample.properties", "p1=v1\np2=v2\n#p3=\n", "p1=v1\np2=nv\np3=v3\n");
        TestDefaultMergeService.assertEquals((String)this.myMergeService.mergeProperties("p1=v1\np2=v2\n#p3=\n", "p1=v1\np2=nv\np3=v3\n"), (String)propResult);
    }

    private String getJavaOldText() {
        return "class A {}";
    }

    private String getJavaNewText() {
        return "class D {int c;}";
    }
}

