/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.migration.Activator;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.util.CompositeXpandResource;
import org.eclipse.gmf.internal.xpand.util.CompositeXtendResource;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.XpandResourceParser;
import org.eclipse.gmf.internal.xpand.util.XtendResourceParser;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;

public abstract class ResourceManagerImpl
implements ResourceManager {
    private final Map<String, XtendResource> cachedXtend = new TreeMap<String, XtendResource>();
    private final Map<String, XpandResource> cachedXpand = new TreeMap<String, XpandResource>();
    private static final String ASPECT_PREFIX = "aspects::";

    public XtendResource loadXtendResource(String fullyQualifiedName) {
        try {
            return this.loadXtendThroughCache(fullyQualifiedName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException ex) {
            Activator.logError(ex);
        }
        catch (ParserException ex) {
            this.handleParserException(ex);
        }
        return null;
    }

    protected XtendResource loadXtendThroughCache(String qualifiedName) throws IOException, ParserException {
        if (this.hasCachedXtend(qualifiedName)) {
            return this.cachedXtend.get(qualifiedName);
        }
        XtendResource loaded = this.doLoadXtendResource(qualifiedName);
        assert (loaded != null);
        if (this.shouldCache()) {
            this.cachedXtend.put(qualifiedName, loaded);
        }
        return loaded;
    }

    private XtendResource doLoadXtendResource(String fullyQualifiedName) throws IOException, ParserException {
        Reader[] rs = this.resolveMultiple(fullyQualifiedName, "ext");
        assert (rs != null && rs.length > 0);
        XtendResource[] result = this.loadXtendResources(rs, fullyQualifiedName);
        if (result.length == 1) {
            return result[0];
        }
        return new CompositeXtendResource(this, result);
    }

    public XpandResource loadXpandResource(String fullyQualifiedName) {
        try {
            return this.loadXpandThroughCache(fullyQualifiedName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException ex) {
            Activator.logWarn(ex.getMessage());
        }
        catch (ParserException ex) {
            this.handleParserException(ex);
        }
        return null;
    }

    protected XpandResource loadXpandThroughCache(String qualifiedName) throws IOException, ParserException {
        if (this.hasCachedXpand(qualifiedName)) {
            return this.cachedXpand.get(qualifiedName);
        }
        XpandResource loaded = this.doLoadXpandResource(qualifiedName);
        if (this.shouldCache()) {
            this.cachedXpand.put(qualifiedName, loaded);
        }
        return loaded;
    }

    private XpandResource doLoadXpandResource(String fullyQualifiedName) throws IOException, ParserException {
        Reader[] rs1 = this.resolveMultiple(fullyQualifiedName, "xpt");
        assert (rs1 != null && rs1.length > 0);
        XpandResource[] unadvised = this.loadXpandResources(rs1, fullyQualifiedName);
        XpandResource[] advices = null;
        try {
            String aspectsTemplateName = this.getAspectsTemplateName(fullyQualifiedName);
            Reader[] rs2 = this.resolveMultiple(aspectsTemplateName, "xpt");
            advices = this.loadXpandResources(rs2, aspectsTemplateName);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            Activator.logWarn(ex.getMessage());
        }
        catch (ParserException ex) {
            this.handleParserException(ex);
        }
        if (advices == null && unadvised.length == 1) {
            return unadvised[0];
        }
        return new CompositeXpandResource(this, unadvised, advices);
    }

    protected String getAspectsTemplateName(String fullyQualifiedName) {
        return ASPECT_PREFIX + fullyQualifiedName;
    }

    protected String getNonAspectsTemplateName(String possiblyAspectedFullyQualifiedName) {
        if (possiblyAspectedFullyQualifiedName == null) {
            return null;
        }
        if (possiblyAspectedFullyQualifiedName.startsWith(ASPECT_PREFIX)) {
            return possiblyAspectedFullyQualifiedName.substring(ASPECT_PREFIX.length());
        }
        return possiblyAspectedFullyQualifiedName;
    }

    protected abstract void handleParserException(ParserException var1);

    protected XtendResource[] loadXtendResources(Reader[] readers, String fullyQualifiedName) throws IOException, ParserException {
        XtendResource[] result = new XtendResource[readers.length];
        int i = 0;
        while (i < readers.length) {
            assert (readers[i] != null);
            try {
                result[i] = new XtendResourceParser().parse(readers[i], fullyQualifiedName);
                assert (result[i] != null);
            }
            catch (Throwable throwable) {
                try {
                    readers[i].close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                readers[i].close();
            }
            catch (Exception exception) {}
            ++i;
        }
        return result;
    }

    protected XpandResource[] loadXpandResources(Reader[] readers, String fullyQualifiedName) throws IOException, ParserException {
        XpandResource[] result = new XpandResource[readers.length];
        int i = 0;
        while (i < readers.length) {
            assert (readers[i] != null);
            try {
                result[i] = new XpandResourceParser().parse(readers[i], fullyQualifiedName);
                assert (result[i] != null);
            }
            catch (Throwable throwable) {
                try {
                    readers[i].close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                readers[i].close();
            }
            catch (Exception exception) {}
            ++i;
        }
        return result;
    }

    protected abstract boolean shouldCache();

    protected final boolean hasCachedXpand(String fullyQualifiedName) {
        return this.shouldCache() && this.cachedXpand.containsKey(fullyQualifiedName);
    }

    protected final boolean hasCachedXtend(String fullyQualifiedName) {
        return this.shouldCache() && this.cachedXtend.containsKey(fullyQualifiedName);
    }

    protected final void forgetCachedXpand(String fullyQualifiedName) {
        this.cachedXpand.remove(fullyQualifiedName);
    }

    protected final void forgetCachedXtend(String fullyQualifiedName) {
        this.cachedXtend.remove(fullyQualifiedName);
    }

    protected final void forgetAll() {
        this.cachedXpand.clear();
        this.cachedXtend.clear();
    }
}

