/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModelExt;
import org.eclipse.gmf.internal.xpand.migration.MigrationException;
import org.eclipse.gmf.internal.xpand.migration.ModeltypeImports;
import org.eclipse.gmf.internal.xpand.migration.OclKeywordManager;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;

public class TypeManager {
    private final ModeltypeImports modeltypeImportsManger;
    private boolean useFQNameForPrimitiveTypes = false;
    private OclKeywordManager oclKeywordManager;

    public TypeManager(OclKeywordManager keywordManager) {
        this(null, keywordManager);
    }

    public TypeManager(ModeltypeImports modelImports, OclKeywordManager keywordManager) {
        this.modeltypeImportsManger = modelImports;
        this.oclKeywordManager = keywordManager;
    }

    public void setUseFQNameForPrimitiveTypes(boolean value) {
        this.useFQNameForPrimitiveTypes = value;
    }

    public String getQvtFQName(EEnumLiteral literal) {
        return String.valueOf(this.getPackageName(literal.getEEnum().getEPackage())) + "::" + this.oclKeywordManager.getValidIdentifierValue(literal.getEEnum().getName()) + "::" + this.oclKeywordManager.getValidIdentifierValue(literal.getName());
    }

    public String getQvtFQName(EClassifier classifier) throws MigrationException {
        if (classifier == BuiltinMetaModel.VOID) {
            return "OclVoid";
        }
        if (classifier instanceof EDataType) {
            if (EcorePackage.eINSTANCE.getEString() == classifier) {
                return this.getPrimitiveTypeName("String", this.useFQNameForPrimitiveTypes);
            }
            if (EcorePackage.eINSTANCE.getEBoolean() == classifier) {
                return this.getPrimitiveTypeName("Boolean", this.useFQNameForPrimitiveTypes);
            }
            if (EcorePackage.eINSTANCE.getEInt() == classifier) {
                return this.getPrimitiveTypeName("Integer", this.useFQNameForPrimitiveTypes);
            }
            if (EcorePackage.eINSTANCE.getEDouble() == classifier) {
                return this.getPrimitiveTypeName("Real", this.useFQNameForPrimitiveTypes);
            }
            if (EcorePackage.eINSTANCE.getEJavaObject() == classifier) {
                return this.getPrimitiveTypeName("OclAny", this.useFQNameForPrimitiveTypes);
            }
        }
        if (BuiltinMetaModel.isCollectionType(classifier)) {
            StringBuilder sb = new StringBuilder();
            if (BuiltinMetaModelExt.isSetType(classifier)) {
                sb.append("Set");
            } else if (BuiltinMetaModelExt.isListType(classifier)) {
                sb.append("Sequence");
            } else if (BuiltinMetaModelExt.isOrderedSetType(classifier)) {
                sb.append("OrderedSet");
            } else {
                sb.append("Collection");
            }
            sb.append("(");
            sb.append(this.getQvtFQName(BuiltinMetaModel.getInnerType(classifier)));
            return sb.append(")").toString();
        }
        EPackage ePackage = classifier.getEPackage();
        assert (ePackage != null);
        return String.valueOf(this.getPackageName(ePackage)) + "::" + this.oclKeywordManager.getValidIdentifierValue(classifier.getName());
    }

    private String getPrimitiveTypeName(String primitiveTypeName, boolean useFQNameForPrimitiveTypes) {
        return useFQNameForPrimitiveTypes ? String.valueOf(OCLStandardLibraryImpl.stdlibPackage.getName()) + "::" + primitiveTypeName : primitiveTypeName;
    }

    private String getPackageName(EPackage ePackage) {
        return this.modeltypeImportsManger != null ? this.modeltypeImportsManger.getModeltypeAlias(ePackage) : this.oclKeywordManager.getValidIdentifierValue(ePackage.getName());
    }
}

