/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures.GeoShapeFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;

public class GeoShapeRoundedRectangleFigure
extends GeoShapeFigure
implements IPolygonAnchorableFigure {
    private int radius = 0;
    private PointList anchorBorderPointList;

    public GeoShapeRoundedRectangleFigure(int width, int height, int spacing, int radius) {
        super(width, height, spacing);
        this.radius = radius;
    }

    protected int getCornerRadius() {
        return this.radius;
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        int cornerRadius = this.getCornerRadius();
        g.fillRoundRectangle(r, cornerRadius, cornerRadius);
        g.setLineStyle(this.getLineStyle());
        g.setLineWidth(this.getLineWidth());
        g.drawRoundRectangle(r, cornerRadius, cornerRadius);
    }

    public PointList getAnchorBorderPointList() {
        int arcSize = this.getCornerRadius();
        PrecisionRectangle rBounds = new PrecisionRectangle(this.getBounds());
        PrecisionPoint keyPoint1 = new PrecisionPoint(rBounds.getTopLeft().x + arcSize / 2, rBounds.getTopLeft().y);
        PrecisionPoint keyPoint2 = new PrecisionPoint(rBounds.getTopLeft().x, rBounds.getTopLeft().y + arcSize / 2);
        PrecisionPoint keyPoint3 = new PrecisionPoint(rBounds.getBottomLeft().x, rBounds.getBottomLeft().y - arcSize / 2);
        PrecisionPoint keyPoint4 = new PrecisionPoint(rBounds.getBottomLeft().x + arcSize / 2, rBounds.getBottomLeft().y);
        PrecisionPoint keyPoint5 = new PrecisionPoint(rBounds.getBottomRight().x - arcSize / 2, rBounds.getBottomRight().y);
        PrecisionPoint keyPoint6 = new PrecisionPoint(rBounds.getBottomRight().x, rBounds.getBottomRight().y - arcSize / 2);
        PrecisionPoint keyPoint7 = new PrecisionPoint(rBounds.getTopRight().x, rBounds.getTopRight().y + arcSize / 2);
        PrecisionPoint keyPoint8 = new PrecisionPoint(rBounds.getTopRight().x - arcSize / 2, rBounds.getTopRight().y);
        PointList upperLeftPointList = new PointList();
        upperLeftPointList.addPoint((Point)keyPoint1);
        upperLeftPointList.addPoint(rBounds.getTopLeft().x + arcSize / 4, rBounds.getTopLeft().y + arcSize / 16);
        upperLeftPointList.addPoint(rBounds.getTopLeft().x + arcSize / 16, rBounds.getTopLeft().y + arcSize / 4);
        upperLeftPointList.addPoint((Point)keyPoint2);
        PointList lowerLeftPointList = new PointList();
        lowerLeftPointList.addPoint((Point)keyPoint3);
        lowerLeftPointList.addPoint(rBounds.getBottomLeft().x + arcSize / 16, rBounds.getBottomLeft().y - arcSize / 4);
        lowerLeftPointList.addPoint(rBounds.getBottomLeft().x + arcSize / 4, rBounds.getBottomLeft().y - arcSize / 16);
        lowerLeftPointList.addPoint((Point)keyPoint4);
        PointList lowerRightPointList = new PointList();
        lowerRightPointList.addPoint((Point)keyPoint5);
        lowerRightPointList.addPoint(rBounds.getBottomRight().x - arcSize / 4, rBounds.getBottomRight().y - arcSize / 16);
        lowerRightPointList.addPoint(rBounds.getBottomRight().x - arcSize / 16, rBounds.getBottomRight().y - arcSize / 4);
        lowerRightPointList.addPoint((Point)keyPoint6);
        PointList upperRightPointList = new PointList();
        upperRightPointList.addPoint((Point)keyPoint7);
        upperRightPointList.addPoint(rBounds.getTopRight().x - arcSize / 16, rBounds.getTopRight().y + arcSize / 4);
        upperRightPointList.addPoint(rBounds.getTopRight().x - arcSize / 4, rBounds.getTopRight().y + arcSize / 16);
        upperRightPointList.addPoint((Point)keyPoint8);
        PointList combinedPointList = new PointList();
        combinedPointList.addPoint((Point)keyPoint1);
        combinedPointList.addAll(PointListUtilities.calcSmoothPolyline((PointList)upperLeftPointList, (int)64, (int)16));
        combinedPointList.addPoint((Point)keyPoint2);
        combinedPointList.addPoint((Point)keyPoint3);
        combinedPointList.addAll(PointListUtilities.calcSmoothPolyline((PointList)lowerLeftPointList, (int)64, (int)16));
        combinedPointList.addPoint((Point)keyPoint4);
        combinedPointList.addPoint((Point)keyPoint5);
        combinedPointList.addAll(PointListUtilities.calcSmoothPolyline((PointList)lowerRightPointList, (int)64, (int)16));
        combinedPointList.addPoint((Point)keyPoint6);
        combinedPointList.addPoint((Point)keyPoint7);
        combinedPointList.addAll(PointListUtilities.calcSmoothPolyline((PointList)upperRightPointList, (int)64, (int)16));
        combinedPointList.addPoint((Point)keyPoint8);
        combinedPointList.addPoint((Point)keyPoint1);
        PointListUtilities.normalizeSegments((PointList)combinedPointList);
        return combinedPointList;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this.anchorBorderPointList = null;
    }

    public PointList getPolygonPoints() {
        if (this.anchorBorderPointList == null) {
            this.anchorBorderPointList = this.getAnchorBorderPointList();
        }
        return this.anchorBorderPointList.getCopy();
    }
}

