/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.expression.ast;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.ChainExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.SwitchExpression;
import org.eclipse.gmf.tests.expression.ast.ATypeModel;
import org.eclipse.gmf.tests.expression.ast.AbstractExpressionTest;

public class AnalyzationTest
extends AbstractExpressionTest {
    private Set<AnalysationIssue> issues;
    private ExecutionContext ec;
    private ATypeModel aType;

    protected void setUp() throws Exception {
        this.aType = new ATypeModel();
        this.ec = this.aType.newContext(null);
        this.issues = new HashSet<AnalysationIssue>();
    }

    private void dumpIssues() {
        for (AnalysationIssue element : this.issues) {
            System.out.println(String.valueOf(element.getType().toString()) + " - " + element.getMessage());
        }
    }

    public final void testEquals() {
        Expression expr = this.parse("true == null");
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEBoolean(), (Object)result);
        AnalyzationTest.assertTrue((boolean)this.issues.isEmpty());
    }

    public final void testStaticPropertyCall() {
        Expression expr = this.parse("evaluationTestModel::Type1::A_LITERAL");
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((Object)this.aType.getMetaEnum(), (Object)result);
        AnalyzationTest.assertTrue((boolean)this.issues.isEmpty());
    }

    public final void testCollectionLiteral1() {
        Expression expr = this.parse("{\"hallo\"}");
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEString()), (Object)result);
        AnalyzationTest.assertTrue((boolean)this.issues.isEmpty());
    }

    public final void testCollectionLiteral3() {
        Expression expr = this.parse("{3}");
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEInt()), (Object)result);
        AnalyzationTest.assertTrue((boolean)this.issues.isEmpty());
    }

    public final void testCollectionLiteral2() {
        Expression expr = this.parse("{\"hallo\",3}");
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEJavaObject()), (Object)result);
        AnalyzationTest.assertTrue((boolean)this.issues.isEmpty());
    }

    public final void testFeatureCall() {
        Expression expr = this.parse("test");
        this.ec = this.ec.cloneWithVariable(new Variable[]{this.newThisATypeVariable()});
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((Object)this.aType.getTestMetaAttr().getEType(), (Object)result);
        AnalyzationTest.assertTrue((boolean)this.issues.isEmpty());
    }

    public final void testFeatureCall1() {
        Expression expr = this.parse("this.test");
        this.ec = this.ec.cloneWithVariable(new Variable[]{this.newThisATypeVariable()});
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((Object)this.aType.getTestMetaAttr().getEType(), (Object)result);
        AnalyzationTest.assertTrue((boolean)this.issues.isEmpty());
    }

    public final void testOperationCall1() {
        Expression expr = this.parse("myOperation()");
        this.ec = this.ec.cloneWithVariable(new Variable[]{this.newThisATypeVariable()});
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((Object)this.aType.getMetaOp1().getEType(), (Object)result);
        AnalyzationTest.assertTrue((boolean)this.issues.isEmpty());
    }

    public final void testOperationCall2() {
        Expression expr = this.parse("myOperation(\"Test\")");
        this.ec = this.ec.cloneWithVariable(new Variable[]{this.newThisATypeVariable()});
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((Object)this.aType.getMetaOp2().getEType(), (Object)result);
        AnalyzationTest.assertTrue((boolean)this.issues.isEmpty());
    }

    public final void testOperationCall3() {
        Expression expr = this.parse("this.myOperation()");
        this.ec = this.ec.cloneWithVariable(new Variable[]{this.newThisATypeVariable()});
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((Object)this.aType.getMetaOp1().getEType(), (Object)result);
        AnalyzationTest.assertTrue((boolean)this.issues.isEmpty());
    }

    public final void testOperationCall4() {
        Expression expr = this.parse("this.myOperation(\"Test\")");
        this.ec = this.ec.cloneWithVariable(new Variable[]{this.newThisATypeVariable()});
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((Object)this.aType.getMetaOp2().getEType(), (Object)result);
        AnalyzationTest.assertTrue((boolean)this.issues.isEmpty());
    }

    public final void testSwitchExpr() {
        SwitchExpression expr = (SwitchExpression)this.parse("switch (3) { case \"Test\" : true default : false }");
        this.ec = this.ec.cloneWithVariable(new Variable[]{this.newThisATypeVariable()});
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)1, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEBoolean(), (Object)result);
    }

    public final void testSwitchExpr1() {
        SwitchExpression expr = (SwitchExpression)this.parse("switch (\"Horst\") { case \"Test\" : true default : 3 }");
        this.ec = this.ec.cloneWithVariable(new Variable[]{this.newThisATypeVariable()});
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEJavaObject(), (Object)result);
    }

    public final void testSwitchExpr2() {
        SwitchExpression expr = (SwitchExpression)this.parse("switch (\"\") { case \"Test\" : true default : false }");
        this.ec = this.ec.cloneWithVariable(new Variable[]{this.newThisATypeVariable()});
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEBoolean(), (Object)result);
    }

    public final void testChainExpr() {
        ChainExpression expr = (ChainExpression)this.parse("switch ('') { case \"Test\" : true default : false } -> 3");
        this.ec = this.ec.cloneWithVariable(new Variable[]{this.newThisATypeVariable()});
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEInt(), (Object)result);
    }

    public final void testChainExpr1() {
        ChainExpression expr = (ChainExpression)this.parse("true -> List[Object] -> 3 -> \"Test\"");
        this.ec = this.ec.cloneWithVariable(new Variable[]{this.newThisATypeVariable()});
        EClassifier result = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)result);
    }

    private Variable newThisATypeVariable() {
        return new Variable("this", (Object)this.aType.getMetaType());
    }

    public final void testTypeLiteral1() {
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)this.parse("String").analyze(this.ec, new HashSet()));
    }

    public final void testTypeLiteral2() {
        Expression e = this.parse("EClass.getEStructuralFeature('name')");
        EClassifier result = e.analyze(this.ec, new HashSet());
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), (Object)result);
    }

    public final void testTypeLiteral3() {
        Expression e = this.parse("Type1::A_LITERAL");
        EClassifier result = e.analyze(this.ec, new HashSet());
        AnalyzationTest.assertEquals((Object)this.aType.getMetaEnum(), (Object)result);
    }

    public final void testSelect() {
        Expression expr = this.parse(String.valueOf(this.aType.getMetaType().getName()) + ".eStructuralFeatures.select(element.name=='" + "test" + "').toList().get(0)");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertNotNull((Object)t);
    }

    public final void testTypeSelect() {
        Expression expr = this.parse("{3.4,3}.typeSelect(Integer)");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEInt()), (Object)t);
    }

    public final void testPath1() {
        Expression expr = this.parse("{'a','b','c'}.toUpperCase()");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEString()), (Object)t);
    }

    public final void testPath2() {
        Expression expr = this.parse("{'a','b','c'}.size()");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEInt(), (Object)t);
    }

    public final void testPath3() {
        Expression expr = this.parse("{'a','b','c'}.toUpperCase().length()");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEInt()), (Object)t);
    }

    public final void testPath4() {
        Expression expr = this.parse("{'a,b,c','a,b,c','a,b,c'}.split(',').length()");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEInt()), (Object)t);
    }

    public final void testImplies() {
        Expression expr = this.parse("true implies false");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEBoolean(), (Object)t);
    }

    public final void testImplies1() {
        Expression expr = this.parse("true implies null");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)1, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEBoolean(), (Object)t);
    }

    public final void testLet1() {
        Expression expr = this.parse("let x = true : x");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEBoolean(), (Object)t);
    }

    public final void testLet2() {
        Expression expr = this.parse("let x = true : 'test'+x");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)t);
    }

    public final void testLet3() {
        Expression expr = this.parse("let x = stuff : true");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)1, (int)this.issues.size());
        AnalyzationTest.assertNull((Object)t);
    }

    public final void testCast1() {
        Expression expr = this.parse("(List[String]) {}");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEString()), (Object)t);
    }

    public final void testCast2() {
        Expression expr = this.parse("(Collection[String]) {}");
        EClassifier t = expr.analyze(this.ec, this.issues);
        this.dumpIssues();
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)BuiltinMetaModel.getListType((EClassifier)EcorePackage.eINSTANCE.getEString()), (Object)t);
    }

    public final void testConstruction() {
        Expression expr = this.parse("new String");
        EClassifier t = expr.analyze(this.ec, this.issues);
        AnalyzationTest.assertEquals((int)0, (int)this.issues.size());
        AnalyzationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)t);
        expr = this.parse("new Unknown");
        t = expr.analyze(this.ec, this.issues);
        AnalyzationTest.assertEquals((int)1, (int)this.issues.size());
        AnalyzationTest.assertNull((Object)t);
    }
}

