/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.drivers.emf4atl;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModelElement;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ASMEMFModel
extends ASMModel {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    protected boolean unload = false;
    protected Set unregister = new HashSet();
    protected String resolveURI = null;
    protected boolean checkSameModel = true;
    protected Map modelElements = new HashMap();
    private Map classifiers = null;
    protected static ResourceSet resourceSet;
    protected static ASMEMFModel mofmm;
    private Resource extent;
    private Set referencedExtents = new HashSet();

    static {
        ASMEMFModel.init();
        mofmm = null;
    }

    public static ASMModel getMOF() {
        return mofmm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASMModelElement getASMModelElement(EObject object) {
        ASMModelElement ret = (ASMModelElement)this.modelElements.get(object);
        if (ret == null) {
            Map map = this.modelElements;
            synchronized (map) {
                ret = (ASMModelElement)this.modelElements.get(object);
                if (ret == null) {
                    ret = new ASMEMFModelElement(this.modelElements, this, object);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASMModelElement getClassifier(String name) {
        if (this.classifiers == null) {
            ASMEMFModel aSMEMFModel = this;
            synchronized (aSMEMFModel) {
                if (this.classifiers == null) {
                    this.classifiers = this.initClassifiersInAllExtents();
                }
            }
        }
        EObject eo = (EObject)this.classifiers.get(name);
        ASMModelElement ret = null;
        if (eo != null) {
            ret = this.getASMModelElement(eo);
        }
        return ret;
    }

    private Map initClassifiersInAllExtents() {
        HashMap classifiers = new HashMap();
        this.initClassifiers(this.getExtent().getContents().iterator(), classifiers, null);
        Iterator refExtents = this.referencedExtents.iterator();
        while (refExtents.hasNext()) {
            this.initClassifiers(((Resource)refExtents.next()).getContents().iterator(), classifiers, null);
        }
        return classifiers;
    }

    private void initClassifiers(Iterator i, Map classifiers, String base) {
        while (i.hasNext()) {
            String name;
            EObject eo = (EObject)i.next();
            if (eo instanceof EPackage) {
                name = ((EPackage)eo).getName();
                if (base != null) {
                    name = String.valueOf(base) + "::" + name;
                }
                this.initClassifiers(((EPackage)eo).eContents().iterator(), classifiers, name);
                continue;
            }
            if (eo instanceof EClassifier) {
                name = ((EClassifier)eo).getName();
                this.register(classifiers, name, eo);
                if (base == null) continue;
                name = String.valueOf(base) + "::" + name;
                this.register(classifiers, name, eo);
                continue;
            }
            this.initClassifiers(eo.eContents().iterator(), classifiers, base);
        }
    }

    private void register(Map classifiers, String name, EObject classifier) {
        if (classifiers.containsKey(name)) {
            logger.warning("metamodel contains several classifiers with same name: " + name);
        }
        classifiers.put(name, classifier);
    }

    public ASMModelElement findModelElement(String name) {
        ASMModelElement ret = null;
        ret = this.getClassifier(name);
        return ret;
    }

    public Set getElementsByType(ASMModelElement type) {
        LinkedHashSet ret = new LinkedHashSet();
        EClass t = (EClass)((ASMEMFModelElement)type).getObject();
        this.addElementsOfType(ret, (EClassifier)t, this.getExtent());
        return ret;
    }

    private void addElementsOfType(Set elements, EClassifier type, Resource res) {
        TreeIterator i = res.getAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!type.isInstance((Object)eo)) continue;
            elements.add(this.getASMModelElement(eo));
        }
    }

    public ASMModelElement newModelElement(ASMModelElement type) {
        ASMEMFModelElement ret = null;
        EClass t = (EClass)((ASMEMFModelElement)type).getObject();
        EObject eo = t.getEPackage().getEFactoryInstance().create(t);
        ret = (ASMEMFModelElement)this.getASMModelElement(eo);
        this.getExtent().getContents().add((Object)eo);
        return ret;
    }

    protected ASMEMFModel(String name, Resource extent, ASMEMFModel metamodel, boolean isTarget, ModelLoader ml) {
        super(name, (ASMModel)metamodel, isTarget, ml);
        this.extent = extent;
    }

    public static ASMEMFModel loadASMEMFModel(String name, ASMEMFModel metamodel, Resource extent, ModelLoader ml) throws Exception {
        ASMEMFModel ret = null;
        ret = new ASMEMFModel(name, extent, metamodel, false, ml);
        ret.addAllReferencedExtents(extent);
        ret.setIsTarget(false);
        ASMEMFModel.adaptMetamodel(ret, metamodel);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.extent != null) {
            this.referencedExtents.clear();
            this.referencedExtents = null;
            for (String nsURI : this.unregister) {
                ResourceSet resourceSet = ASMEMFModel.resourceSet;
                synchronized (resourceSet) {
                    ASMEMFModel.resourceSet.getPackageRegistry().remove((Object)nsURI);
                }
            }
            ResourceSet resourceSet = ASMEMFModel.resourceSet;
            synchronized (resourceSet) {
                ASMEMFModel.resourceSet.getResources().remove((Object)this.extent);
            }
            this.extent = null;
            this.modelElements.clear();
            this.unregister.clear();
        }
    }

    public void finalize() {
        this.dispose();
    }

    public static ASMEMFModel newASMEMFModel(String name, ASMEMFModel metamodel, ModelLoader ml) throws Exception {
        return ASMEMFModel.newASMEMFModel(name, name, metamodel, ml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASMEMFModel newASMEMFModel(String name, String uri, ASMEMFModel metamodel, ModelLoader ml) throws Exception {
        ASMEMFModel ret = null;
        Resource extent = null;
        ResourceSet resourceSet = ASMEMFModel.resourceSet;
        synchronized (resourceSet) {
            extent = ASMEMFModel.resourceSet.createResource(URI.createURI((String)uri));
        }
        ret = new ASMEMFModel(name, extent, metamodel, true, ml);
        ret.unload = true;
        return ret;
    }

    public static ASMEMFModel loadASMEMFModel(String name, ASMEMFModel metamodel, String url, ModelLoader ml) throws Exception {
        ASMEMFModel ret = null;
        if (url.startsWith("uri:")) {
            String uri = url.substring(4);
            ret = new ASMEMFModel(name, null, metamodel, false, ml);
            ret.resolveURI = uri;
        } else {
            ret = ASMEMFModel.loadASMEMFModel(name, metamodel, URI.createURI((String)url), ml);
        }
        return ret;
    }

    public static ASMEMFModel loadASMEMFModel(String name, ASMEMFModel metamodel, URL url, ModelLoader ml) throws Exception {
        ASMEMFModel ret = null;
        ret = ASMEMFModel.loadASMEMFModel(name, metamodel, url.openStream(), ml);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASMEMFModel loadASMEMFModel(String name, ASMEMFModel metamodel, URI uri, ModelLoader ml) throws Exception {
        ASMEMFModel ret = null;
        try {
            Resource extent = null;
            ResourceSet resourceSet = ASMEMFModel.resourceSet;
            synchronized (resourceSet) {
                extent = ASMEMFModel.resourceSet.getResource(uri, true);
            }
            ret = new ASMEMFModel(name, extent, metamodel, true, ml);
            ret.addAllReferencedExtents(extent);
            ret.setIsTarget(false);
            ret.unload = true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        ASMEMFModel.adaptMetamodel(ret, metamodel);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASMEMFModel loadASMEMFModel(String name, ASMEMFModel metamodel, InputStream in, ModelLoader ml) throws Exception {
        ASMEMFModel ret = ASMEMFModel.newASMEMFModel(name, metamodel, ml);
        try {
            ResourceSet resourceSet = ASMEMFModel.resourceSet;
            synchronized (resourceSet) {
                ret.getExtent().load(in, ASMEMFModel.resourceSet.getLoadOptions());
            }
            ret.addAllReferencedExtents(ret.getExtent());
            ret.unload = true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        ASMEMFModel.adaptMetamodel(ret, metamodel);
        ret.setIsTarget(false);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void adaptMetamodel(ASMEMFModel model, ASMEMFModel metamodel) {
        if (metamodel == mofmm) {
            for (ASMEMFModelElement ame : model.getElementsByType("EPackage")) {
                EPackage p = (EPackage)ame.getObject();
                String nsURI = p.getNsURI();
                if (nsURI == null) {
                    nsURI = p.getName();
                    p.setNsURI(nsURI);
                }
                if (resourceSet.getPackageRegistry().containsKey((Object)nsURI)) {
                    p.equals(resourceSet.getPackageRegistry().getEPackage(nsURI));
                } else {
                    model.unregister.add(nsURI);
                }
                ResourceSet resourceSet = ASMEMFModel.resourceSet;
                synchronized (resourceSet) {
                    ASMEMFModel.resourceSet.getPackageRegistry().put((Object)nsURI, (Object)p);
                }
            }
            for (ASMEMFModelElement ame : model.getElementsByType("EDataType")) {
                String tname = ((ASMString)ame.get(null, "name")).getSymbol();
                String icn = null;
                if (tname.equals("Boolean")) {
                    icn = "boolean";
                } else if (tname.equals("Double")) {
                    icn = "java.lang.Double";
                } else if (tname.equals("Float")) {
                    icn = "java.lang.Float";
                } else if (tname.equals("Integer")) {
                    icn = "java.lang.Integer";
                } else if (tname.equals("String")) {
                    icn = "java.lang.String";
                }
                if (icn == null) continue;
                ame.set(null, "instanceClassName", (ASMOclAny)new ASMString(icn));
            }
        }
    }

    public static ASMEMFModel createMOF(ModelLoader ml) {
        if (mofmm == null) {
            mofmm = new ASMEMFModel("MOF", EcorePackage.eINSTANCE.eResource(), null, false, ml);
        }
        return mofmm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getExtent() {
        if (this.extent == null && this.resolveURI != null) {
            ResourceSet resourceSet = ASMEMFModel.resourceSet;
            synchronized (resourceSet) {
                if (this.extent == null) {
                    EPackage pack = ASMEMFModel.resourceSet.getPackageRegistry().getEPackage(this.resolveURI);
                    Resource r = pack.eResource();
                    this.addAllReferencedExtents(r);
                    this.extent = r;
                }
            }
        }
        return this.extent;
    }

    private static void init() {
        Map etfm = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        if (!etfm.containsKey("*")) {
            etfm.put("*", new XMIResourceFactoryImpl());
        }
        resourceSet = new ResourceSetImpl();
        Map loadOptions = resourceSet.getLoadOptions();
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
    }

    public static ResourceSet getResourceSet() {
        return resourceSet;
    }

    public boolean equals(Object o) {
        return o instanceof ASMEMFModel && ((ASMEMFModel)((Object)o)).extent == this.extent;
    }

    public boolean isCheckSameModel() {
        return this.checkSameModel;
    }

    public void setCheckSameModel(boolean checkSameModel) {
        this.checkSameModel = checkSameModel;
    }

    protected void addAllReferencedExtents(Resource extent) {
        TreeIterator contents = extent.getAllContents();
        while (contents.hasNext()) {
            Object o = contents.next();
            if (!(o instanceof EClass)) continue;
            this.addReferencedExtentsFor((EClass)o, new HashSet());
        }
        this.referencedExtents.remove(extent);
    }

    private void addReferencedExtentsFor(EClass eClass, Set ignore) {
        if (ignore.contains(eClass)) {
            return;
        }
        ignore.add(eClass);
        for (EReference eRef : eClass.getEReferences()) {
            EClassifier eType = eRef.getEType();
            if (eType.eResource() != null) {
                this.referencedExtents.add(eType.eResource());
            } else {
                logger.warning("Resource for " + eType.toString() + " is null; cannot be referenced");
            }
            if (!(eType instanceof EClass)) continue;
            this.addReferencedExtentsFor((EClass)eType, ignore);
        }
        for (EAttribute eAtt : eClass.getEAttributes()) {
            EClassifier eType = eAtt.getEType();
            if (eType.eResource() != null) {
                this.referencedExtents.add(eType.eResource());
                continue;
            }
            logger.warning("Resource for " + eType.toString() + " is null; cannot be referenced");
        }
        for (EClass eSuper : eClass.getESuperTypes()) {
            if (eSuper.eResource() != null) {
                this.referencedExtents.add(eSuper.eResource());
                this.addReferencedExtentsFor(eSuper, ignore);
                continue;
            }
            logger.warning("Resource for " + eSuper.toString() + " is null; cannot be referenced");
        }
    }

    public Set getReferencedExtents() {
        return this.referencedExtents;
    }
}

