/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;

public class URIUtils {
    private URIUtils() {
    }

    public static IFile getFile(URI uri) {
        String scheme = uri.scheme();
        if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int j = 1;
            int size = uri.segmentCount();
            while (j < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(uri.segment(j));
                ++j;
            }
            try {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        if ("file".equals(scheme)) {
            return WorkspaceUtils.getIFile(uri.toFileString().toString());
        }
        return null;
    }

    public static void refresh(URI uri) {
        IFile file = URIUtils.getFile(uri);
        if (file != null) {
            try {
                file.getParent().refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
        }
    }
}

