/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.cst.PackageRefCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.HyperlinkUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.IHyperlinkDetectorHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.MetamodelElementHyperlink;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.StringLiteralExpCS;

public class ModelTypeHyperlinkDetector
implements IHyperlinkDetectorHelper {
    public IHyperlink detectHyperlink(IHyperlinkDetectorHelper.IDetectionContext context) {
        CSTNode syntaxElement = context.getSyntaxElement();
        EPackage ePackage = ModelTypeHyperlinkDetector.findReferencedPackageDefinition(syntaxElement);
        if (ePackage != null) {
            return new MetamodelElementHyperlink(HyperlinkUtil.createRegion(syntaxElement), (EModelElement)ePackage);
        }
        return null;
    }

    public static EPackage findReferencedPackageDefinition(CSTNode syntaxElement) {
        StringLiteralExpCS uriCS;
        PackageRefCS packageRefCS = null;
        if (syntaxElement instanceof PathNameCS && syntaxElement.eContainer() instanceof PackageRefCS) {
            packageRefCS = (PackageRefCS)syntaxElement.eContainer();
        } else if (syntaxElement instanceof StringLiteralExpCS && syntaxElement.eContainer() instanceof PackageRefCS && (packageRefCS = (PackageRefCS)syntaxElement.eContainer()).getUriCS() != syntaxElement) {
            return null;
        }
        if (packageRefCS != null && (uriCS = packageRefCS.getUriCS()) != null) {
            return ModelTypeHyperlinkDetector.findReferencedEPackage(uriCS);
        }
        return null;
    }

    private static EPackage findReferencedEPackage(StringLiteralExpCS uriLiteral) {
        QvtOperationalEnv env = ModelTypeHyperlinkDetector.getEnv((CSTNode)uriLiteral);
        if (env == null) {
            return null;
        }
        String id = uriLiteral.getStringSymbol();
        if (id == null || id.length() < 2) {
            return null;
        }
        id = id.substring(1, id.length() - 1);
        try {
            return env.getMetamodelRegistry().getMetamodelDesc(id).getModel();
        }
        catch (EmfException emfException) {
            return null;
        }
    }

    private static QvtOperationalEnv getEnv(CSTNode node) {
        return (QvtOperationalEnv)CSTHelper.getEnvironment(node);
    }
}

