/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2m.internal.qvt.oml.common.project.TransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.common.ui.controls.UniSelectTransformationControl;
import org.eclipse.m2m.internal.qvt.oml.common.ui.wizards.ITransformationSelector;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.QvtCompiledTransformationLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SelectInterpretedTransformationPage
extends WizardPage
implements ITransformationSelector {
    private QvtTransformation myTransformation;
    private final UniSelectTransformationControl.IResourceFilter myResourceFilter = new UniSelectTransformationControl.IResourceFilter(){

        public boolean accept(IResource resource) {
            return resource instanceof IFile && "qvto".equalsIgnoreCase(resource.getFileExtension());
        }
    };
    private UniSelectTransformationControl myControl;

    public SelectInterpretedTransformationPage(String pageId) {
        super(pageId);
        this.setDescription(Messages.SelectWorkspaceTransformationPage_Description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.doCreateControl(composite);
        this.setControl((Control)composite);
        this.setPageComplete(this.validatePage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.m2m.qvt.oml._transformation");
    }

    protected void doCreateControl(Composite parent) {
        this.myControl = new UniSelectTransformationControl(parent, this.myResourceFilter, (ILabelProvider)new QvtCompiledTransformationLabelProvider(), (TransformationRegistry)QvtTransformationRegistry.getInstance(), TransformationRegistry.EMPTY_FILTER);
        this.myControl.addSelectionListener(new UniSelectTransformationControl.ISelectionListener(){

            public void selectionChanged(URI uri) {
                SelectInterpretedTransformationPage.this.setPageComplete(SelectInterpretedTransformationPage.this.validatePage());
            }
        });
    }

    protected boolean validatePage() {
        QvtInterpretedTransformation transformation;
        String transfName;
        block5: {
            URI uri;
            block4: {
                this.setMessage(null);
                this.setErrorMessage(null);
                this.myTransformation = null;
                transfName = null;
                try {
                    uri = this.getSelectedUri();
                    if (uri != null) break block4;
                    return false;
                }
                catch (Exception e) {
                    this.setErrorMessage(e.getMessage());
                    return false;
                }
            }
            transformation = new QvtInterpretedTransformation(TransformationUtil.getQvtModule((URI)uri));
            List parameters = transformation.getParameters();
            if (!parameters.isEmpty()) break block5;
            this.setErrorMessage(NLS.bind((String)Messages.SelectWorkspaceTransformationPage_emptyTransformation, null));
            return false;
        }
        transfName = transformation.getModuleName();
        this.setMessage(NLS.bind((String)Messages.SelectWorkspaceTransformationPage_transformationSelected, (Object)transfName));
        this.myTransformation = transformation;
        return true;
    }

    public QvtTransformation getTransformation() {
        return this.myTransformation;
    }

    public void setSelectedTransformationId(String id) {
        this.myControl.selectTransformationByUri(id);
    }

    public String getSelectedTransformationId() {
        URI selectedUri = this.getSelectedUri();
        if (selectedUri == null) {
            return null;
        }
        return selectedUri.path();
    }

    private URI getSelectedUri() {
        return this.myControl != null ? this.myControl.getSelectedUri() : null;
    }
}

