/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.result;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationEvent;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityContainer;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityModel;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityRegion;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityTargetFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;

public class AcceleoResultContent
implements IAcceleoTextGenerationListener {
    private Map<String, TraceabilityTargetFile> targetFiles = new HashMap<String, TraceabilityTargetFile>();
    private TraceabilityTargetFile targetFile;
    private int targetFileOffset;

    public TraceabilityTargetFile[] getTargetFiles() {
        Collection<TraceabilityTargetFile> values = this.targetFiles.values();
        return values.toArray(new TraceabilityTargetFile[values.size()]);
    }

    public void filePathComputed(AcceleoTextGenerationEvent event) {
        String targetPath = new Path(event.getText()).toString();
        this.targetFile = new TraceabilityTargetFile(targetPath);
        this.targetFiles.put(targetPath, this.targetFile);
        this.targetFileOffset = 0;
    }

    public void textGenerated(AcceleoTextGenerationEvent event) {
        if (event.getText() != null && event.getText().length() > 0 && this.targetFile != null && event.getSource() != null) {
            TraceabilityModel model = this.getOrCreateModelInChildren(this.targetFile, event.getSource());
            TraceabilityRegion region = null;
            TraceabilityRegion lastRegion = model.getRegions().size() > 0 ? model.getRegions().get(model.getRegions().size() - 1) : null;
            if (lastRegion != null && event.getBlock() == lastRegion.getAstNode() && event.getSource() == model.getEObject() && lastRegion.getTargetFileOffset() + lastRegion.getTargetFileLength() == this.targetFileOffset) {
                region = lastRegion;
            }
            region = new TraceabilityRegion(this.targetFileOffset, event.getText().length(), event.getBlock());
            this.targetFileOffset += event.getText().length();
            model.getRegions().add(region);
            region.setParent(model);
        }
    }

    private TraceabilityModel getOrCreateModelInChildren(TraceabilityContainer parent, EObject eObject) {
        for (TraceabilityModel child : parent.getChildren()) {
            TraceabilityModel result = null;
            if (child.getEObject() == eObject) {
                result = child;
            } else if (this.ancestorOf(child.getEObject(), eObject)) {
                result = this.getOrCreateModelInChildren(child, eObject);
            }
            if (result == null) continue;
            return result;
        }
        TraceabilityModel newModel = new TraceabilityModel(eObject);
        HashSet<TraceabilityModel> toMove = new HashSet<TraceabilityModel>();
        for (TraceabilityModel sibling : parent.getChildren()) {
            if (!this.ancestorOf(newModel.getEObject(), sibling.getEObject())) continue;
            toMove.add(sibling);
        }
        for (TraceabilityModel next : toMove) {
            newModel.getChildren().add(next);
            next.setParent(newModel);
            parent.getChildren().remove(next);
        }
        parent.getChildren().add(newModel);
        newModel.setParent(parent);
        return newModel;
    }

    private boolean ancestorOf(EObject ancestor, EObject object) {
        EObject current = object.eContainer();
        while (current != null) {
            if (current == ancestor) {
                return true;
            }
            current = current.eContainer();
        }
        return false;
    }
}

