/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.configuration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.IColorManagerExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class JETTokenStyleManager
implements IColorManager,
IColorManagerExtension {
    private IPreferenceStore preferenceStore;
    protected Map colorTable = new HashMap(10);
    protected Map keyTable = new HashMap(10);
    protected Map tokenMap = new HashMap(10);

    public JETTokenStyleManager(IPreferenceStore store) {
        this.preferenceStore = store;
    }

    public void dispose() {
        Iterator e = this.colorTable.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
    }

    public Color getColor(RGB rgb) {
        Color color = (Color)this.colorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.colorTable.put(rgb, color);
        }
        return color;
    }

    public Color getColor(String key) {
        if (key == null) {
            return null;
        }
        RGB rgb = (RGB)this.keyTable.get(key);
        if (rgb == null) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)key);
            if (rgb == null) {
                return null;
            }
            this.keyTable.put(key, rgb);
        }
        return this.getColor(rgb);
    }

    public void bindColor(String key, RGB rgb) {
        Object value = this.keyTable.get(key);
        if (value != null) {
            throw new UnsupportedOperationException();
        }
        this.keyTable.put(key, rgb);
    }

    public void unbindColor(String key) {
        this.keyTable.remove(key);
    }

    public IToken getCachedToken(String id) {
        return (IToken)this.tokenMap.get(id);
    }

    public IToken requestToken(String id, String fgColorKey, String bgColorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        Token token;
        RGB rgb;
        if (fgColorKey != null && this.getColor(fgColorKey) == null) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)fgColorKey);
            this.unbindColor(fgColorKey);
            this.bindColor(fgColorKey, rgb);
        }
        if (bgColorKey != null && this.getColor(bgColorKey) == null) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)bgColorKey);
            this.unbindColor(bgColorKey);
            this.bindColor(bgColorKey, rgb);
        }
        if ((token = (Token)this.tokenMap.get(id)) == null) {
            token = new Token((Object)this.createTextAttribute(fgColorKey, bgColorKey, boldKey, italicKey, strikethroughKey, underlineKey));
            this.tokenMap.put(id, token);
        } else {
            token.setData((Object)this.createTextAttribute(fgColorKey, bgColorKey, boldKey, italicKey, strikethroughKey, underlineKey));
        }
        return token;
    }

    private TextAttribute createTextAttribute(String fgColorKey, String bgColorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        int style;
        Color fgColor = null;
        if (fgColorKey != null) {
            fgColor = this.getColor(fgColorKey);
        }
        Color bgColor = null;
        if (bgColorKey != null) {
            bgColor = this.getColor(bgColorKey);
        }
        int n = style = boldKey != null && this.preferenceStore.getBoolean(boldKey) ? 1 : 0;
        if (italicKey != null && this.preferenceStore.getBoolean(italicKey)) {
            style |= 2;
        }
        if (strikethroughKey != null && this.preferenceStore.getBoolean(strikethroughKey)) {
            style |= 0x20000000;
        }
        if (underlineKey != null && this.preferenceStore.getBoolean(underlineKey)) {
            style |= 0x40000000;
        }
        return new TextAttribute(fgColor, bgColor, style);
    }

    public IToken requestDefaultToken() {
        return this.requestToken("__jet_default_return_token", "AbstractTextEditor.Color.Foreground", "jet_default_background", null, null, null, null);
    }
}

