/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.taglib.AbstractContainerTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.UserRegionHelper;

public class UserRegionTag
extends AbstractContainerTag {
    private int userRegionOffset;
    private int initialCodeStart = -1;
    private int initialCodeEnd = -1;
    private String unmodifiedMarker = null;

    public void doAfterBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        if (!(out instanceof BufferedJET2Writer)) {
            throw new IllegalArgumentException();
        }
        UserRegionHelper.markUserRegion(out, this.userRegionOffset, ((BufferedJET2Writer)out).getContentLength());
        if (this.initialCodeStart >= 0) {
            UserRegionHelper.markInitialCode(out, this.initialCodeStart, this.initialCodeEnd, this.unmodifiedMarker);
        }
    }

    public void doBeforeBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        if (!(out instanceof BufferedJET2Writer)) {
            throw new IllegalArgumentException();
        }
        this.userRegionOffset = ((BufferedJET2Writer)out).getContentLength();
    }

    void setInitiaCodeRegion(int start, int end, String unmodifiedMarker) {
        this.initialCodeStart = start;
        this.initialCodeEnd = end;
        this.unmodifiedMarker = unmodifiedMarker;
    }
}

