/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler.templates;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.compiler.LoaderGenerationParameters;

public class JET2TransformGenerator
implements JET2Template {
    public void generate(JET2Context context, JET2Writer out) {
        LoaderGenerationParameters parms = (LoaderGenerationParameters)context.getVariable("args");
        Map templateMap = parms.getTemplateMap();
        out.write("package ");
        out.write(parms.getPackageName());
        out.write(";\r\n\r\nimport java.util.HashMap;\r\nimport java.util.Map;\r\n\r\nimport org.eclipse.jet.JET2TemplateLoader;\r\nimport org.eclipse.jet.JET2TemplateLoaderExtension;\r\nimport org.eclipse.jet.JET2Template;\r\n\r\npublic class ");
        out.write(parms.getClassName());
        out.write(" implements JET2TemplateLoader, JET2TemplateLoaderExtension {\r\n\r\n\tprivate static final class TemplateFactoryMethod {\r\n\r\n\t\tprivate final String templatePath;\r\n\t\tprivate final String templateClass;\r\n\r\n\t\tpublic TemplateFactoryMethod(String templatePath, String templateClass) {\r\n\t\t\tthis.templatePath = templatePath;\r\n\t\t\tthis.templateClass = templateClass;\r\n\t\t\t\r\n\t\t}\r\n\t\t\r\n\t\tpublic String getTemplateClass() {\r\n\t\t\treturn templateClass;\r\n\t\t}\r\n\r\n\t\tpublic String getTemplatePath() {\r\n\t\t\treturn templatePath;\r\n\t\t}\r\n\r\n\t\tpublic JET2Template newTemplate() {\r\n\t\t\tJET2Template template = null;\r\n\t\t\ttry {\r\n\t\t\t\ttemplate = (JET2Template) Class.forName(templateClass).newInstance();\r\n\t\t\t} catch (InstantiationException e) {\r\n\t\t\t} catch (IllegalAccessException e) {\r\n\t\t\t} catch (ClassNotFoundException e) {\r\n\t\t\t}\r\n\t\t\treturn template;\r\n\t\t}\r\n\t\t\r\n\t\t\r\n\t}\r\n\r\n\tprivate Map pathToFactoryMap = null;\r\n\t\r\n\tprivate JET2TemplateLoader delegate = null;\r\n\r\n\tpublic ");
        out.write(parms.getClassName());
        out.write("() {\r\n\t\tsuper();\r\n\t}\r\n\r\n\tpublic JET2Template getTemplate(String templatePath) {\r\n\t    if(pathToFactoryMap == null) {\r\n   \t        initPathToFactoryMap();\r\n        }\r\n        TemplateFactoryMethod factory = (TemplateFactoryMethod)pathToFactoryMap.get(templatePath);\r\n\t\treturn factory == null ? delegate == null ? null : delegate.getTemplate(templatePath) : factory.newTemplate();\r\n\t}\r\n\r\n\tprivate void addTemplate(String templatePath, String templateClass) {\r\n\t\tpathToFactoryMap.put(templatePath, //$NON-NLS-1$\r\n\t\t    new TemplateFactoryMethod(templatePath, templateClass));\r\n\t}\r\n\t\r\n    private void initPathToFactoryMap() {\r\n\t        pathToFactoryMap = new HashMap(");
        out.write(templateMap.size());
        out.write(");\r\n");
        Iterator i = templateMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            out.write("\t\t    addTemplate(\"");
            out.write(entry.getKey());
            out.write("\", \"");
            out.write(entry.getValue());
            out.write("\" ); //$NON-NLS-1$  //$NON-NLS-2$\r\n");
        }
        out.write("\t}\r\n\r\n    public void setDelegateLoader(JET2TemplateLoader loader) {\r\n        this.delegate = loader;\r\n    }\r\n    \r\n    public JET2TemplateLoader getDelegateLoader() {\r\n        return delegate;\r\n    }\r\n}\r\n\r\n");
    }
}

