/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionWithContext;

public class Function
extends ExprNode {
    private final XPathFunction function;
    private final List argExprs;
    private final boolean requiresContext;
    private final String functionName;

    public Function(String functionName, XPathFunction function, List argExprs) {
        this.functionName = functionName;
        this.function = function;
        this.argExprs = argExprs;
        this.requiresContext = function instanceof XPathFunctionWithContext;
    }

    public Object evalAsObject(Context context) {
        if (this.requiresContext) {
            ((XPathFunctionWithContext)((Object)this.function)).setContext(context);
        }
        ArrayList<Object> functionArgValues = new ArrayList<Object>(this.argExprs.size());
        Iterator i = this.argExprs.iterator();
        while (i.hasNext()) {
            ExprNode expr = (ExprNode)i.next();
            functionArgValues.add(expr.evalAsObject(context));
        }
        return this.function.evaluate(functionArgValues);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.functionName);
        buffer.append('(');
        Iterator i = this.argExprs.iterator();
        while (i.hasNext()) {
            ExprNode expr = (ExprNode)i.next();
            buffer.append(expr.toString());
            if (!i.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append(')');
        return buffer.toString();
    }
}

