/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.workspace;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.AbstractWorkspaceAction;
import org.eclipse.jet.taglib.workspace.ActionsUtil;
import org.eclipse.jet.taglib.workspace.IWorkspaceAction;

public class WsFileFromWriterAction
extends AbstractWorkspaceAction
implements IWorkspaceAction {
    private final IFile file;
    private final JET2Writer writer;
    private String encoding;
    private final boolean replace;
    private final boolean derived;
    private final JET2Context context;

    public WsFileFromWriterAction(JET2Context context, String templatePath, TagInfo tagInfo, IFile file, JET2Writer writer, boolean replace, boolean derived) {
        super(tagInfo, templatePath);
        this.context = context;
        this.file = file;
        this.writer = writer;
        this.replace = replace;
        this.derived = derived;
    }

    public IResource getResource() {
        return this.file;
    }

    public boolean requiresValidateEdit() {
        return this.replace && this.file.exists() && this.file.isReadOnly();
    }

    public void performAction(IProgressMonitor monitor) throws JET2TagException {
        String fileMessage = MessageFormat.format(JET2Messages.WsFileFromWriterAction_WritingFile, this.file.getFullPath().toString());
        ActionsUtil.writeTextFileFromWriter(this.file, this.replace, this.encoding, this.derived, this.writer, monitor);
        RuntimeLoggerContextExtender.log(this.context, fileMessage, this.getTagInfo(), this.getTemplatePath(), 3);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

