/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.functions;

import java.util.List;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionMetaData;
import org.eclipse.jet.xpath.XPathFunctionWithContext;
import org.eclipse.jet.xpath.XPathUtil;

public class NormalizeSpaceFunction
implements XPathFunction,
XPathFunctionWithContext {
    public static final XPathFunctionMetaData FUNCTION_META_DATA = new XPathFunctionMetaData("normalize-space", null, new NormalizeSpaceFunction(), 0, 1);
    private Context context;

    public Object evaluate(List args) {
        String arg = args.size() == 0 ? XPathUtil.xpathString(this.context.getContextNode()) : XPathUtil.xpathString(args.get(0));
        return NormalizeSpaceFunction.normalizeSpace(arg);
    }

    public static String normalizeSpace(String arg) {
        boolean stripNextSpace = true;
        StringBuffer result = new StringBuffer(arg);
        int i = 0;
        while (i < result.length()) {
            if (Character.isWhitespace(result.charAt(i))) {
                if (stripNextSpace) {
                    result.deleteCharAt(i);
                    --i;
                } else {
                    stripNextSpace = true;
                }
            } else {
                stripNextSpace = false;
            }
            ++i;
        }
        int lastCharIndex = result.length() - 1;
        if (lastCharIndex >= 0 && Character.isWhitespace(result.charAt(lastCharIndex))) {
            result.deleteCharAt(lastCharIndex);
        }
        return result.toString();
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

