/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jet.ContextLogEntry;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.runtime.RuntimeTagLogger;
import org.eclipse.jet.taglib.TagInfo;

public final class RuntimeLoggerContextExtender {
    private static String PRIVATE_CONTEXT_DATA_KEY;
    private static final LogState NO_LISTENERS;
    public static final int ERROR_LEVEL = 5;
    public static final int WARNING_LEVEL = 4;
    public static final int INFO_LEVEL = 3;
    public static final int TRACE_LEVEL = 2;
    public static final int DEBUG_LEVEL = 1;
    private final ContextData contextData;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PRIVATE_CONTEXT_DATA_KEY = clazz.getName();
        NO_LISTENERS = new LogState(){

            public void log(String message, TagInfo td, String templatePath, int level) {
            }
        };
    }

    public static RuntimeLoggerContextExtender getInstance(JET2Context context) {
        if (context == null) {
            throw new NullPointerException();
        }
        RuntimeLoggerContextExtender ex = (RuntimeLoggerContextExtender)context.getPrivateData(PRIVATE_CONTEXT_DATA_KEY);
        if (ex == null) {
            ex = new RuntimeLoggerContextExtender(context, new ContextData());
            context.addPrivateData(PRIVATE_CONTEXT_DATA_KEY, (Object)ex);
        }
        return ex;
    }

    private RuntimeLoggerContextExtender(JET2Context context, ContextData contextData) {
        context.addLogListener((JET2Context.LogListener)contextData);
        this.contextData = contextData;
    }

    public void addListener(RuntimeTagLogger tagLogger) {
        this.contextData.addListener(tagLogger);
    }

    public void removeListener(RuntimeTagLogger tagLogger) {
        this.contextData.removeListener(tagLogger);
    }

    public static void log(JET2Context context, String message, TagInfo td, int level) {
        RuntimeLoggerContextExtender.getInstance((JET2Context)context).contextData.log(message, td, context.getTemplatePath(), level);
    }

    public static void log(JET2Context context, String message, TagInfo tagInfo, String templatePath, int level) {
        RuntimeLoggerContextExtender.getInstance((JET2Context)context).contextData.log(message, tagInfo, templatePath, level);
    }

    private static final class ContextData
    implements JET2Context.LogListener {
        private final List listeners = new ArrayList();
        private LogState state = RuntimeLoggerContextExtender.access$0();

        private ContextData() {
        }

        public void log(String message, TagInfo td, String templatePath, int level) {
            this.state.log(message, td, templatePath, level);
        }

        public void log(ContextLogEntry entry) {
            StringBuffer logMessage = new StringBuffer(entry.getMessage());
            ContextLogEntry[] children = entry.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendChildMessage(logMessage, children[i], 1);
                ++i;
            }
            this.state.log(logMessage.toString(), entry.getTagInfo(), entry.getTemplatePath(), this.getLevel(entry.getSeverity()));
        }

        private void appendChildMessage(StringBuffer logMessage, ContextLogEntry entry, int depth) {
            if (logMessage.charAt(logMessage.length() - 1) != '\n') {
                logMessage.append('\n');
            }
            int i = 0;
            while (i < depth) {
                logMessage.append('\t');
                ++i;
            }
            logMessage.append(entry.getMessage());
            ContextLogEntry[] children = entry.getChildren();
            int i2 = 0;
            while (i2 < children.length) {
                this.appendChildMessage(logMessage, children[i2], depth + 1);
                ++i2;
            }
        }

        private int getLevel(int severity) {
            switch (severity) {
                case 4: 
                case 8: {
                    return 5;
                }
                case 2: {
                    return 4;
                }
                case 0: 
                case 1: {
                    return 3;
                }
            }
            return 5;
        }

        public void addListener(RuntimeTagLogger tagLogger) {
            this.listeners.add(tagLogger);
            this.updateState();
        }

        public void removeListener(RuntimeTagLogger tagLogger) {
            this.listeners.remove(tagLogger);
            this.updateState();
        }

        public void updateState() {
            switch (this.listeners.size()) {
                case 0: {
                    this.state = NO_LISTENERS;
                    break;
                }
                case 1: {
                    this.state = new OneListenerState((RuntimeTagLogger)this.listeners.get(0));
                    break;
                }
                default: {
                    this.state = new MultipleListenerState(this.listeners);
                }
            }
        }
    }

    private static interface LogState {
        public void log(String var1, TagInfo var2, String var3, int var4);
    }

    private static final class MultipleListenerState
    implements LogState {
        private final RuntimeTagLogger[] listeners;
        private int listenersLength;

        public MultipleListenerState(List listeners) {
            this.listeners = listeners.toArray(new RuntimeTagLogger[listeners.size()]);
            this.listenersLength = this.listeners.length;
        }

        public void log(String message, TagInfo td, String templatePath, int level) {
            int i = 0;
            while (i < this.listenersLength) {
                this.listeners[i].log(message, td, templatePath, level);
                ++i;
            }
        }
    }

    private static final class OneListenerState
    implements LogState {
        private final RuntimeTagLogger runtimeTagLogger;

        public OneListenerState(RuntimeTagLogger runtimeTagLogger) {
            this.runtimeTagLogger = runtimeTagLogger;
        }

        public void log(String message, TagInfo td, String templatePath, int level) {
            this.runtimeTagLogger.log(message, td, templatePath, level);
        }
    }
}

