/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.ast;

import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.XtendFile;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportStatement
extends SyntaxElement {
    private Identifier importedId;
    private boolean exported;

    public ImportStatement(Identifier importedID, boolean exported) {
        this.importedId = importedID;
        this.exported = exported;
    }

    public Identifier getImportedId() {
        return this.importedId;
    }

    public boolean isExported() {
        return this.exported;
    }

    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            XtendFile xf;
            if (ctx.getCallback() != null) {
                ctx.getCallback().pre(this, ctx);
            }
            if ((xf = (XtendFile)ctx.getResourceManager().loadResource(this.getImportedId().getValue(), "ext")) == null) {
                String msg = "Error while importing extension: File " + this.getImportedId().getValue() + " not found.";
                issues.add(new AnalysationIssue(AnalysationIssue.RESOURCE_NOT_FOUND, msg, this));
                return;
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(null);
            }
        }
    }
}

