/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.ast.StatementWithBody;
import org.eclipse.internal.xpand2.type.XpandIterator;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEachStatement
extends StatementWithBody {
    private Expression target;
    private Expression separator;
    private Identifier variable;
    private Identifier iteratorName;
    static String indent = "";

    public ForEachStatement(Identifier variable, Expression target, Statement[] body, Expression separator, Identifier iterator) {
        super(body);
        this.variable = variable;
        this.target = target;
        this.separator = separator;
        this.iteratorName = iterator;
    }

    public Expression getSeparator() {
        return this.separator;
    }

    public Expression getTarget() {
        return this.target;
    }

    public Identifier getVariable() {
        return this.variable;
    }

    public Identifier getIteratorName() {
        return this.iteratorName;
    }

    @Override
    public void analyzeInternal(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type t = this.getTarget().analyze((ExecutionContext)ctx, issues);
        if (this.getSeparator() != null) {
            Type sepT = this.getSeparator().analyze((ExecutionContext)ctx, issues);
            if (!ctx.getStringType().isAssignableFrom(sepT)) {
                issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "String expected!", (SyntaxElement)this.target));
            }
        }
        if (t != null) {
            if (ctx.getCollectionType(ctx.getObjectType()).isAssignableFrom(t)) {
                t = t instanceof ParameterizedType ? ((ParameterizedType)t).getInnerType() : ctx.getObjectType();
            } else {
                issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "Collection type expected!", (SyntaxElement)this.target));
                return;
            }
        }
        ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(this.getVariable().getValue(), (Object)t));
        if (this.iteratorName != null) {
            ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(this.iteratorName.getValue(), (Object)ctx.getTypeForName("xpand2::Iterator")));
        }
        int i = 0;
        while (i < this.getBody().length) {
            this.getBody()[i].analyze(ctx, issues);
            ++i;
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        ArrayList o = this.getTarget().evaluate((ExecutionContext)ctx);
        if (o == null) {
            o = new ArrayList();
        }
        if (!(o instanceof Collection)) {
            throw new EvaluationException("Collection expected!", (SyntaxElement)this.getTarget(), (ExecutionContext)ctx);
        }
        Collection col = o;
        String sep = (String)(this.getSeparator() != null ? this.getSeparator().evaluate((ExecutionContext)ctx) : null);
        XpandIterator iterator = new XpandIterator(col.size());
        if (this.iteratorName != null) {
            ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(this.iteratorName.getValue(), (Object)iterator));
        }
        indent = String.valueOf(indent) + "  ";
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(this.getVariable().getValue(), element));
            ctx.preTask(this);
            int i = 0;
            while (i < this.getBody().length) {
                this.getBody()[i].evaluate(ctx);
                ++i;
            }
            ctx.postTask(this);
            if (sep != null && iter.hasNext()) {
                ctx.getOutput().write(sep);
            }
            iterator.increment();
        }
        indent = indent.substring(2);
    }

    public String getNameString(ExecutionContext context) {
        return "FOREACH";
    }
}

