/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.ResourceContributor;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandBuilder;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandMarkerManager;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandNature;
import org.eclipse.xtend.shared.ui.core.internal.JDTUtil;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

public class XtendXpandProject
implements IXtendXpandProject {
    private static final Set<IJavaProject> initializing = new HashSet<IJavaProject>();
    final IJavaProject project;
    private final Map<ResourceID, IXtendXpandResource> resources = new HashMap<ResourceID, IXtendXpandResource>();
    private Set<ResourceID> fromJar = new HashSet<ResourceID>();

    public XtendXpandProject(IJavaProject resource) {
        this.project = resource;
        try {
            IProject[] ps = this.project.getProject().getReferencedProjects();
            int i = 0;
            while (i < ps.length) {
                if (initializing.add(this.project)) {
                    try {
                        Activator.getExtXptModelManager().findProject((IResource)ps[i]);
                    }
                    finally {
                        initializing.remove(this.project);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        JavaCore.addElementChangedListener((IElementChangedListener)new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                if (XtendXpandProject.this.fromJar.isEmpty()) {
                    return;
                }
                if (XtendXpandProject.this.containsRemovedClassPathEntry(event.getDelta().getAffectedChildren())) {
                    XtendXpandProject.this.removeResourcesFromJar();
                }
            }
        }, (int)1);
        Job j = new Job("Initializing " + this.project.getElementName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IProject p = XtendXpandProject.this.project.getProject();
                    if (p.isAccessible() && p.isNatureEnabled(XtendXpandNature.NATURE_ID)) {
                        p.build(15, XtendXpandBuilder.getBUILDER_ID(), new HashMap(), monitor);
                    }
                }
                catch (CoreException e) {
                    XtendLog.logError(e);
                }
                return Status.OK_STATUS;
            }
        };
        j.setRule(this.project.getResource().getWorkspace().getRuleFactory().buildRule());
        j.schedule();
    }

    protected boolean containsRemovedClassPathEntry(IJavaElementDelta[] affectedChildren) {
        int i = 0;
        while (i < affectedChildren.length) {
            IJavaElementDelta delta = affectedChildren[i];
            if ((delta.getFlags() & 0x80) != 0) {
                return true;
            }
            if (this.containsRemovedClassPathEntry(delta.getAffectedChildren())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void removeResourcesFromJar() {
        for (ResourceID id : this.fromJar) {
            this.resources.remove(id);
        }
    }

    public IXtendXpandResource[] getRegisteredResources() {
        return this.resources.values().toArray(new IXtendXpandResource[this.resources.size()]);
    }

    public IXtendXpandResource[] getAllRegisteredResources() {
        HashSet result = new HashSet();
        result.addAll(Arrays.asList(this.getRegisteredResources()));
        IXtendXpandProject[] iXtendXpandProjectArray = this.getAllReferencedProjects();
        int n = iXtendXpandProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandProject p = iXtendXpandProjectArray[n2];
            result.addAll(Arrays.asList(p.getRegisteredResources()));
            ++n2;
        }
        return result.toArray(new IXtendXpandResource[this.resources.size()]);
    }

    public IXtendXpandProject[] getReferencedProjects() {
        HashSet<IXtendXpandProject> result = new HashSet<IXtendXpandProject>();
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = this.getProject().getProject().getReferencedProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IXtendXpandProject p = Activator.getExtXptModelManager().findProject((IResource)project);
                if (p != null) {
                    result.add(p);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        return result.toArray(new IXtendXpandProject[result.size()]);
    }

    public IXtendXpandProject[] getAllReferencedProjects() {
        HashSet result = new HashSet();
        IXtendXpandProject[] projects = this.getReferencedProjects();
        result.addAll(Arrays.asList(projects));
        IXtendXpandProject[] iXtendXpandProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IXtendXpandProject project = iXtendXpandProjectArray[n2];
            result.addAll(Arrays.asList(project.getAllReferencedProjects()));
            ++n2;
        }
        return result.toArray(new IXtendXpandProject[result.size()]);
    }

    public IJavaProject getProject() {
        return this.project;
    }

    public void unregisterOawResource(IXtendXpandResource res) {
        if (res != null) {
            if (res.getUnderlyingStorage() instanceof IFile) {
                XtendXpandMarkerManager.deleteMarkers((IResource)((IFile)res.getUnderlyingStorage()));
            }
            this.resources.remove(new ResourceID(res.getFullyQualifiedName(), res.getFileExtension()));
        }
    }

    public IXtendXpandResource findExtXptResource(String fqn, String extension) {
        assert (fqn != null);
        assert (extension != null);
        if (Activator.getRegisteredResourceContributorFor(extension) == null) {
            return null;
        }
        IXtendXpandResource res = this.findCachedOawResource(fqn, extension);
        if (res != null) {
            return res;
        }
        res = this.loadOawResource(fqn, extension, false);
        if (res != null) {
            return res;
        }
        return this.loadOawResource(fqn, extension, true);
    }

    private IXtendXpandResource findCachedOawResource(String fqn, String extension) {
        IXtendXpandResource res = this.resources.get(new ResourceID(fqn, extension));
        if (res == null) {
            return null;
        }
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember(res.getUnderlyingStorage().getFullPath());
        if (workspaceResource != null && workspaceResource.exists()) {
            return res;
        }
        this.resources.remove(new ResourceID(fqn, extension));
        return null;
    }

    private IXtendXpandResource loadOawResource(String fqn, String extension, boolean searchJars) {
        assert (fqn != null);
        assert (extension != null);
        IStorage storage = JDTUtil.findStorage(this.project, new ResourceID(fqn, extension), searchJars);
        if (storage != null && (searchJars || storage instanceof IFile)) {
            IXtendXpandResource result = null;
            String fileExtension = storage.getName().substring(storage.getName().lastIndexOf(".") + 1);
            ResourceContributor contr = Activator.getRegisteredResourceContributorFor(fileExtension);
            if (contr != null && (result = contr.create(storage, fqn)) != null) {
                this.resources.put(new ResourceID(fqn, extension), result);
                if (!(storage instanceof IFile)) {
                    this.fromJar.add(new ResourceID(fqn, extension));
                }
                return result;
            }
        }
        try {
            IProject[] p = this.project.getProject().getReferencedProjects();
            int i = 0;
            while (i < p.length) {
                IXtendXpandResource result;
                IProject project = p[i];
                XtendXpandProject oawp = (XtendXpandProject)Activator.getExtXptModelManager().findProject((IResource)project);
                if (oawp != null && (result = oawp.loadOawResource(fqn, extension, searchJars)) != null) {
                    return result;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        return null;
    }

    public IXtendXpandResource findOawResource(IStorage file) {
        if (file == null) {
            return null;
        }
        ResourceID id = JDTUtil.findOawResourceID(this.project, file);
        if (id == null) {
            return null;
        }
        return this.findExtXptResource(id.name, id.extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(IProgressMonitor monitor) {
        Iterator<IXtendXpandResource> iter = new ArrayList<IXtendXpandResource>(this.resources.values()).iterator();
        while (iter.hasNext()) {
            IXtendXpandResource resource;
            if (monitor.isCanceled()) {
                return;
            }
            IXtendXpandResource iXtendXpandResource = resource = iter.next();
            synchronized (iXtendXpandResource) {
                resource.analyze();
            }
            monitor.worked(1);
        }
    }

    public String toString() {
        return this.project.getPath().toString();
    }
}

